package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售订单统计对象
 *
 * @author 天泽
 * @since 2022-08-24
 */
@ApiModel(value = "SalesOrderStatisticsQueryDto", description = "销售订单发货Eo对象")
@Data
public class SalesOrderStatisticsQueryDto implements Serializable {

    /**
     * 发货日期
     */
    @ApiModelProperty(name = "deliverGoodsDate", value = "发货日期")
    private String deliverGoodsDate;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = " 组织id")
    private Long organizationId;

    @ApiModelProperty(name = "type", value = "1:营养家，2：其他出库")
    private Integer type;

    private Date startTime;
    private Date endTime;

}
