package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "IntransitCargoRespDto", description = "在途货品数量响应DTO")
public class IntransitCargoRespDto implements Serializable {

    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;

    @ApiModelProperty(name = "logicWarehouseId", value = "逻辑仓ID")
    private Long logicWarehouseId;

    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;

    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称")
    private String logicWarehouseName;

    @ApiModelProperty(name = "intransitWarehouseId", value = "在途仓ID")
    private String intransitWarehouseId;

    @ApiModelProperty(name = "intransitWarehouseCode", value = "在途仓编码")
    private String intransitWarehouseCode;

    @ApiModelProperty(name = "intransitWarehouseName", value = "在途仓名称")
    private String intransitWarehouseName;

    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    @ApiModelProperty(name = "expireTime", value = "到期日期")
    private Date expireTime;

    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;

    @ApiModelProperty(name = "driverName", value = "驾驶员名称")
    private String driverName;

    @ApiModelProperty(name = "driverPhone", value = "驾驶员联系方式")
    private String driverPhone;

    @ApiModelProperty(name = "num", value = "在途数量")
    private BigDecimal num;

    @ApiModelProperty(name = "planArriveTime", value = "预计到达时间")
    private Date planArriveTime;

    @ApiModelProperty(name = "diffDay", value = "距离目前剩余天数")
    private Integer diffDay;

}
