package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 寻源日志Eo对象
*
* @author yuangui
* @since 2022-04-19
*/
@ApiModel(value = "SgSourceLogReqDto", description = "寻源日志Eo对象")
public class SgSourceLogReqDto extends RequestDto{
    @ApiModelProperty(
            value = "分页数"
    )
    private Integer pageNum=1;
    @ApiModelProperty(
            value = "分页大小"
    )
    private Integer pageSize=10;
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  寻源单id
    */
    @ApiModelProperty(name = "sgOrderId", value = "寻源单id")
    private Long sgOrderId;
    /**
    *  寻源凭证
    */
    @ApiModelProperty(name = "sgVoucherNo", value = "寻源凭证")
    private String sgVoucherNo;
    /**
    *  寻源单号
    */
    @ApiModelProperty(name = "sgOrderNo", value = "寻源单号")
    private String sgOrderNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "linkOrderNo", value = "关联单据号")
    private String linkOrderNo;
    /**
    *  关联单据类型，SALE_ORDER:销售订单、OTHER_OUT_ORDER:其他出库单
    */
    @ApiModelProperty(name = "linkOrderType", value = "关联单据类型，SALE_ORDER:销售订单、OTHER_OUT_ORDER:其他出库单")
    private String linkOrderType;
    /**
    *  寻源状态，WAIT_SOURCE:待寻源、SOURCING:寻源中、SOURCE_FAIL:寻源失败、SOURCE_SUCCESS:寻源成功、CANCEL:已取消
    */
    @ApiModelProperty(name = "sgStatus", value = "寻源状态，WAIT_SOURCE:待寻源、SOURCING:寻源中、SOURCE_FAIL:寻源失败、SOURCE_SUCCESS:寻源成功、CANCEL:已取消")
    private String sgStatus;
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private Date beginTime;
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private Date endTime;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setSgOrderId(Long sgOrderId){
    this.sgOrderId = sgOrderId;
    }
    public Long getSgOrderId(){
    return this.sgOrderId;
    }
    public void setSgVoucherNo(String sgVoucherNo){
    this.sgVoucherNo = sgVoucherNo;
    }
    public String getSgVoucherNo(){
    return this.sgVoucherNo;
    }
    public void setSgOrderNo(String sgOrderNo){
    this.sgOrderNo = sgOrderNo;
    }
    public String getSgOrderNo(){
    return this.sgOrderNo;
    }
    public void setLinkOrderNo(String linkOrderNo){
    this.linkOrderNo = linkOrderNo;
    }
    public String getLinkOrderNo(){
    return this.linkOrderNo;
    }
    public void setLinkOrderType(String linkOrderType){
    this.linkOrderType = linkOrderType;
    }
    public String getLinkOrderType(){
    return this.linkOrderType;
    }
    public void setSgStatus(String sgStatus){
    this.sgStatus = sgStatus;
    }
    public String getSgStatus(){
    return this.sgStatus;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}
