/**
 * @(#) AddressVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 地址、区域实体
 */
@Data
@ApiModel(value = "AddressVO", description = "地址、区域实体")
public class AddressVO {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id;
  
  
  @ApiModelProperty(name="province", value = "省份名称")
  @JsonProperty("province")
  private String province;
  
  
  @ApiModelProperty(name="provinceCode", value = "省份编码")
  @JsonProperty("provinceCode")
  private String provinceCode;
  
  
  @ApiModelProperty(name="city", value = "城市名称")
  @JsonProperty("city")
  private String city;
  
  
  @ApiModelProperty(name="cityCode", value = "城市编码")
  @JsonProperty("cityCode")
  private String cityCode;
  
  
  @ApiModelProperty(name="district", value = "区县名称")
  @JsonProperty("district")
  private String district;
  
  
  @ApiModelProperty(name="districtCode", value = "区县编码")
  @JsonProperty("districtCode")
  private String districtCode;
  
  
  @ApiModelProperty(name="street", value = "乡镇、街道")
  @JsonProperty("street")
  private String street;
  
  
  @ApiModelProperty(name="streetCode", value = "乡镇、街道编码")
  @JsonProperty("streetCode")
  private String streetCode;
  
  
  @ApiModelProperty(name="detailAddress", value = "详细地址")
  @JsonProperty("detailAddress")
  private String detailAddress;
  
}

