/**
 * @(#) GetSaleOrderListPageParams.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * GetSaleOrderListPageEsParams
 */
@Data
@ApiModel(value = "GetSaleOrderListPageEsParams", description = "")
public class GetSaleOrderListPageEsParams extends EsBaseReqParams{


  @ApiModelProperty(name="saleOrderCreateTimeStart", value = "创建时间开始")
  @JsonProperty("saleOrderCreateTimeStart")
  private String saleOrderCreateTimeStart;
  
  
  @ApiModelProperty(name="saleOrderCreateTimeEnd", value = "创建时间结束")
  @JsonProperty("saleOrderCreateTimeEnd")
  private String saleOrderCreateTimeEnd;




  @ApiModelProperty(name="saleOrderCreateTimeStartDate", value = "创建时间开始Date")
  @JsonProperty("saleOrderCreateTimeStartDate")
  private Date saleOrderCreateTimeStartDate;


  @ApiModelProperty(name="saleOrderCreateTimeEndDate", value = "创建时间结束Date")
  @JsonProperty("saleOrderCreateTimeEndDate")
  private Date saleOrderCreateTimeEndDate;
  
  
  @ApiModelProperty(name="orderRemark", value = "订单备注")
  @JsonProperty("orderRemark")
  private String orderRemark;
  
  
  @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;
  
  
  @ApiModelProperty(name="orderNo", value = "平台订单号/内部销售订单号")
  @JsonProperty("orderNo")
  private String orderNo;
  
  
  @ApiModelProperty(name="shopName", value = "店铺名称")
  @JsonProperty("shopName")
  private String shopName;
  
  
  @ApiModelProperty(name="orderSource", value = "订单来源")
  @JsonProperty("orderSource")
  private String orderSource;
  
  
  @ApiModelProperty(name="sellerName", value = "发货方")
  @JsonProperty("sellerName")
  private String sellerName;
  

  @ApiModelProperty(name="sellerCode", value = "物理仓编码（发货方）")
  @JsonProperty("sellerCode")
  private String sellerCode;


  @ApiModelProperty(name="customerCode", value = "客户编码")
  @JsonProperty("customerCode")
  private String customerCode;


  @ApiModelProperty(name="customerName", value = "客户名称")
  @JsonProperty("customerName")
  private String customerName;
  
  
  @ApiModelProperty(name="deliveryName", value = "收货人")
  @JsonProperty("deliveryName")
  private String deliveryName;
  
  
  @ApiModelProperty(name="deliveryPhone", value = "收货人电话")
  @JsonProperty("deliveryPhone")
  private String deliveryPhone;
  
  
  @ApiModelProperty(name="detailAddress", value = "收货地址")
  @JsonProperty("detailAddress")
  private String detailAddress;
  
  
  @ApiModelProperty(name="updateTimeStart", value = "更新时间开始")
  @JsonProperty("updateTimeStart")
  private String updateTimeStart;
  
  
  @ApiModelProperty(name="updateTimeEnd", value = "更新时间结束")
  @JsonProperty("updateTimeEnd")
  private String updateTimeEnd;




  @ApiModelProperty(name="updateTimeStartDate", value = "更新时间开始Date")
  @JsonProperty("updateTimeStartDate")
  private Date updateTimeStartDate;


  @ApiModelProperty(name="updateTimeEndDate", value = "更新时间结束Date")
  @JsonProperty("updateTimeEndDate")
  private Date updateTimeEndDate;
  
  
  @ApiModelProperty(name="logisticsCompany", value = "承运商/物流公司")
  @JsonProperty("logisticsCompany")
  private String logisticsCompany;




  @ApiModelProperty(name ="interceptInfoFlag",value = "拦截信息标识（0:否，1:是）")
  private String interceptInfoFlag;

  @ApiModelProperty(name="interceptInfo", value = "拦截信息")
  @JsonProperty("interceptInfo")
  private String interceptInfo;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson;
  
  
  @ApiModelProperty(name="deliveryTimeStart", value = "发货时间开始")
  @JsonProperty("deliveryTimeStart")
  private String deliveryTimeStart;
  
  
  @ApiModelProperty(name="deliveryTimeEnd", value = "发货时间结束")
  @JsonProperty("deliveryTimeEnd")
  private String deliveryTimeEnd;




  @ApiModelProperty(name="deliveryTimeStartDate", value = "发货时间开始Date")
  @JsonProperty("deliveryTimeStartDate")
  private Date deliveryTimeStartDate;


  @ApiModelProperty(name="deliveryTimeEndDate", value = "发货时间结束Date")
  @JsonProperty("deliveryTimeEndDate")
  private Date deliveryTimeEndDate;


  @ApiModelProperty(name="saleOrderStatus", value = "销售订单状态")
  @JsonProperty("saleOrderStatus")
  private String saleOrderStatus;

  @ApiModelProperty( name = "originalOrderNo",value = "原订单号（订单被拆分前对应的订单号）")
  private String originalOrderNo;

  @ApiModelProperty( name = "splitStatus",value = "拆分状态：0-未拆分 1-已拆分")
  private String splitStatus;

  @ApiModelProperty( name = "splitLevel",value = "拆单序号")
  private String splitLevel;

  @ApiModelProperty( name = "cityCode",value = "市编码")
  private String cityCode;

  @ApiModelProperty( name = "districtCode",value = "区编码")
  private String districtCode;

  @ApiModelProperty( name = "provinceCode",value = "省编码")
  private String provinceCode;

  @ApiModelProperty( name = "goodsSku",value = "商品长编码")
  private String goodsSku;

  @ApiModelProperty( name = "platformParentOrderNo",value = "渠道父订单")
  private String platformParentOrderNo;

  @ApiModelProperty( name = "orderType",value = "订单类型")
  private String orderType;
  /**
   * 是否对接财务中台或eas平台 0否;1是，默认1
   */
  @ApiModelProperty(name = "ifButtThirdParty",value ="是否对接财务中台或eas平台 0否;1是，默认1" )
  private Integer ifButtThirdParty;

  @ApiModelProperty(name = "orderBizType", value = "订单业务类型  0:信控前置（不需要eas审批订单自动发货）1:信控后置（需要到eas系统审核订单发货）")
  private Integer orderBizType;


  /**
   *  渠道仓编码
   */
  @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓编码")
  private String channelWarehouseCode;

  /**
   * 指定供货仓
   */
  @ApiModelProperty(name = "storagePlace",value = "指定供货仓")
  private String storagePlaceName;

  @ApiModelProperty(name = "channelWarehouseCodeList",value = "渠道仓编码集合")
  @JsonProperty("channelWarehouseCodeList")
  private List<String> channelWarehouseCodeList;

  @ApiModelProperty(name = "storagePlaceList",value = "供货仓编码集合")
  @JsonProperty("storagePlaceList")
  private List<String> storagePlaceList;
  /**
   * 指定供货仓
   */
  @ApiModelProperty(name = "storagePlace",value = "指定供货仓")
  private String storagePlace;

  /**
   *  物理仓名称
   */
  @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
  private String physicsWarehouseName;

  /**
   *  物理仓名称
   */
  @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
  private String physicsWarehouseCode;

  /**
   * 串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0
   */
  @ApiModelProperty(name = "stringCodeResult",value = "串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0")
  private String stringCodeResult;

  /**
   *  拆分平台单号，-+拆分级别
   */
  @ApiModelProperty(name = "splitPlatformNo",value = "拆分平台单号，-+拆分级别")
  private String splitPlatformNo;

  /**
   * eas单号
   */
  @JsonProperty("easOrderNo")
  @ApiModelProperty(name = "easOrderNo",value = "eas单号/出库单号")
  private String easOrderNo;

  @ApiModelProperty(name="orderTypeList", value = "订单类型")
  @JsonProperty("orderTypeList")
  private List<String> orderTypeList;

    @ApiModelProperty(name="tagCodeList", value = "标签编码集合")
    @JsonProperty("tagCodeList")
    private List<String> tagCodeList;

  /**
   *  是否接受拆单 0-否 1-是
   */
  @ApiModelProperty(name = "allowSplitFlag", value = "是否接受拆单 0-否 1-是")
  private Integer allowSplitFlag;

  /**
   *  订单级别：0-原 1-主 2-子
   */
  @ApiModelProperty(name = "orderLevelList", value = "订单级别：0-原 1-主 2-子")
  private List<Integer> orderLevelList;

  @ApiModelProperty(name = "assignStatus", value = "指派转态：0未指派，1指派成功，2指派失败,默认0")
  @JsonProperty("assignStatus")
  private String assignStatus;

  /**
   * 非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0
   */
  @ApiModelProperty(name = "easVerifyStatus",value = "非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0")
  private Integer easVerifyStatus;

  private List<Integer> orderSourceList;

  private List<String> orderNoList;

  private List<String> easOrderNoList;

  private List<String> saleOrderStatusList;

  private List<String> excludeOrderTypeList;

  private String logisticsNo;

  @ApiModelProperty(name="stringCodeResultList", value = "串码验证结果")
  private List<String> stringCodeResultList;

  @ApiModelProperty(name = "organizationId", value = "组织id")
  private Long organizationId;

  @ApiModelProperty(
          name = "sellerRemarkFlag",
          value = "商家备注标识（0:否，1:是）"
  )
  private String sellerRemarkFlag;

  @ApiModelProperty(name="interceptInfo", value = "商家备注")
  private String sellerRemark;

  /**
   *  挂起状态：0-未挂起 1-已挂起 2-挂起失败
   */
  @ApiModelProperty(name = "lockStatus", value = "挂起状态：0-未挂起 1-已挂起 2-挂起失败")
  private Integer lockStatus;

    @ApiModelProperty(name = "easVerifyStatusList",value = "非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0")
    private List<Integer> easVerifyStatusList;

    @ApiModelProperty(name="bizDateStart", value = "业务日期开始")
    @JsonProperty("bizDateStart")
    private String bizDateStart;


    @ApiModelProperty(name="bizDateEnd", value = "业务日期结束")
    @JsonProperty("bizDateEnd")
    private String bizDateEnd;

  /**
   *  订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库
   */
  @JsonProperty("secondOrderStatus")
  @ApiModelProperty(name = "secondOrderStatus", value = "订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库")
  private String secondOrderStatus;

  /**
   * 区域名称
   */
  @ApiModelProperty(name = "regionName", value = "区域名称")
  private String regionName;

  /**
   * eas财审时间开始
   */
  @ApiModelProperty(name = "easVerifyTimeStart",value = "eas财审时间开始")
  private String easVerifyTimeStart;

  /**
   * eas财审时间结束
   */
  @ApiModelProperty(name = "easVerifyTimeEnd",value = "eas财审时间结束")
  private String easVerifyTimeEnd;

  /**
   * 发货状态 undelivered 未发货；delivered 已发货
   */
  @ApiModelProperty(name = "deliveryStauts",value = "发货状态 undelivered 未发货；delivered 已发货")
  private String deliveryStauts;

  @ApiModelProperty( name = "orderChannelName",value = "订单渠道名称")
  private String orderChannelName;

  @ApiModelProperty( name = "costCenterName",value = "成本中心名称")
  private String costCenterName;
  /**
   * 事务类型id
   */
  @ApiModelProperty(name = "businessTypeId",value = "事务类型id")
  private Long businessTypeId;
  /**
   * 事务类型名称
   */
  @ApiModelProperty( name = "businessTypeName",value = "事务类型名称")
  private String businessTypeName;

  /**
   * 超期状态
   */
  @ApiModelProperty( name = "overdueStatus",value = "超期状态 no_delivery:超期未发；no_received:超期未收")
  private String overdueStatus;

  /**
   * 是否预占库存 0 ：否；1：是
   */
  @ApiModelProperty( name = "preemptionStock",value = "是否预占库存 0 ：否；1：是")
  private Integer preemptionStockFalg;

  @ApiModelProperty(name="shippingNo", value = "快递单号")
  private String shippingNo;


  @ApiModelProperty( name = "batchInverted",value = "是否批次倒挂 0 ：否；1：是")
  private Integer batchInverted;


  @ApiModelProperty(name = "organizationIdList", value = "组织id集合")
  private List<Long> organizationIdList;

  @ApiModelProperty(name = "allotType", value = "调拨方式")
  private String allotType;

  @ApiModelProperty(name = "allotTypeList", value = "调拨方式")
  private List<String> allotTypeList;

  @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
  private String allotOutWarehouseCode;

  @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
  private String allotInWarehouseCode;

  @ApiModelProperty(name = "ifSourceWarehouseSpilt", value = "是否寻源拆单")
  private Integer ifSourceWarehouseSpilt;


}

