package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* 快递费用月统计发货量Eo对象
*
* @author author
* @since 2025-02-18
*/
@ApiModel(value = "ExpressCostDeliverQuantityReqDto", description = "快递费用月统计发货量Eo对象")
public class ExpressCostDeliverQuantityReqDto extends BaseDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  记账月份
    */
    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    @ApiModelProperty(name = "warehouseCodeList", value = "物理仓编码集合")
    private List<String> warehouseCodeList;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  物流公司编码
    */
    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;
    @ApiModelProperty(name = "logisticCodeList", value = "物流公司编码集合")
    private List<String> logisticCodeList;
    /**
    *  物流公司名称
    */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司名称")
    private String logisticCompany;
    /**
    *  承运方式
    */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;
    /**
    *  系统统计票数
    */
    @ApiModelProperty(name = "statNum", value = "系统统计票数")
    private Integer statNum;
    /**
    *  计费票数
    */
    @ApiModelProperty(name = "chargeNum", value = "计费票数")
    private Integer chargeNum;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setBookkeepingMonth(String bookkeepingMonth){
    this.bookkeepingMonth = bookkeepingMonth;
    }
    public String getBookkeepingMonth(){
    return this.bookkeepingMonth;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setLogisticCode(String logisticCode){
    this.logisticCode = logisticCode;
    }
    public String getLogisticCode(){
    return this.logisticCode;
    }
    public void setLogisticCompany(String logisticCompany){
    this.logisticCompany = logisticCompany;
    }
    public String getLogisticCompany(){
    return this.logisticCompany;
    }
    public void setTransportType(String transportType){
    this.transportType = transportType;
    }
    public String getTransportType(){
    return this.transportType;
    }
    public void setStatNum(Integer statNum){
    this.statNum = statNum;
    }
    public Integer getStatNum(){
    return this.statNum;
    }
    public void setChargeNum(Integer chargeNum){
    this.chargeNum = chargeNum;
    }
    public Integer getChargeNum(){
    return this.chargeNum;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public List<String> getLogisticCodeList() {
        return logisticCodeList;
    }

    public void setLogisticCodeList(List<String> logisticCodeList) {
        this.logisticCodeList = logisticCodeList;
    }

    public List<String> getTransportTypeList() {
        return transportTypeList;
    }

    public void setTransportTypeList(List<String> transportTypeList) {
        this.transportTypeList = transportTypeList;
    }
}
