package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@ApiModel(value = "InventoryCheckItem", description = "库存校验详情对象")
public  class InventoryCheckItem {

    @ApiModelProperty(name = "longCode", value = "长编码")
    private String longCode;

    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;

    @ApiModelProperty(name = "virtualWarehouseCode", value = "供货仓编码")
    private String virtualWarehouseCode;

    @ApiModelProperty(name = "channelWarehouseCodes", value = "渠道仓编码")
    private List<String> channelWarehouseCodes;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "checkResult", value = "校验结果")
    private boolean checkResult = true;

    @ApiModelProperty(name = "checkReason", value = "失败原因")
    private String checkReason;

    @ApiModelProperty(name = "curInventory", value = "当前库存")
    private BigDecimal curInventory;

    @ApiModelProperty(name = "targetInventory", value = "目标库存")
    private BigDecimal targetInventory;
}