package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 物流运费合计记录表服务接口
*
* @author author
* @since 2022-07-17
*/
@Api(tags = {"报表中心：物流运费合计服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IPcpItemApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/finLogisticsReport",
        url = "${tcbj.center.report.api:}"
)
public interface IFinLogisticsReportApi {

    /**
    * 新增物流运费合计记录表
    *
    * @param addReqDto 物流运费合计记录表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增物流运费合计记录表", notes = "新增物流运费合计记录表")
    RestResponse<Long> addFinLogisticsReport(@RequestBody FinLogisticsReportReqDto addReqDto);

    /**
    * 修改物流运费合计记录表
    *
    * @param modifyReqDto 物流运费合计记录表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改物流运费合计记录表", notes = "修改物流运费合计记录表")
    RestResponse<Void> modifyFinLogisticsReport(@RequestBody FinLogisticsReportReqDto modifyReqDto);

    /**
    * 删除物流运费合计记录表
    *
    * @param ids        物流运费合计记录表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除物流运费合计记录表", notes = "删除物流运费合计记录表")
    RestResponse<Void> removeFinLogisticsReport(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
     * 合并物流运费记录
     * @param reqDto
     * @return
     */
    @PostMapping("/pooled")
    @ApiOperation(value = "合并物流运费记录", notes = "合并物流运费记录")
    RestResponse<Long> pooledData(@RequestBody LogisticOperateReqDto reqDto);

    /**
     * 拆分物流运费记录
     * @param reqDto
     * @return
     */
    @PostMapping("/resolution")
    @ApiOperation(value = "拆分物流运费记录", notes = "拆分物流运费记录")
    RestResponse<Void> resolutionData(@RequestBody LogisticOperateReqDto reqDto);

    /**
     * 计算
     * @param ids
     * @return
     */
    @PostMapping("/againCalculate")
    @ApiOperation(value = "重新计算", notes = "重新计算")
    RestResponse<Void> againCalculate(@RequestBody List<String> ids);

    /**
     * 拉取数据计算
     * @param logisticStatisticReqDto
     * @return
     */
    @PostMapping("/statisticData")
    @ApiOperation(value = "拉取数据计算", notes = "拉取数据计算")
    RestResponse<Void> statisticData(@RequestBody LogisticStatisticReqDto logisticStatisticReqDto);

    /**
     * 拉取数据计算
     * @param logisticStatisticReqDto
     * @return
     */
    @PostMapping("/statisticDataOld")
    @ApiOperation(value = "拉取数据计算旧数据源", notes = "拉取数据计算新旧数据源")
    RestResponse<Void> statisticDataOld(@RequestBody LogisticStatisticReqDto logisticStatisticReqDto);

    /**
     * 导入
     * @param reportDtoList
     * @return
     */
    @PostMapping("/importLogisticsReport")
    @ApiOperation(value = "导入物流运费记录", notes = "导入物流运费记录")
    RestResponse<Void> importLogisticsReport(@RequestBody List<FinLogisticsReportDto> reportDtoList);

    /**
     * 批量插入
     * @param reportDtoList
     * @return
     */
    @PostMapping("/insertBatch")
    @ApiOperation(value = "批量插入物流运费", notes = "批量插入物流运费")
    RestResponse<Void> insertBatch(@RequestBody List<FinLogisticsReportDto> reportDtoList);


    /**
     * 更新账单数据
     *
     * @param reqDto
     * @return
     */
    @PostMapping("/againCalculate/ext")
    @ApiOperation(value = "更新账单数据", notes = "更新账单数据")
    RestResponse<Void> againCalculate(@RequestBody AgainCalculateReqDto reqDto);

    /**
     * 物流费用编辑
     * @param editReqDto
     * @return
     */
    @PostMapping("/edit")
    @ApiOperation(value = "物流费用编辑", notes = "物流费用编辑")
    RestResponse<Void> edit(@RequestBody @Validated FinLogisticsReportEditReqDto editReqDto);

    /**
     *物流费用删除
     *
     * @param ids       数据ID
     * @return 处理结果
     */
    @DeleteMapping("/del/{ids}")
    @ApiOperation(value = "物流费用删除", notes = "物流费用删除")
    RestResponse<Void> del(@PathVariable("ids") String ids);


    /**
     * 物流费用编辑省市区
     * @param editReqDto
     * @return
     */
    @PostMapping("/editAddress")
    @ApiOperation(value = "物流费用编辑省市区", notes = "物流费用编辑省市区")
    RestResponse<Void> editAddress(@RequestBody @Validated FinLogisticsReportEditReqDto editReqDto);

    /**
     * 物流费用编辑省市区
     * @param editReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "物流费用更新归档标识", notes = "物流费用更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

    /**
     * 生成物流费用明细报表数据（来源每日发货报表）
     * @param logisticStatisticReqDto 请求参数
     */
    @PostMapping("/generateLogisticStatisticDataForDailyDeliveryReport")
    @ApiOperation(value = "生成物流费用明细报表数据（来源每日发货报表）", notes = "生成物流费用明细报表数据（来源每日发货报表）")
    RestResponse<Void> generateLogisticStatisticDataForDailyDeliveryReport(@RequestBody LogisticStatisticReqDto logisticStatisticReqDto);

    @PostMapping("/updateSpecial")
    @ApiOperation(value = "更新物流费用明细特殊费用", notes = "更新物流费用明细特殊费用")
    RestResponse<Void> updateSpecial(@RequestBody FinLogisticsDetailReqDto reqDto);

    @PostMapping("/updOrIns")
    @ApiOperation(value = "更新或新增", notes = "更新或新增")
    RestResponse<Long> updOrIns(@RequestBody FinLogisticsDetailReqDto reqDto);

    @PostMapping("/delByIds")
    @ApiOperation(value = "根据id删除物流费用", notes = "根据id删除物流费用")
    RestResponse<Void> delByIds(@RequestBody List<Long> ids);
}
