package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Map;

/**
 * SAP拉单限流配置响应DTO
 *
 * @author system
 * @date 2024-11-15
 */
@ApiModel(value = "SapPullRateLimitConfigRespDto", description = "SAP拉单限流配置响应对象")
public class SapPullRateLimitConfigRespDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("是否启用限流控制")
    private Boolean enabled;

    @ApiModelProperty("每小时最大可拉单量")
    private Integer maxOrdersPerHour;

    @ApiModelProperty("当前剩余额度")
    private Integer remainingQuota;

    @ApiModelProperty("最近60分钟已暴露数量")
    private Integer exposedCountInLastHour;

    @ApiModelProperty("待拉单总数")
    private Integer pendingOrderCount;

    @ApiModelProperty("按类型统计的待拉单数量")
    private Map<String, Integer> pendingOrderCountByType;

    @ApiModelProperty("按类型统计的已暴露数量")
    private Map<String, Integer> exposedCountByType;

    @ApiModelProperty("当前已可拉单总数（if_pull=1）")
    private Integer currentExposedOrdersCount;

    @ApiModelProperty("2小时最大可拉单量（maxOrdersPerHour * 2）")
    private Integer maxOrdersForTwoHours;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxOrdersPerHour() {
        return maxOrdersPerHour;
    }

    public void setMaxOrdersPerHour(Integer maxOrdersPerHour) {
        this.maxOrdersPerHour = maxOrdersPerHour;
    }

    public Integer getRemainingQuota() {
        return remainingQuota;
    }

    public void setRemainingQuota(Integer remainingQuota) {
        this.remainingQuota = remainingQuota;
    }

    public Integer getExposedCountInLastHour() {
        return exposedCountInLastHour;
    }

    public void setExposedCountInLastHour(Integer exposedCountInLastHour) {
        this.exposedCountInLastHour = exposedCountInLastHour;
    }

    public Integer getPendingOrderCount() {
        return pendingOrderCount;
    }

    public void setPendingOrderCount(Integer pendingOrderCount) {
        this.pendingOrderCount = pendingOrderCount;
    }

    public Map<String, Integer> getPendingOrderCountByType() {
        return pendingOrderCountByType;
    }

    public void setPendingOrderCountByType(Map<String, Integer> pendingOrderCountByType) {
        this.pendingOrderCountByType = pendingOrderCountByType;
    }

    public Map<String, Integer> getExposedCountByType() {
        return exposedCountByType;
    }

    public void setExposedCountByType(Map<String, Integer> exposedCountByType) {
        this.exposedCountByType = exposedCountByType;
    }

    public Integer getCurrentExposedOrdersCount() {
        return currentExposedOrdersCount;
    }

    public void setCurrentExposedOrdersCount(Integer currentExposedOrdersCount) {
        this.currentExposedOrdersCount = currentExposedOrdersCount;
    }

    public Integer getMaxOrdersForTwoHours() {
        return maxOrdersForTwoHours;
    }

    public void setMaxOrdersForTwoHours(Integer maxOrdersForTwoHours) {
        this.maxOrdersForTwoHours = maxOrdersForTwoHours;
    }

    @Override
    public String toString() {
        return "SapPullRateLimitConfigRespDto{" +
                "enabled=" + enabled +
                ", maxOrdersPerHour=" + maxOrdersPerHour +
                ", remainingQuota=" + remainingQuota +
                ", exposedCountInLastHour=" + exposedCountInLastHour +
                ", pendingOrderCount=" + pendingOrderCount +
                ", pendingOrderCountByType=" + pendingOrderCountByType +
                ", exposedCountByType=" + exposedCountByType +
                ", currentExposedOrdersCount=" + currentExposedOrdersCount +
                ", maxOrdersForTwoHours=" + maxOrdersForTwoHours +
                '}';
    }
}

