package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 快递计费明细报表详情Eo对象
 */
@Data
@ApiModel(value = "ExpressCostChargingRespDto", description = "快递计费明细报表详情Eo对象")
public class ExpressCostChargingRespDto extends BaseRespDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 快递费报表ID
     */
    @ApiModelProperty(name = "reportId", value = "快递费报表ID")
    private Long reportId;
    /**
     * 单据类型
     */
    @ApiModelProperty(name = "billType", value = "单据类型")
    private Integer billType;
    /**
     * 记账月份
     */
    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;
    /**
     * 出库时间
     */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;
    /**
     * 出库单号
     */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
     * WMS出库单号
     */
    @ApiModelProperty(name = "wmsOutboundCode", value = "WMS出库单号")
    private String wmsOutboundCode;
    /**
     * 业务单号
     */
    @ApiModelProperty(name = "businessCode", value = "业务单号")
    private String businessCode;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     * 物理仓编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
     * 物理仓名称
     */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司名称")
    private String logisticCompany;
    /**
     * 承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     * 计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private Integer chargeMode;
    /**
     * 快递单号
     */
    @ApiModelProperty(name = "expressNo", value = "快递单号")
    private String expressNo;
    /**
     * 件数
     */
    @ApiModelProperty(name = "pieceNum", value = "件数")
    private Long pieceNum;
    /**
     * 体积重
     */
    @ApiModelProperty(name = "volumeWeight", value = "体积重")
    private BigDecimal volumeWeight;
    /**
     * 重量
     */
    @ApiModelProperty(name = "weight", value = "重量")
    private BigDecimal weight;

    @ApiModelProperty(name = "expressWeight", value = "快递计费重量")
    private BigDecimal expressWeight;

    @ApiModelProperty(name = "chargedWeight", value = "计费重量")
    private BigDecimal chargedWeight;
    /**
     * 重量范围
     */
    @ApiModelProperty(name = "weightRange", value = "重量范围")
    private String weightRange;
    /**
     * 首价
     */
    @ApiModelProperty(name = "firstPrice", value = "首价")
    private BigDecimal firstPrice;
    /**
     * 续价1
     */
    @ApiModelProperty(name = "continuedOne", value = "续价1")
    private BigDecimal continuedOne;
    /**
     * 续价2
     */
    @ApiModelProperty(name = "continuedTwo", value = "续价2")
    private BigDecimal continuedTwo;
    /**
     * 续价3
     */
    @ApiModelProperty(name = "continuedThree", value = "续价3")
    private BigDecimal continuedThree;
    /**
     * 续价4
     */
    @ApiModelProperty(name = "continuedFour", value = "续价4")
    private BigDecimal continuedFour;
    /**
     * 续价运费
     */
    @ApiModelProperty(name = "continuedFreight", value = "续价运费")
    private BigDecimal continuedFreight;
    /**
     * 旺季浮动金额
     */
    @ApiModelProperty(name = "floatAmount", value = "旺季浮动金额")
    private BigDecimal floatAmount;
    /**
     * 包装费
     */
    @ApiModelProperty(name = "packingFreight", value = "包装费")
    private BigDecimal packingFreight;
    /**
     * 增值费
     */
    @ApiModelProperty(name = "incrementFreight", value = "增值费")
    private BigDecimal incrementFreight;
    /**
     * 投保金额
     */
    @ApiModelProperty(name = "insureAmount", value = "投保金额")
    private BigDecimal insureAmount;
    /**
     * 保费
     */
    @ApiModelProperty(name = "premium", value = "保费")
    private BigDecimal premium;
    /**
     * 调整类型
     */
    @ApiModelProperty(name = "adjustmentType", value = "调整类型")
    private String adjustmentType;
    /**
     * 调整金额
     */
    @ApiModelProperty(name = "adjustmentAmount", value = "调整金额")
    private BigDecimal adjustmentAmount;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 运费合计
     */
    @ApiModelProperty(name = "totalFreight", value = "运费合计")
    private BigDecimal totalFreight;
    /**
     * 调出仓编码
     */
    @ApiModelProperty(name = "outWarehouseCode", value = "调出仓编码")
    private String outWarehouseCode;
    /**
     * 调出仓名称
     */
    @ApiModelProperty(name = "outWarehouseName", value = "调出仓名称")
    private String outWarehouseName;
    /**
     * 出仓组织
     */
    @ApiModelProperty(name = "outOrg", value = "出仓组织")
    private String outOrg;
    /**
     * 出仓组织编码
     */
    @ApiModelProperty(name = "outOrgCode", value = "出仓组织编码")
    private String outOrgCode;
    /**
     * 入仓编码
     */
    @ApiModelProperty(name = "inWarehouseCode", value = "入仓编码")
    private String inWarehouseCode;
    /**
     * 入仓名称
     */
    @ApiModelProperty(name = "inWarehouseName", value = "入仓名称")
    private String inWarehouseName;
    /**
     * 入仓组织编码
     */
    @ApiModelProperty(name = "inOrgCode", value = "入仓组织编码")
    private String inOrgCode;
    /**
     * 入仓组织
     */
    @ApiModelProperty(name = "inOrg", value = "入仓组织")
    private String inOrg;
    /**
     * 费用归属
     */
    @ApiModelProperty(name = "freightOrg", value = "费用归属")
    private String freightOrg;
    /**
     * 费用归属编码
     */
    @ApiModelProperty(name = "freightOrgCode", value = "费用归属编码")
    private String freightOrgCode;
    /**
     * 收件人
     */
    @ApiModelProperty(name = "consignee", value = "收件人")
    private String consignee;
    /**
     * 省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
     * 城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
     * 区/县
     */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;
    /**
     * 经纬度
     */
    @ApiModelProperty(name = "lngLat", value = "经纬度")
    private String lngLat;
    /**
     * 详细地址
     */
    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;
    /**
     * 分摊比例
     */
    @ApiModelProperty(name = "ratio", value = "分摊比例")
    private BigDecimal ratio;
    /**
     * 异常原因
     */
    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;
    /**
     * 异常标识0正常 1异常
     */
    @ApiModelProperty(name = "abnormal", value = "异常标识0正常 1异常")
    private Integer abnormal;
    /**
     * 省市级别
     */
    @ApiModelProperty(name = "cityLevel", value = "省市级别")
    private String cityLevel;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * eas编码
     */
    @ApiModelProperty(name = "easNo", value = "eas编码")
    private String easNo;
    /**
     * 开单日期
     */
    @ApiModelProperty(name = "billingDate", value = "开单日期")
    private String billingDate;
    /**
     * 最后修改人
     */
    @ApiModelProperty(name = "lastUpdatePerson", value = "最后修改人")
    private String lastUpdatePerson;
    /**
     * 最后修改时间
     */
    @ApiModelProperty(name = "lastUpdateTime", value = "最后修改时间")
    private Date lastUpdateTime;

    @ApiModelProperty(name = "returnFee", value = "返回费用")
    private BigDecimal returnFee;

    @ApiModelProperty(name = "outDocumentNo", value = "出库通知单号")
    private String outDocumentNo;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "contractId", value = "合同id")
    private Long contractId;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    @ApiModelProperty(name = "expressBackRemake", value = "快递回传重量")
    private BigDecimal expressBackRemake;

    @ApiModelProperty(name = "weightDifference", value = "重量差异（快递回传重量-ocs重量）")
    private BigDecimal weightDifference;

    @ApiModelProperty(name = "e3No", value = "E3单号")
    private String e3No;

    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;

    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    @ApiModelProperty(name = "ocsSystemWeight", value = "OCS系统重量")
    private BigDecimal ocsSystemWeight;

    @ApiModelProperty(name = "beginDeliverProvince", value = "始发省")
    private String beginDeliverProvince;

    @ApiModelProperty(name = "beginDeliverProvinceCode", value = "始发省编码")
    private String beginDeliverProvinceCode;

    @ApiModelProperty(name = "beginDeliverCity", value = "始发城市")
    private String beginDeliverCity;

    @ApiModelProperty(name = "beginDeliverCityCode", value = "始发城市编码")
    private String beginDeliverCityCode;

    @ApiModelProperty(name = "ifRepeat", value = "是否重复，1是 0否")
    private Integer ifRepeat;

    @ApiModelProperty(name = "masterOrder", value = "是否总单，1是 0否")
    private Integer masterOrder;

    @ApiModelProperty(name = "shopName", value = "店铺")
    private String shopName;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(name = "volumeRemark", value = "体积备注")
    private String volumeRemark;

    @ApiModelProperty(name = "firstPricePer", value = "首价单价")
    private BigDecimal firstPricePer;

    @ApiModelProperty(name = "continuedOnePer", value = "续价1单价")
    private BigDecimal continuedOnePer;

    @ApiModelProperty(name = "continuedTwoPer", value = "续价单价")
    private BigDecimal continuedTwoPer;

    @ApiModelProperty(name = "continuedThreePer", value = "续价3单价")
    private BigDecimal continuedThreePer;

    @ApiModelProperty(name = "continuedFourPer", value = "续价4单价")
    private BigDecimal continuedFourPer;

    @ApiModelProperty(name = "billingOrgCode", value = "计费组织编码")
    private String billingOrgCode;

    @ApiModelProperty(name = "billingOrgName", value = "计费组织名称")
    private String billingOrgName;

    @ApiModelProperty(name = "feeId", value = "关联主表id")
    private Long feeId;

    @ApiModelProperty(name = "costType", value = "计费类型DailyDeliveryReportCostBelongDetailCostTypeEnum")
    private String costType;

    @ApiModelProperty(name = "costTypeName", value = "计费类型名称")
    private String costTypeName;

    @ApiModelProperty(name = "allocationQuantity", value = "分摊数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty(name = "apportionWeight", value = "分摊重量")
    private BigDecimal apportionWeight;

    @ApiModelProperty(name = "orgTotalFreight", value = "组织运费合计")
    private BigDecimal orgTotalFreight;

}
