package com.dtyunxi.tcbj.api.dto.constant.enums;

import lombok.Getter;

@Getter
public enum LogisticsStatusEnum {
    /**
     * 物流公司关联设置状态
     */
    VALID(0,"未作废"),
    INVALID(1,"已作废"),
    ;


    private Integer status;
    private String statusName;

    LogisticsStatusEnum(Integer status, String statusName){
        this.status = status;
        this.statusName=statusName;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusName(){
        return statusName;
    }

    public static String getStatusNameByStatus(Integer status){
        for (LogisticsStatusEnum value:LogisticsStatusEnum.values()){
            if (value.status.equals(status)){
                return value.statusName;
            }
        }
        return null;
    }
}
