package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ClueReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.ClueReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 寻源策略服务接口
 *
 * @author author
 * @since 2022-04-18
 */
@Api(tags = {"报表中心: 寻源策略"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/clueReport",
        url = "${tcbj.center.report.api:}"
)
public interface IClueReportQueryApi {


    /**
     * 寻源策略分页数据
     *
     * @param filter   寻源策略查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 寻源策略分页数据
     */
    @PostMapping("/queryCluePage")
    @ApiOperation(value = "寻源策略分页数据", notes = "根据filter查询条件查询寻源策略数据")
    RestResponse<PageInfo<ClueReportRespDto>> queryCluePage(@RequestBody ClueReportReqDto filter);

}
