package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 更新可拉单状态请求DTO
 *
 * @author system
 * @since 2024-11-27
 */
@ApiModel(value = "UpdatePullStatusReqDto", description = "更新可拉单状态请求DTO")
@Data
public class UpdatePullStatusReqDto {

    /**
     * 单据类型
     */
    @ApiModelProperty(name = "businessType", value = "单据类型", required = true)
    private String businessType;

    /**
     * 业务单号
     */
    @ApiModelProperty(name = "businessOrderNo", value = "业务单号", required = true)
    private String businessOrderNo;

    /**
     * SAP凭证号
     */
    @ApiModelProperty(name = "sapDocumentNo", value = "SAP凭证号", required = true)
    private String sapDocumentNo;

    /**
     * 单据ID列表（可选，用于批量更新）
     */
    @ApiModelProperty(name = "orderIds", value = "单据ID列表")
    private List<Long> orderIds;

    /**
     * 单据类型列表（可选，用于按类型批量更新）
     */
    @ApiModelProperty(name = "orderTypes", value = "单据类型列表")
    private List<String> orderTypes;

    /**
     * 文档号列表（可选，用于按文档号批量更新）
     */
    @ApiModelProperty(name = "documentNos", value = "文档号列表")
    private List<String> documentNos;
}
