package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressBillQueryDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostBillCountDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author buqi
 * @since 2024/12/04
 */
@Api(tags = {"快递账单报表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IExpressBillQueryApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/express/cost/bill",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressBillQueryApi {
    /**
     * 快递账单报表分页数据
     *
     * @param queryDto   快递账单报表查询条件
     * @return 快递账单报表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "快递账单报表分页数据", notes = "快递账单报表分页数据")
    RestResponse<PageInfo<ExpressBillRespDto>> queryByPage(@RequestBody ExpressBillQueryDto queryDto);

    /**
     * 更新快递账单
     * @param reqDto
     * @return
     */
    @PostMapping("/updateExpressCostBill")
    @ApiOperation(value = "快递账单-更新快递账单", notes = "快递账单-更新快递账单")
    RestResponse<Void> updateExpressCostBill(@RequestBody ExpressBillQueryDto reqDto);

    /**
     * 快递账单报表统计数据
     *
     * @param queryDto   快递账单报表查询条件
     * @return 快递账单报表统计数据
     */
    @PostMapping("/getExpressCostBillCount")
    @ApiOperation(value = "快递账单报表统计数据", notes = "快递账单报表统计数据")
    RestResponse<ExpressCostBillCountDto> getExpressCostBillCount(@RequestBody ExpressBillQueryDto queryDto);

    /**
     * 快递账单更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "快递账单更新归档标识", notes = "快递账单更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);
}
