package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "BatchInversionReqDto", description = "批次倒挂报表请求Dto")
public class BatchInversionReqDto {
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    @ApiModelProperty(name = "brand", value = "品牌")
    private String brand;
    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;
    private String warehouseOnlineFlag;
    private String organizationCode;
    private String physicsWarehouseCode;
    @ApiModelProperty(name = "rdcInversion", value = "RDC仓是否批次倒挂")
    private Integer rdcInversion;
    @ApiModelProperty(name = "zhInversion", value = "总仓是否批次倒挂")
    private Integer zhInversion;

    @ApiModelProperty(value = "分页数")
    private Integer pageNum;
    @ApiModelProperty(value = "分页大小")
    private Integer pageSize;

    @ApiModelProperty(name = "oldWarehouseName", value = "各效期产品(最旧)|仓库")
    private List<String> oldWarehouseNames;


    private List<String> physicsWarehouseNameList;

    @ApiModelProperty(name = "businessTypes", value = "订单类型")
    private List<String> businessTypes;
}
