package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ShippingOrderTemplateDto {

    @ApiModelProperty(name = "platformOrderNo", value = "渠道单号")
    private String platformOrderNo;

    @ApiModelProperty(name = "saleOrderNo", value = "内部销售单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "ifSaleTransfer", value = "是否销售调拨")
    private Integer ifSaleTransfer;

    @ApiModelProperty(name = "orderType", value = "单据类型，1 托运单，2 金额联）")
    private Integer orderType;

    @ApiModelProperty(name = "shippingCode", value = "托运单号")
    private String shippingCode;

    @ApiModelProperty(name = "zj", value = "质检报告单")
    private String zj;

    @ApiModelProperty(name = "je", value = "金额联")
    private String je;

    @ApiModelProperty(name = "zjCode", value = "质检报告单Code")
    private String zjCode;

    @ApiModelProperty(name = "jeCode", value = "金额联Code")
    private String jeCode;

    @ApiModelProperty(name = "channel", value = "渠道")
    private String channel = "";

    @ApiModelProperty(name = "shippingCode", value = "承运商")
    private String carriage = "";

    @ApiModelProperty(name = "easOrderNo", value = "EAS订单号")
    private String easOrderNo = "";

    @ApiModelProperty(name = "orderNo", value = "单据编号")
    private String orderNo = "";

    @ApiModelProperty(name = "bizDate", value = "业务日期")
    private String bizDate = "";

    @ApiModelProperty(name = "deliverUnit", value = "发货单位")
    private String deliverUnit = "";

    @ApiModelProperty(name = "purchaseUnit", value = "购货单位")
    private String purchaseUnit = "";

    @ApiModelProperty(name = "destination", value = "目的地")
    private String destination = "";

    @ApiModelProperty(name = "deliveryAddress", value = "发货地址（发货）")
    private String deliveryAddress = "";

    @ApiModelProperty(name = "deliveryPhone", value = "联系电话（发货）")
    private String deliveryPhone = "";

    @ApiModelProperty(name = "deliveryLinkman", value = "联系人（发货）")
    private String deliveryLinkman = "";

    @ApiModelProperty(name = "receviceAddress", value = "收货人地址")
    private String receviceAddress = "";

    @ApiModelProperty(name = "recevicePhone", value = "联系电话（收货）")
    private String recevicePhone = "";

    @ApiModelProperty(name = "receviceLinkman", value = "联系人（收货）")
    private String receviceLinkman = "";

    @ApiModelProperty(name = "takeDate", value = "提货日期")
    private String takeDate = "";

    @ApiModelProperty(name = "remark", value = "备注(发货要求或方式)")
    private String remark = "";

    @ApiModelProperty(name = "volume", value = "发货总体积(m³)")
    private BigDecimal volume = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalWeight", value = "发货总重量(KG)")
    private BigDecimal totalWeight = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalBox", value = "总箱数")
    private BigDecimal totalBox = BigDecimal.ZERO;

    @JsonProperty("pBox")
    @ApiModelProperty(name = "pBox", value = "拼箱数")
    private BigDecimal pBox = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalV", value = "体积(M3)")
    private BigDecimal totalV = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalW", value = "重量(KG)")
    private BigDecimal totalW = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalN", value = "总数量")
    private BigDecimal totalN = BigDecimal.ZERO;

    @ApiModelProperty(name = "totalP", value = "总金额")
    private String totalP = "0";

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "dtoList", value = "单据明细")
    private List<ShippingOrderTemplateDetailDto> dtoList;

}
