/**
 * @(#) SortingCostReportVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * SortingCostReportVO
 */
@Data
@ApiModel(value = "SortingCostReportRespDto", description = "")
public class SortingCostReportRespDto extends BaseRespDto {


  @ApiModelProperty(name="importUpdateTime", value = "最后修改时间")
  @JsonProperty("importUpdateTime")
  private String importUpdateTime;

  @ApiModelProperty(name="importUpdatePerson", value = "最后修改人")
  @JsonProperty("importUpdatePerson")
  private String importUpdatePerson;
  
  @ApiModelProperty(name="outWarehouseTime", value = "出库日期")
  @JsonProperty("outWarehouseTime")
  private String outWarehouseTime;
  
  
  @ApiModelProperty(name="wmsDocumentNo", value = "WMS出库单号")
  @JsonProperty("wmsDocumentNo")
  private String wmsDocumentNo;
  
  
  @ApiModelProperty(name="documentNo", value = "出库结果单号")
  @JsonProperty("documentNo")
  private String documentNo;


  @ApiModelProperty(name = "consignmentNo", value = "托运单号")
  @JsonProperty("consignmentNo")
  private String consignmentNo;
  
  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="outWarehouse", value = "调出仓")
  @JsonProperty("outWarehouse")
  private String outWarehouse;
  
  
  @ApiModelProperty(name="outOrgName", value = "调出库存组织")
  @JsonProperty("outOrgName")
  private String outOrgName;
  
  
  @ApiModelProperty(name="inWarehouseCode", value = "调入仓")
  @JsonProperty("inWarehouseCode")
  private String inWarehouseCode;
  
  
  @ApiModelProperty(name="inOrgName", value = "调入库存组织")
  @JsonProperty("inOrgName")
  private String inOrgName;
  
  
  @ApiModelProperty(name="costAttribution", value = "费用归属")
  @JsonProperty("costAttribution")
  private String costAttribution;
  
  
  @ApiModelProperty(name="costAttributionCode", value = "费用归属编码")
  @JsonProperty("costAttributionCode")
  private String costAttributionCode;
  
  
  @ApiModelProperty(name="goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;
  
  
  @ApiModelProperty(name="goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;
  
  
  @ApiModelProperty(name="outQuantity", value = "出库数量")
  @JsonProperty("outQuantity")
  private String outQuantity;
  
  
  @ApiModelProperty(name="packageNum", value = "装箱数")
  @JsonProperty("packageNum")
  private String packageNum;
  
  
  @ApiModelProperty(name="smallPackageNum", value = "小箱瓶数")
  @JsonProperty("smallPackageNum")
  private String smallPackageNum;
  
  
  @ApiModelProperty(name="largeBox", value = "大箱")
  @JsonProperty("largeBox")
  private String largeBox;
  
  
  @ApiModelProperty(name="smallBox", value = "小箱")
  @JsonProperty("smallBox")
  private String smallBox;
  
  
  @ApiModelProperty(name="number", value = "个数")
  @JsonProperty("number")
  private String number;
  
  
  @ApiModelProperty(name="adjustType", value = "调整类型")
  @JsonProperty("adjustType")
  private String adjustType;
  
  
  @ApiModelProperty(name="platformAdjustAmount", value = "调整金额")
  @JsonProperty("platformAdjustAmount")
  private String platformAdjustAmount;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark;
  
  
  @ApiModelProperty(name="totalSortingFee", value = "合计分拣费")
  @JsonProperty("totalSortingFee")
  private String totalSortingFee;

  
  @ApiModelProperty(name="inWarehouse", value = "调入仓")
  @JsonProperty("inWarehouse")
  private String inWarehouse;

  @ApiModelProperty(name="abnormal", value = "是否异常，0:正常，1异常")
  @JsonProperty("abnormal")
  private Integer abnormal;
  @ApiModelProperty(name="abnormalCauses", value = "是否异常，0:正常，1异常")
  @JsonProperty("abnormalCauses")
  private String abnormalCauses;

  @ApiModelProperty(name="abnormalNum", value = "异常数量")
  @JsonProperty("abnormalNum")
  private Long abnormalNum;


  @ApiModelProperty(name="externalOrderNo", value = "外部单号")
  @JsonProperty("externalOrderNo")
  private String externalOrderNo;

  private String relevanceNo;

  @ApiModelProperty(name = "outDocumentNo", value = "出库通知单号")
  private String outDocumentNo;

  @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓")
  private String outPhysicsWarehouseName;

  @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
  private String wmsMergeDocumentNo;

  @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
  private String joinMergeDocumentNo;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "customerName", value = "客户名称")
  @JsonProperty("customerName")
  private String customerName;
  /**
   * 目的省
   */
  @ApiModelProperty(name = "endProvince", value = "目的省")
  @JsonProperty("endProvince")
  private String endProvince;
  /**
   * 目的省编码
   */
  @ApiModelProperty(name = "endProvinceCode", value = "目的省编码")
  @JsonProperty("endProvinceCode")
  private String endProvinceCode;
  /**
   * 目的市
   */
  @ApiModelProperty(name = "endCity", value = "目的市")
  @JsonProperty("endCity")
  private String endCity;
  /**
   * 目的市编码
   */
  @ApiModelProperty(name = "endCityCode", value = "目的市编码")
  @JsonProperty("endCityCode")
  private String endCityCode;
  /**
   * 不计费原因
   */
  @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
  @JsonProperty("noBillingReason")
  private String noBillingReason;
  /**
   * 是否计费,0不计费,1计费
   */
  @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
  @JsonProperty("billingFeeFlag")
  private Integer billingFeeFlag;
  /**
   * 是否归档,0未归档,1已归档
   */
  @ApiModelProperty(name = "placedFlag", value = "是否归档,0未归档,1已归档")
  @JsonProperty("placedFlag")
  private Integer placedFlag;

  @ApiModelProperty(name = "ifApportion", value = "是否分摊；1是，0否")
  private Integer ifApportion;

  @ApiModelProperty(name = "shipmentEnterpriseCode", value = "物流商编码")
  private String shipmentEnterpriseCode;

  @ApiModelProperty(name = "shipmentEnterpriseName", value = "物流商名称")
  private String shipmentEnterpriseName;

  @ApiModelProperty(name = "transportStyle", value = "承运方式")
  private String transportStyle;

  @ApiModelProperty(name = "transportStyleCode", value = "承运方式代码")
  private String transportStyleCode;

}

