package com.dtyunxi.tcbj.api.dto.storageCharge;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import javax.naming.Name;
import java.util.Date;
import java.util.List;

/**
 * 同步数据入参
 * @author lius5
 */
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "SyncDataDto", description = "同步分摊数据Dto")
public class SyncApportionDataDto {

    @ApiModelProperty(name = "recordStartDate", value = "统计开始时间")
    private Date recordStartDate;

    @ApiModelProperty(name = "recordEndDate", value = "统计结束时间")
    private Date recordEndDate;

    @ApiModelProperty(name = "recordApportionDate", value = "分摊时间")
    private Date recordApportionDate;

    @ApiModelProperty(name = "itemCodes", value = "商品Codes")
    private List<String> itemCodes;

    @ApiModelProperty(name = "batchs", value = "批次batchs")
    private List<String> batchs;

    @ApiModelProperty(name = "propertyRightOrganizationIds", value = "分摊指定所属库存组织")
    private List<String> propertyRightOrganizationIds;

    @ApiModelProperty(name = "physicsWarehouseCodes", value = "分摊指定非所属物理仓库")
    private List<String> physicsWarehouseCodes;

    @ApiModelProperty(name = "physicsWarehouseCodes", value = "指定所属物理仓库")
    private List<String> inPhysicsWarehouseCodes;

    @ApiModelProperty(name = "logicWarehouseList", value = "指定逻辑仓")
    private List<String> logicWarehouseList;

    @ApiModelProperty(name = "warehouseQuality", value = "逻辑仓品质")
    private List<String> warehouseQualitys;

    @ApiModelProperty(name = "warehouseClassify", value = "逻辑仓分类")
    private List<String> warehouseClassifys;

    @ApiModelProperty(name = "warehouseTypes", value = "逻辑仓类型")
    private List<String> warehouseTypes;

    @ApiModelProperty(name = "statisticalTime", value = "快照时间")
    private Date statisticalTime;

    public Date getRecordStartDate() {
        return recordStartDate;
    }

    public void setRecordStartDate(Date recordStartDate) {
        this.recordStartDate = recordStartDate;
    }

    public Date getRecordEndDate() {
        return recordEndDate;
    }

    public void setRecordEndDate(Date recordEndDate) {
        this.recordEndDate = recordEndDate;
    }

    public Date getRecordApportionDate() {
        return recordApportionDate;
    }

    public void setRecordApportionDate(Date recordApportionDate) {
        this.recordApportionDate = recordApportionDate;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }

    public List<String> getBatchs() {
        return batchs;
    }

    public void setBatchs(List<String> batchs) {
        this.batchs = batchs;
    }

    public List<String> getPropertyRightOrganizationIds() {
        return propertyRightOrganizationIds;
    }

    public void setPropertyRightOrganizationIds(List<String> propertyRightOrganizationIds) {
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
    }

    public List<String> getPhysicsWarehouseCodes() {
        return physicsWarehouseCodes;
    }

    public void setPhysicsWarehouseCodes(List<String> physicsWarehouseCodes) {
        this.physicsWarehouseCodes = physicsWarehouseCodes;
    }

    public List<String> getLogicWarehouseList() {
        return logicWarehouseList;
    }

    public void setLogicWarehouseList(List<String> logicWarehouseList) {
        this.logicWarehouseList = logicWarehouseList;
    }

    public List<String> getInPhysicsWarehouseCodes() {
        return inPhysicsWarehouseCodes;
    }

    public void setInPhysicsWarehouseCodes(List<String> inPhysicsWarehouseCodes) {
        this.inPhysicsWarehouseCodes = inPhysicsWarehouseCodes;
    }

    public List<String> getWarehouseQualitys() {
        return warehouseQualitys;
    }

    public void setWarehouseQualitys(List<String> warehouseQualitys) {
        this.warehouseQualitys = warehouseQualitys;
    }

    public List<String> getWarehouseClassifys() {
        return warehouseClassifys;
    }

    public void setWarehouseClassifys(List<String> warehouseClassifys) {
        this.warehouseClassifys = warehouseClassifys;
    }

    public List<String> getWarehouseTypes() {
        return warehouseTypes;
    }

    public void setWarehouseTypes(List<String> warehouseTypes) {
        this.warehouseTypes = warehouseTypes;
    }

    public Date getStatisticalTime() {
        return statisticalTime;
    }

    public void setStatisticalTime(Date statisticalTime) {
        this.statisticalTime = statisticalTime;
    }

    public SyncApportionDataDto(Date recordApportionDate, List<String> propertyRightOrganizationIds, List<String> physicsWarehouseCodes) {
        this.recordApportionDate = recordApportionDate;
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
        this.physicsWarehouseCodes = physicsWarehouseCodes;
    }

    public SyncApportionDataDto(List<String> itemCodes, List<String> batchs, List<String> propertyRightOrganizationIds, List<String> physicsWarehouseCodes) {
        this.itemCodes = itemCodes;
        this.batchs = batchs;
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
        this.physicsWarehouseCodes = physicsWarehouseCodes;
    }

    public SyncApportionDataDto(Date recordStartDate, Date recordEndDate, List<String> itemCodes, List<String> batchs, List<String> propertyRightOrganizationIds, List<String> physicsWarehouseCodes) {
        this.recordStartDate = recordStartDate;
        this.recordEndDate = recordEndDate;
        this.itemCodes = itemCodes;
        this.batchs = batchs;
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
        this.physicsWarehouseCodes = physicsWarehouseCodes;
    }

    public SyncApportionDataDto(Date recordStartDate, Date recordEndDate, List<String> itemCodes, List<String> batchs, List<String> propertyRightOrganizationIds, List<String> physicsWarehouseCodes, List<String> inPhysicsWarehouseCodes, List<String> warehouseQualitys) {
        this.recordStartDate = recordStartDate;
        this.recordEndDate = recordEndDate;
        this.itemCodes = itemCodes;
        this.batchs = batchs;
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
        this.physicsWarehouseCodes = physicsWarehouseCodes;
        this.inPhysicsWarehouseCodes = inPhysicsWarehouseCodes;
        this.warehouseQualitys = warehouseQualitys;
    }

    public SyncApportionDataDto(List<String> propertyRightOrganizationIds, List<String> physicsWarehouseCodes, List<String> warehouseQualitys, List<String> warehouseClassifys, List<String> warehouseTypes, Date statisticalTime) {
        this.propertyRightOrganizationIds = propertyRightOrganizationIds;
        this.physicsWarehouseCodes = physicsWarehouseCodes;
        this.warehouseQualitys = warehouseQualitys;
        this.warehouseClassifys = warehouseClassifys;
        this.warehouseTypes = warehouseTypes;
        this.statisticalTime = statisticalTime;
    }
}
