package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "ReInsuranceBillCountDto", description = "保费账单表Eo对象")
public class ReInsuranceBillCountDto {

    /**
     * 全部数量
     */
    @ApiModelProperty(name = "total", value = "全部数量")
    private BigDecimal total;

    /**
     * 异常数量
     */
    @ApiModelProperty(name = "unusualTotal", value = "异常数量")
    private BigDecimal unusualTotal;

    /**
     * 正常数量
     */
    @ApiModelProperty(name = "normalTotal", value = "正常数量")
    private BigDecimal normalTotal;

    /**
     * 大箱数量
     */
    @ApiModelProperty(name = "bigBoxTotal", value = "大箱数量")
    private BigDecimal bigBoxTotal;

    /**
     * 小箱数量
     */
    @ApiModelProperty(name = "smallBoxTotal", value = "小箱数量")
    private BigDecimal smallBoxTotal;

    /**
     * 总个数
     */
    @ApiModelProperty(name = "boxTotal", value = "总个数")
    private BigDecimal boxTotal;

    /**
     * 合计分拣费
     */
    @ApiModelProperty(name = "sortingTotal", value = "合计分拣费")
    private BigDecimal sortingTotal;

    @ApiModelProperty(name = "masterOrderDifferenceTotal", value = "总单差异")
    private BigDecimal masterOrderDifferenceTotal;

    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(name = "weight", value = "重量")
    private BigDecimal weight;

    @ApiModelProperty(name = "box", value = "箱数")
    private BigDecimal box;

    @ApiModelProperty(name = "logisticsCostTotal", value = "合计物流费")
    private BigDecimal logisticsCostTotal;

    @ApiModelProperty(name = "expressCostTotal", value = "快递运费合计")
    private BigDecimal expressCostTotal;

    @ApiModelProperty(name = "expressNoCount", value = "快递单数")
    private BigDecimal expressNoCount;


}
