/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import com.dtyunxi.tcbj.biz.service.IShopReportService;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.mapper.CsCustomerMapper;
import com.dtyunxi.tcbj.dao.mapper.ShopMapper;
import com.dtyunxi.tcbj.dao.vo.ReportShopVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopReportServiceImpl
implements IShopReportService {
    @Autowired
    private IContext context;
    @Autowired
    private CsCustomerMapper csCustomerMapper;
    @Autowired
    private ShopMapper shopMapper;
    private static Long ENABLE_STATUS_ID = 1256288005151458333L;

    @Override
    public List<BrotherCustomerShopRespDto> queryBrotherCustomerShop() {
        ArrayList result = Lists.newArrayList();
        ServiceContext serviceContext = ServiceContext.getContext();
        String customerId = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return result;
        }
        List csCustomerEos = this.csCustomerMapper.queryBrotherCustomerByIdAndSalesmanId(Long.valueOf(customerId), this.context.userId());
        if (CollectionUtils.isEmpty((Collection)csCustomerEos)) {
            return result;
        }
        HashMap repeatMap = new HashMap();
        Map<Long, CsCustomerEo> customerMap = csCustomerEos.stream().filter(e -> ENABLE_STATUS_ID.equals(e.getStatusId())).collect(Collectors.toMap(CsCustomerEo::getMerchantId, e -> e, (e1, e2) -> {
            if (ENABLE_STATUS_ID.equals(e1.getStatusId()) && !ENABLE_STATUS_ID.equals(e2.getStatusId())) {
                return e1;
            }
            if (!ENABLE_STATUS_ID.equals(e1.getStatusId()) && ENABLE_STATUS_ID.equals(e2.getStatusId())) {
                return e2;
            }
            if (!e1.getId().equals(e2.getId())) {
                repeatMap.put(e1.getMerchantId(), e1.getName());
            }
            return ENABLE_STATUS_ID.equals(e1.getStatusId()) ? e1 : e2;
        }));
        List shopVos = this.shopMapper.queryShopByOrgId(customerMap.keySet());
        String orgIdStr = serviceContext.getAttachment("yes.req.cus.b2b.sellerorgid");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgIdStr}) && MapUtils.isNotEmpty(repeatMap) && CollectionUtils.isNotEmpty((Collection)shopVos)) {
            StringBuilder builder = new StringBuilder();
            Map<Long, String> merchantNameMap = shopVos.stream().collect(Collectors.toMap(e -> e.getOrgId(), e -> e.getSellerName()));
            Long curOrgId = Long.valueOf(orgIdStr);
            if (repeatMap.get(curOrgId) != null) {
                builder.append("\u3010\u5728\u79df\u6237[" + merchantNameMap.get(curOrgId) + "]\u4e0b\u7684\u5ba2\u6237[" + (String)repeatMap.get(curOrgId) + "]\u5b58\u5728\u591a\u4e2a\u542f\u7528\u7684\uff0c\u8bf7\u5728\u5ba2\u6237\u5217\u8868\u4e2d\u53ea\u4fdd\u7559\u552f\u4e00\u4e00\u4e2a\u542f\u7528\u7684\u5ba2\u6237\u3011");
                throw new BizException("9008", builder.toString());
            }
        }
        for (ReportShopVo vo : shopVos) {
            BrotherCustomerShopRespDto respDto = new BrotherCustomerShopRespDto();
            respDto.setId(vo.getId());
            respDto.setStatus(vo.getStatus());
            respDto.setName(vo.getShopName());
            respDto.setSellerId(vo.getSellerId());
            respDto.setSellerName(vo.getSellerName());
            respDto.setOrganizationId(vo.getOrgId());
            respDto.setOrganizationName(vo.getSellerName());
            CsCustomerEo csCustomerEo = customerMap.get(vo.getOrgId());
            if (csCustomerEo != null) {
                respDto.setCustomerId(csCustomerEo.getId());
                respDto.setCustomerName(csCustomerEo.getName());
            }
            result.add(respDto);
        }
        return result;
    }
}

