/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import com.dtyunxi.tcbj.biz.service.IShopReportService;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.mapper.CsCustomerMapper;
import com.dtyunxi.tcbj.dao.mapper.ShopMapper;
import com.dtyunxi.tcbj.dao.vo.ReportShopVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopReportServiceImpl
implements IShopReportService {
    private static final Logger log = LoggerFactory.getLogger(ShopReportServiceImpl.class);
    @Autowired
    private IContext context;
    @Autowired
    private CsCustomerMapper csCustomerMapper;
    @Autowired
    private ShopMapper shopMapper;
    private static Long ENABLE_STATUS_ID = 1256288005151458333L;
    @Autowired
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    @Override
    public List<BrotherCustomerShopRespDto> queryBrotherCustomerShop() {
        ArrayList result = Lists.newArrayList();
        ServiceContext serviceContext = ServiceContext.getContext();
        String customerId = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return result;
        }
        CsCustomerEo customerEo = (CsCustomerEo)this.csCustomerMapper.selectById((Serializable)((Object)customerId));
        if (Objects.isNull(customerEo)) {
            log.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728-{}", (Object)customerId);
            return result;
        }
        Long userId = this.context.userId();
        List csCustomerEos = this.csCustomerMapper.queryBrotherCustomerByIdAndSalesmanId(Long.valueOf(customerId), userId);
        CustomerSearchExtReqDto customerSearchDto = new CustomerSearchExtReqDto();
        customerSearchDto.setOrgInfoIds((List)Lists.newArrayList((Object[])new Long[]{customerEo.getOrgInfoId()}));
        customerSearchDto.setSalesmanId(userId);
        log.info("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4e0b\u6709\u6548\u5ba2\u6237\u4fe1\u606f-{}", (Object)JSON.toJSONString((Object)customerSearchDto));
        PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryValidCustomerPage(customerSearchDto));
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtoPageInfo.getList())) {
            for (CustomerRespDto customerRespDto : customerRespDtoPageInfo.getList()) {
                CsCustomerEo csCustomerEo = new CsCustomerEo();
                csCustomerEo.setId(customerRespDto.getId());
                csCustomerEo.setName(customerRespDto.getName());
                csCustomerEo.setMerchantId(customerRespDto.getMerchantId());
                csCustomerEo.setStatusId(customerRespDto.getStatusId());
                ((List)Optional.ofNullable(csCustomerEos).orElse(new ArrayList())).add(csCustomerEo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)csCustomerEos)) {
            return result;
        }
        HashMap repeatMap = new HashMap();
        Map<Long, CsCustomerEo> customerMap = csCustomerEos.stream().filter(e -> ENABLE_STATUS_ID.equals(e.getStatusId())).collect(Collectors.toMap(CsCustomerEo::getMerchantId, e -> e, (e1, e2) -> {
            if (ENABLE_STATUS_ID.equals(e1.getStatusId()) && !ENABLE_STATUS_ID.equals(e2.getStatusId())) {
                return e1;
            }
            if (!ENABLE_STATUS_ID.equals(e1.getStatusId()) && ENABLE_STATUS_ID.equals(e2.getStatusId())) {
                return e2;
            }
            if (!e1.getId().equals(e2.getId())) {
                repeatMap.put(e1.getMerchantId(), e1.getName());
            }
            return ENABLE_STATUS_ID.equals(e1.getStatusId()) ? e1 : e2;
        }));
        List shopVos = this.shopMapper.queryShopByOrgId(customerMap.keySet());
        log.info("\u67e5\u8be2\u5230\u7684\u5e97\u94fa\u96c6\u5408:{}", (Object)JSONObject.toJSONString((Object)shopVos));
        String orgIdStr = serviceContext.getAttachment("yes.req.cus.b2b.sellerorgid");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgIdStr}) && MapUtils.isNotEmpty(repeatMap) && CollectionUtils.isNotEmpty((Collection)shopVos)) {
            StringBuilder builder = new StringBuilder();
            Map<Long, String> merchantNameMap = shopVos.stream().collect(Collectors.toMap(e -> e.getOrgId(), e -> e.getSellerName()));
            Long curOrgId = Long.valueOf(orgIdStr);
            if (repeatMap.get(curOrgId) != null) {
                builder.append("\u3010\u5728\u79df\u6237[" + merchantNameMap.get(curOrgId) + "]\u4e0b\u7684\u5ba2\u6237[" + (String)repeatMap.get(curOrgId) + "]\u5b58\u5728\u591a\u4e2a\u542f\u7528\u7684\uff0c\u8bf7\u5728\u5ba2\u6237\u5217\u8868\u4e2d\u53ea\u4fdd\u7559\u552f\u4e00\u4e00\u4e2a\u542f\u7528\u7684\u5ba2\u6237\u3011");
                throw new BizException("9008", builder.toString());
            }
        }
        for (ReportShopVo vo : shopVos) {
            BrotherCustomerShopRespDto respDto = new BrotherCustomerShopRespDto();
            respDto.setId(vo.getId());
            respDto.setStatus(vo.getStatus());
            respDto.setName(vo.getShopName());
            respDto.setSellerId(vo.getSellerId());
            respDto.setSellerName(vo.getSellerName());
            respDto.setOrganizationId(vo.getOrgId());
            respDto.setOrganizationName(vo.getSellerName());
            CsCustomerEo csCustomerEo = customerMap.get(vo.getOrgId());
            if (csCustomerEo != null) {
                respDto.setCustomerId(csCustomerEo.getId());
                respDto.setCustomerName(csCustomerEo.getName());
            }
            result.add(respDto);
        }
        return result;
    }
}

