/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.datalimit.service.IDataLimitRuleQueryService;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.ReportTabCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.OutPlannedOrderVO;
import com.dtyunxi.tcbj.biz.service.query.ITransferOrderReportQueryService;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderReportQueryServiceImpl
implements ITransferOrderReportQueryService {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderReportQueryServiceImpl.class);
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Autowired
    IDataLimitRuleQueryService dataLimitRuleQueryService;
    @Autowired
    IContext context;

    @Override
    public PageInfo<TransferOrderReportRespDto> internalDealReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        return this.reTransferOrderDas.internalDealList(reqDto);
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> internalDealOutReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u5df2\u51fa\u5e93\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        return this.reTransferOrderDas.internalDealOutList(reqDto);
    }

    @Override
    public ReportTabCountRespDto internalDealReportCount(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868tab\u6570\u91cf\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReportTabCountRespDto respDto = new ReportTabCountRespDto();
        respDto.setTotalCount(Long.valueOf(0L));
        respDto.setOutCount(Long.valueOf(0L));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        PageInfo<TransferOrderReportRespDto> transferOrderReportRespDtoPageInfo = this.internalDealReportPage(reqDto);
        respDto.setTotalCount(Long.valueOf(transferOrderReportRespDtoPageInfo.getTotal()));
        PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage = this.internalDealOutReportPage(reqDto);
        respDto.setOutCount(Long.valueOf(transferOrderDetailOutReportPage.getTotal()));
        return respDto;
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> transferOrderDetailReportPage(TransferOrderReportReqDto reqDto) {
        List transferOrders;
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setExcludeTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        PageInfo transferOrderReportRespDtoPageInfo = this.reTransferOrderDas.transferOrderDetailReportPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReportRespDtoPageInfo.getList()) && CollectionUtils.isNotEmpty(transferOrders = transferOrderReportRespDtoPageInfo.getList().stream().filter(f -> f.getTransferOrderNo().substring(0, 2).equals("TP")).map(TransferOrderReportRespDto::getTransferOrderNo).collect(Collectors.toList()))) {
            List easOrderNoList = this.reTransferOrderDas.queryTpEasOrderNo(transferOrders);
            Map map = Optional.ofNullable(easOrderNoList).map(m -> m.stream().collect(Collectors.toMap(TransferOrderReportRespDto::getTransferOrderNo, TransferOrderReportRespDto::getEasNo, (o, o1) -> o))).orElse(new HashMap());
            transferOrderReportRespDtoPageInfo.getList().forEach(info -> info.setEasNo((String)map.get(info.getTransferOrderNo())));
        }
        return transferOrderReportRespDtoPageInfo;
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage(TransferOrderReportReqDto reqDto) {
        List transferOrders;
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u5df2\u51fa\u5e93\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setExcludeTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        PageInfo transferOrderReportRespDtoPageInfo = this.reTransferOrderDas.transferOrderDetailOutReportPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReportRespDtoPageInfo.getList()) && CollectionUtils.isNotEmpty(transferOrders = transferOrderReportRespDtoPageInfo.getList().stream().filter(f -> f.getTransferOrderNo().substring(0, 2).equals("TP")).map(TransferOrderReportRespDto::getTransferOrderNo).collect(Collectors.toList()))) {
            List easOrderNoList = this.reTransferOrderDas.queryTpEasOrderNo(transferOrders);
            Map map = Optional.ofNullable(easOrderNoList).map(m -> m.stream().collect(Collectors.toMap(TransferOrderReportRespDto::getTransferOrderNo, TransferOrderReportRespDto::getEasNo, (o, o1) -> o))).orElse(new HashMap());
            transferOrderReportRespDtoPageInfo.getList().forEach(info -> info.setEasNo((String)map.get(info.getTransferOrderNo())));
        }
        return transferOrderReportRespDtoPageInfo;
    }

    @Override
    public ReportTabCountRespDto transferOrderDetailReportCount(TransferOrderReportReqDto reqDto) {
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u62a5\u8868tab\u6570\u91cf\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReportTabCountRespDto respDto = new ReportTabCountRespDto();
        respDto.setTotalCount(Long.valueOf(0L));
        respDto.setOutCount(Long.valueOf(0L));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        PageInfo<TransferOrderReportRespDto> transferOrderReportRespDtoPageInfo = this.transferOrderDetailReportPage(reqDto);
        respDto.setTotalCount(Long.valueOf(transferOrderReportRespDtoPageInfo.getTotal()));
        PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage = this.transferOrderDetailOutReportPage(reqDto);
        respDto.setOutCount(Long.valueOf(transferOrderDetailOutReportPage.getTotal()));
        return respDto;
    }

    @Override
    public PageInfo<OutPlannedOrderVO> purchaseReturnDetailReportPage(GetPurchaseReturnOrderListPageParams req) {
        logger.info("\u91c7\u8d2d\u9000\u8d27\u8ba2\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        req.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
        return this.reTransferOrderDas.purchaseReturnDetailReportPage(req);
    }

    @Override
    public PageInfo<TransferOrderReportExtRespDto> transferOrderDetailReportExtPage(TransferOrderReportExtReqDto reqDto) {
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u5206\u9875\u67e5\u8be2EXT\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.reTransferOrderDas.transferOrderDetailReportExtPage(reqDto);
    }
}

