/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.ContractIsCancelEnum;
import com.dtyunxi.tcbj.api.dto.request.FinStorageContractReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinStorageContractDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinStorageContractRespDto;
import com.dtyunxi.tcbj.biz.service.IFinStorageContractService;
import com.dtyunxi.tcbj.dao.das.FinStorageContractDas;
import com.dtyunxi.tcbj.dao.das.FinStorageContractDetailDas;
import com.dtyunxi.tcbj.dao.eo.FinStorageContractDetailEo;
import com.dtyunxi.tcbj.dao.eo.FinStorageContractEo;
import com.dtyunxi.tcbj.dao.mapper.FinStorageContractMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class FinStorageContractServiceImpl
implements IFinStorageContractService {
    @Resource
    private FinStorageContractDas finStorageContractDas;
    @Resource
    private FinStorageContractMapper finStorageContractMapper;
    @Resource
    private FinStorageContractDetailDas finStorageContractDetailDas;

    @Override
    public Long addFinStorageContract(FinStorageContractReqDto addReqDto) {
        FinStorageContractEo finStorageContractEo = new FinStorageContractEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)finStorageContractEo);
        this.finStorageContractDas.insert((BaseEo)finStorageContractEo);
        return finStorageContractEo.getId();
    }

    @Override
    public void modifyFinStorageContract(FinStorageContractReqDto modifyReqDto) {
        FinStorageContractEo finStorageContractEo = new FinStorageContractEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)finStorageContractEo);
        this.finStorageContractDas.updateSelective((BaseEo)finStorageContractEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFinStorageContract(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.finStorageContractDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public FinStorageContractRespDto queryById(Long id) {
        FinStorageContractEo finStorageContractEo = (FinStorageContractEo)this.finStorageContractDas.selectByPrimaryKey(id);
        FinStorageContractRespDto finStorageContractRespDto = new FinStorageContractRespDto();
        DtoHelper.eo2Dto((BaseEo)finStorageContractEo, (BaseVo)finStorageContractRespDto);
        return finStorageContractRespDto;
    }

    @Override
    public PageInfo<FinStorageContractRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        FinStorageContractReqDto finStorageContractReqDto = (FinStorageContractReqDto)JSON.parseObject((String)filter, FinStorageContractReqDto.class);
        FinStorageContractEo finStorageContractEo = new FinStorageContractEo();
        DtoHelper.dto2Eo((BaseVo)finStorageContractReqDto, (BaseEo)finStorageContractEo);
        PageInfo eoPageInfo = this.finStorageContractDas.selectPage((BaseEo)finStorageContractEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FinStorageContractRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<FinStorageContractRespDto> queryByWarehouse(Date startDate, Date endDate, List<String> warehouses, List<Long> contractIds) {
        return this.queryByWarehouseExecute(startDate, endDate, warehouses, contractIds, true);
    }

    @Override
    public List<FinStorageContractRespDto> queryByWarehouseNotChargeMode(Date startDate, Date endDate, List<String> warehouses, List<Long> contractIds) {
        return this.queryByWarehouseExecute(startDate, endDate, warehouses, contractIds, false);
    }

    private List<FinStorageContractRespDto> queryByWarehouseExecute(Date startDate, Date endDate, List<String> warehouses, List<Long> contractIds, boolean chargeModeCondition) {
        Assert.notNull(warehouses, (String)"0001", (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startDate) && !ObjectUtils.isEmpty((Object)endDate)) {
            queryWrapper.nested(all -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)all.nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.ge((Object)"valid_start_time", (Object)DateUtil.getDayBegin((Date)startDate))).le((Object)"valid_end_time", (Object)DateUtil.getDayBegin((Date)endDate));
                    });
                })).or()).nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"valid_start_time", (Object)DateUtil.getDayBegin((Date)startDate))).ge((Object)"valid_end_time", (Object)DateUtil.getDayBegin((Date)startDate));
                    });
                })).or()).nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"valid_start_time", (Object)DateUtil.getDayBegin((Date)endDate))).ge((Object)"valid_end_time", (Object)DateUtil.getDayBegin((Date)endDate));
                    });
                });
            });
        }
        if (CollectionUtils.isNotEmpty(warehouses)) {
            queryWrapper.in((Object)"warehouse_code", warehouses);
        }
        if (CollectionUtils.isNotEmpty(contractIds)) {
            queryWrapper.in((Object)"id", contractIds);
        }
        queryWrapper.ne((Object)"is_cancel", (Object)ContractIsCancelEnum.IS_CANCEL.getKey());
        if (chargeModeCondition) {
            queryWrapper.eq((Object)"charge_mode", (Object)1);
        }
        queryWrapper.orderByAsc((Object)"valid_start_time");
        List storageContractEos = this.finStorageContractMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)storageContractEos)) {
            return null;
        }
        ArrayList storageContractRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storageContractEos, (Collection)storageContractRespDtos, FinStorageContractRespDto.class);
        List contracts = storageContractEos.stream().map(c -> c.getId()).collect(Collectors.toList());
        FinStorageContractDetailEo storageContractDetailEo = new FinStorageContractDetailEo();
        storageContractDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"contract_id", contracts)}));
        List storageContractDetailEos = this.finStorageContractDetailDas.select((BaseEo)storageContractDetailEo);
        if (CollectionUtils.isEmpty((Collection)storageContractDetailEos)) {
            return null;
        }
        ArrayList storageContractDetailRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storageContractDetailEos, (Collection)storageContractDetailRespDtos, FinStorageContractDetailRespDto.class);
        Map<Long, List<FinStorageContractDetailRespDto>> mapGroupByContractId = storageContractDetailRespDtos.stream().collect(Collectors.groupingBy(FinStorageContractDetailRespDto::getContractId));
        storageContractRespDtos.forEach(c -> {
            List orDefault = mapGroupByContractId.getOrDefault(c.getId(), null);
            c.setDetailRespDtoList(orDefault);
        });
        return storageContractRespDtos;
    }
}

