/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOrderEnum;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderApportionReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderApportionRespDto;
import com.dtyunxi.tcbj.biz.service.ISaleOrderApportionService;
import com.dtyunxi.tcbj.dao.das.SaleOrderApportionDas;
import com.dtyunxi.tcbj.dao.eo.SaleOrderApportionEo;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderApportionMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderApportionServiceImpl
implements ISaleOrderApportionService {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderApportionServiceImpl.class);
    @Resource
    private SaleOrderApportionDas saleOrderApportionDas;
    @Resource
    private SaleOrderApportionMapper saleOrderApportionMapper;

    @Override
    public Long addSaleOrderApportion(SaleOrderApportionReqDto addReqDto) {
        SaleOrderApportionEo queryEo = new SaleOrderApportionEo();
        queryEo.setOrderNo(addReqDto.getOrderNo());
        SaleOrderApportionEo saleOrderApportionEo = (SaleOrderApportionEo)this.saleOrderApportionDas.selectOne((BaseEo)queryEo);
        if (ObjectUtil.isNotEmpty((Object)saleOrderApportionEo)) {
            return saleOrderApportionEo.getId();
        }
        SaleOrderApportionEo insertEo = new SaleOrderApportionEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)insertEo);
        this.saleOrderApportionDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public SaleOrderApportionRespDto addSaleOrderApportion(String orderNo, String type) {
        SaleOrderApportionRespDto saleOrderApportionRespDto;
        SaleOrderApportionEo queryEo = new SaleOrderApportionEo();
        queryEo.setOrderNo(orderNo);
        SaleOrderApportionEo saleOrderApportionEo = (SaleOrderApportionEo)this.saleOrderApportionDas.selectOne((BaseEo)queryEo);
        if (ObjectUtil.isEmpty((Object)saleOrderApportionEo)) {
            saleOrderApportionRespDto = this.queryOrder(orderNo, type);
            if (ObjectUtil.isEmpty((Object)saleOrderApportionRespDto)) {
                throw new BizException("\u627e\u4e0d\u5230\u539f\u5355\u636e");
            }
            saleOrderApportionRespDto.setType(type);
            saleOrderApportionRespDto.setIfPull(Integer.valueOf(0));
            saleOrderApportionEo = new SaleOrderApportionEo();
            DtoHelper.dto2Eo((BaseVo)saleOrderApportionRespDto, (BaseEo)saleOrderApportionEo);
            this.saleOrderApportionDas.insert((BaseEo)saleOrderApportionEo);
        }
        saleOrderApportionRespDto = new SaleOrderApportionRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderApportionEo, (BaseVo)saleOrderApportionRespDto);
        return saleOrderApportionRespDto;
    }

    @Override
    public void modifySaleOrderApportion(SaleOrderApportionReqDto modifyReqDto) {
        SaleOrderApportionEo saleOrderApportionEo = new SaleOrderApportionEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderApportionEo);
        if (ObjectUtil.isEmpty((Object)modifyReqDto.getId())) {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            return;
        }
        this.saleOrderApportionDas.updateSelective((BaseEo)saleOrderApportionEo);
    }

    @Override
    public void openPullDateByMain(String orderMainNo, Date openPullDate) {
        logger.info("\u6839\u636e\u4e3b\u5355\u53f7\u66f4\u65b0\u62c9\u5355\u65f6\u95f4\uff1a{}", (Object)orderMainNo);
        this.saleOrderApportionDas.openPullDateByMain(orderMainNo, openPullDate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderApportion(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.saleOrderApportionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void completeApportion(Long id, Date date) {
        logger.info("\u5b8c\u6210\u5206\u644a\u66f4\u65b0\uff1a{}=={}", (Object)id, (Object)date);
        SaleOrderApportionEo saleOrderApportionEo = (SaleOrderApportionEo)this.saleOrderApportionDas.selectByPrimaryKey(id);
        if (ObjectUtil.isEmpty((Object)saleOrderApportionEo)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5206\u644a\u8bb0\u5f55");
        }
        saleOrderApportionEo.setIfPull(Integer.valueOf(1));
        saleOrderApportionEo.setOpenPullDate(date);
        this.saleOrderApportionDas.updateSelective((BaseEo)saleOrderApportionEo);
    }

    @Override
    public SaleOrderApportionRespDto queryById(Long id) {
        SaleOrderApportionEo saleOrderApportionEo = (SaleOrderApportionEo)this.saleOrderApportionDas.selectByPrimaryKey(id);
        SaleOrderApportionRespDto saleOrderApportionRespDto = new SaleOrderApportionRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderApportionEo, (BaseVo)saleOrderApportionRespDto);
        return saleOrderApportionRespDto;
    }

    @Override
    public PageInfo<SaleOrderApportionRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleOrderApportionReqDto saleOrderApportionReqDto = (SaleOrderApportionReqDto)JSON.parseObject((String)filter, SaleOrderApportionReqDto.class);
        SaleOrderApportionEo saleOrderApportionEo = new SaleOrderApportionEo();
        DtoHelper.dto2Eo((BaseVo)saleOrderApportionReqDto, (BaseEo)saleOrderApportionEo);
        PageInfo eoPageInfo = this.saleOrderApportionDas.selectPage((BaseEo)saleOrderApportionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleOrderApportionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void refreshOpenPullDate(SaleOrderApportionReqDto reqDto) {
        logger.info("\u5237\u65b0\u5141\u8bb8\u62c9\u5355\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getOrderNo())) {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
            return;
        }
        SaleOrderApportionEo queryEo = new SaleOrderApportionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)queryEo);
        List select = this.saleOrderApportionDas.select((BaseEo)queryEo);
        if (CollectionUtil.isNotEmpty((Collection)select)) {
            select.forEach(eo -> {
                if (ObjectUtil.isNotEmpty((Object)eo.getOpenPullDate())) {
                    SaleOrderApportionEo updateEo = new SaleOrderApportionEo();
                    updateEo.setId(eo.getId());
                    updateEo.setOpenPullDate(new Date());
                    this.saleOrderApportionDas.updateSelective((BaseEo)updateEo);
                }
            });
        }
    }

    private SaleOrderApportionRespDto queryOrder(String orderNo, String type) {
        switch (Objects.requireNonNull(ApportionOrderEnum.getByCode((String)type))) {
            case SALE: {
                return this.saleOrderApportionDas.querySale(orderNo);
            }
            case SALE_REFUND: {
                return this.saleOrderApportionDas.queryRefundSale(orderNo);
            }
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: 
            case SALE_TRANSFER: 
            case ROUTE_INTERNAL_DEAL: {
                return this.saleOrderApportionDas.queryInternalDeal(orderNo);
            }
        }
        return null;
    }
}

