/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoOccupyReqDto;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryCountReDto;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryWithGiftPackageInfoDto;
import com.dtyunxi.tcbj.api.dto.request.OutOtherDetailReportQueryDto;
import com.dtyunxi.tcbj.api.dto.response.CargoOccupyRespDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.CsLogicInventoryTotalRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutOtherDetailReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptSourceNoRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.tcbj.api.vo.ChannelInventoryReportRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespWithGiftPackageInfoVo;
import com.dtyunxi.tcbj.biz.service.IInWarehouseService;
import com.dtyunxi.tcbj.biz.service.query.IInventoryReportService;
import com.dtyunxi.tcbj.dao.eo.CsLogicInventoryTotalEo;
import com.dtyunxi.tcbj.dao.mapper.CsLogicInventoryTotalMapper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inventoryReportQueryImpl")
public class InventoryReportQueryImpl
implements IInventoryReportQueryApi {
    @Resource
    IInventoryReportService inventoryReportService;
    @Autowired
    IObjectStorageService iObjectStorageService;
    @Autowired
    IInWarehouseService inWarehouseService;
    @Autowired
    CsLogicInventoryTotalMapper csLogicInventoryTotalMapper;

    public RestResponse<List<CargoOccupyRespDto>> queryCargoOccupy(CargoOccupyReqDto reqDto) {
        return new RestResponse(this.inventoryReportService.queryOrderCargoOccupy(reqDto));
    }

    public RestResponse<PageInfo<PreemptSourceNoRespDto>> queryPreemptSourceNo(Integer pageNum, Integer pageSize, List<String> sourceNoList) {
        return new RestResponse(this.inventoryReportService.queryPreemptSourceNo(pageNum, pageSize, sourceNoList));
    }

    public RestResponse<PageInfo<InventoryRespVo>> queryInventoryPage(InventoryQueryDto queryDto) {
        return new RestResponse(this.inWarehouseService.queryInventoryPage(queryDto));
    }

    public RestResponse<PageInfo<InventoryRespWithGiftPackageInfoVo>> queryInventoryWithGiftPackageInfoPage(InventoryQueryWithGiftPackageInfoDto queryDto) {
        return new RestResponse(this.inWarehouseService.queryInventoryWithGiftPackageInfoPage(queryDto));
    }

    public RestResponse<List<CsLogicInventoryTotalRespDto>> queryLogicTotalInventory(CsLogicInventoryTotalQueryDto queryDto) {
        if (StringUtils.isBlank((CharSequence)queryDto.getWarehouseCode()) && CollectionUtils.isEmpty((Collection)queryDto.getWarehouseCodeList())) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List csLogicInventoryTotalEos = this.csLogicInventoryTotalMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode()), (Object)"warehouse_code", (Object)queryDto.getWarehouseCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getCargoCode()), (Object)"sku_code", (Object)queryDto.getCargoCode())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getCargoCodeList()), (Object)"sku_code", (Collection)queryDto.getCargoCodeList()));
        ArrayList dtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)csLogicInventoryTotalEos)) {
            return new RestResponse((Object)dtoList);
        }
        for (CsLogicInventoryTotalEo eo : csLogicInventoryTotalEos) {
            CsLogicInventoryTotalRespDto dto = new CsLogicInventoryTotalRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            dto.setLongCode(eo.getSkuCode());
            dto.setCargoCode(eo.getSkuCode());
            dtoList.add(dto);
        }
        return new RestResponse((Object)dtoList);
    }

    public RestResponse<PageInfo<OutOtherDetailReportRespDto>> queryOutOtherDetailReportPage(OutOtherDetailReportQueryDto queryDto) {
        return new RestResponse(this.inventoryReportService.queryOutOtherDetailReportPage(queryDto));
    }

    public RestResponse<PageInfo<ChannelInventoryRespDto>> queryChannelInventoryPage(InventoryQueryReqDto queryDto) {
        return new RestResponse(this.inventoryReportService.queryChannelInventoryPage(queryDto));
    }

    public RestResponse<PageInfo<ChannelInventoryReportRespVo>> queryChannelInventoryReportPage(ChannelInventoryReportQueryDto queryDto) {
        return new RestResponse(this.inWarehouseService.queryChannelInventoryReportPage(queryDto));
    }

    public RestResponse<ChannelInventoryCountRespDto> queryChannelInventoryByCount(ChannelInventoryCountReDto channelInventoryCountReDto) {
        return new RestResponse((Object)this.inventoryReportService.queryChannelInventoryByCount(channelInventoryCountReDto));
    }
}

