/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderRespDto;
import com.dtyunxi.tcbj.biz.service.ITransferOrderService;
import com.dtyunxi.tcbj.dao.das.TransferOrderDas;
import com.dtyunxi.tcbj.dao.das.TransferOrderDetailDas;
import com.dtyunxi.tcbj.dao.eo.TransferOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.TransferOrderEo;
import com.dtyunxi.tcbj.dao.mapper.CsTransferOrderMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgTransferOrderDetailDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferOrderServiceImpl
implements ITransferOrderService {
    private final Logger LOGGER = LoggerFactory.getLogger(TransferOrderServiceImpl.class);
    @Resource
    private TransferOrderDas transferOrderDas;
    @Resource
    private CsTransferOrderMapper transferOrderMapper;
    @Resource
    private TransferOrderDetailDas transferOrderDetailDas;
    @Autowired
    IDgOutResultOrderDomain outResultOrderDomain;
    @Autowired
    IDgOutResultOrderDetailDomain outResultOrderDetailDomain;
    @Autowired
    IDgTransferOrderDetailDomain transferOrderDetailDomain;

    @Override
    public Long addTransferOrder(TransferOrderReqDto addReqDto) {
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)transferOrderEo);
        this.transferOrderDas.insert((BaseEo)transferOrderEo);
        return transferOrderEo.getId();
    }

    @Override
    public void modifyTransferOrder(TransferOrderReqDto modifyReqDto) {
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)transferOrderEo);
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTransferOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.transferOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TransferOrderRespDto queryById(Long id) {
        TransferOrderEo transferOrderEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(id);
        TransferOrderRespDto transferOrderRespDto = new TransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)transferOrderRespDto);
        return transferOrderRespDto;
    }

    @Override
    public PageInfo<TransferOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TransferOrderReqDto transferOrderReqDto = (TransferOrderReqDto)JSON.parseObject((String)filter, TransferOrderReqDto.class);
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)transferOrderReqDto, (BaseEo)transferOrderEo);
        PageInfo eoPageInfo = this.transferOrderDas.selectPage((BaseEo)transferOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TransferOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<TransferOrderRespDto> queryByTransferOrderReqDto(TransferOrderReqDto transferOrderReqDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getOutLogicWarehouseCode())) {
            queryWrapper.eq((Object)"out_logic_warehouse_code", (Object)transferOrderReqDto.getOutLogicWarehouseCode());
        }
        if (ObjectUtils.isNotEmpty((Object)transferOrderReqDto.getOutOrganizationId())) {
            queryWrapper.eq((Object)"out_organization_id", (Object)transferOrderReqDto.getOutOrganizationId());
        }
        if (ObjectUtils.isNotEmpty((Object)transferOrderReqDto.getTransferOrderNo())) {
            queryWrapper.eq((Object)"transfer_order_no", (Object)transferOrderReqDto.getTransferOrderNo());
        }
        if (!ObjectUtils.isEmpty((Object)transferOrderReqDto.getOutStartTime()) && !ObjectUtils.isEmpty((Object)transferOrderReqDto.getOutEndTime())) {
            queryWrapper.ge((Object)"create_time", (Object)transferOrderReqDto.getOutStartTime());
            queryWrapper.lt((Object)"create_time", (Object)transferOrderReqDto.getOutEndTime());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        List transferOrderList = this.transferOrderMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderList)) {
            List transferOrderNo = transferOrderList.stream().map(c -> c.getTransferOrderNo()).collect(Collectors.toList());
            this.LOGGER.info("\u67e5\u8be2\u8c03\u62e8\u5355\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(transferOrderNo));
            TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
            transferOrderDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"transfer_order_no", transferOrderNo)}));
            List transferOrderDetails = this.transferOrderDetailDas.select((BaseEo)transferOrderDetailEo);
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)transferOrderDetails), (String)"0001", (String)"\u5f53\u524d\u8c03\u62e8\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            Map<String, List<TransferOrderDetailEo>> transferOrderDetailMap = transferOrderDetails.stream().collect(Collectors.groupingBy(TransferOrderDetailEo::getTransferOrderNo));
            ArrayList transferOrderRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)transferOrderRespDtos, (Collection)transferOrderList, TransferOrderRespDto.class);
            transferOrderRespDtos.forEach(c -> {
                List orDefault = transferOrderDetailMap.getOrDefault(c.getTransferOrderNo(), null);
                ArrayList transferOrderDetailRespDtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)transferOrderDetailRespDtoList, (Collection)orDefault, TransferOrderDetailRespDto.class);
                c.setTransferOrderDetailList((List)transferOrderDetailRespDtoList);
            });
            return transferOrderRespDtos;
        }
        return null;
    }
}

