/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.request.WarehouseThresholReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseOrgRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicsWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseThresholdRespDto;
import com.dtyunxi.tcbj.biz.service.ILogicWarehouseService;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.RelWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.WarehouseThresholdEo;
import com.dtyunxi.tcbj.dao.mapper.RelWarehouseMapper;
import com.dtyunxi.tcbj.dao.vo.LogicWarehouseVo;
import com.dtyunxi.tcbj.dao.vo.PhysicsWarehouseVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicWarehouseServiceImpl
implements ILogicWarehouseService {
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Autowired
    RelWarehouseMapper relWarehouseMapper;

    @Override
    public Long addLogicWarehouse(LogicWarehouseReqDto addReqDto) {
        LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logicWarehouseEo);
        this.logicWarehouseDas.insert((BaseEo)logicWarehouseEo);
        return logicWarehouseEo.getId();
    }

    @Override
    public void modifyLogicWarehouse(LogicWarehouseReqDto modifyReqDto) {
        LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logicWarehouseEo);
        this.logicWarehouseDas.updateSelective((BaseEo)logicWarehouseEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogicWarehouse(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.logicWarehouseDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public LogicWarehouseRespDto queryById(Long id) {
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDas.selectByPrimaryKey(id);
        LogicWarehouseRespDto logicWarehouseRespDto = new LogicWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)logicWarehouseEo, (BaseVo)logicWarehouseRespDto);
        return logicWarehouseRespDto;
    }

    @Override
    public PageInfo<LogicWarehouseRespDto> queryByPage(LogicWarehouseReqDto logicWarehouseReqDto) {
        LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)logicWarehouseReqDto, (BaseEo)logicWarehouseEo);
        HashMap<String, String> map = new HashMap<String, String>(10);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtil.isNotEmpty((Collection)logicWarehouseReqDto.getPhysicsWarehouseCodes()) || Objects.nonNull(logicWarehouseReqDto.getMainWarehouse())) {
            LogicWarehouseVo logicWarehouseVo = (LogicWarehouseVo)BeanUtil.copyProperties((Object)logicWarehouseReqDto, LogicWarehouseVo.class, (String[])new String[0]);
            List logicWarehouseVos = this.logicWarehouseDas.selectByRefWarehouse(logicWarehouseVo);
            if (CollectionUtil.isEmpty((Collection)logicWarehouseVos)) {
                return new PageInfo();
            }
            map.putAll(logicWarehouseVos.stream().collect(Collectors.toMap(LogicWarehouseVo::getWarehouseCode, LogicWarehouseVo::getPhysicsWarehouseCode, (o, o1) -> o)));
            sqlFilters.add(SqlFilter.in((String)"warehouseCode", map.keySet()));
            if (CollectionUtil.isNotEmpty((Collection)logicWarehouseReqDto.getOrganizationIds())) {
                sqlFilters.add(SqlFilter.in((String)"organizationId", (Object)logicWarehouseReqDto.getOrganizationIds()));
            }
        } else if (CollectionUtil.isNotEmpty((Collection)logicWarehouseReqDto.getWarehouseCodes())) {
            sqlFilters.add(SqlFilter.in((String)"warehouseCode", (Object)logicWarehouseReqDto.getWarehouseCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)logicWarehouseReqDto.getOrganizationCodeList())) {
            sqlFilters.add(SqlFilter.in((String)"organization_code", (Object)logicWarehouseReqDto.getOrganizationCodeList()));
        }
        if (!CollectionUtils.isEmpty((Collection)logicWarehouseReqDto.getWarehouseNames())) {
            sqlFilters.add(SqlFilter.in((String)"warehouse_name", (Object)logicWarehouseReqDto.getWarehouseNames()));
        }
        logicWarehouseEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.logicWarehouseDas.selectPage((BaseEo)logicWarehouseEo, logicWarehouseReqDto.getPageNum(), logicWarehouseReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(eoPageInfo.getList().stream().map(data -> {
            LogicWarehouseRespDto respDto = (LogicWarehouseRespDto)BeanUtil.copyProperties((Object)data, LogicWarehouseRespDto.class, (String[])new String[0]);
            respDto.setPhysicsWarehouseCode((String)map.get(data.getWarehouseCode()));
            return respDto;
        }).collect(Collectors.toList()));
        return dtoPageInfo;
    }

    @Override
    public List<WarehouseThresholdRespDto> queryWarehouseThreshold(WarehouseThresholReqDto reqDto) {
        WarehouseThresholdEo warehouseThresholdEo = new WarehouseThresholdEo();
        warehouseThresholdEo.setWarehouseCodeList(reqDto.getWarehouseCodeList());
        return this.logicWarehouseDas.queryWarehouseThreshold(warehouseThresholdEo);
    }

    @Override
    public List<LogicWarehouseRespDto> queryWarehouseByName(List<String> warehouseNames) {
        if (CollectionUtils.isEmpty(warehouseNames)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_name", warehouseNames)).eq((Object)"warehouse_status", (Object)"enable")).list(Integer.valueOf(warehouseNames.size()));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, LogicWarehouseRespDto.class);
        return respDtos;
    }

    @Override
    public List<LogicWarehouseRespDto> queryWarehouseByCode(List<String> warehouseCodes) {
        if (CollectionUtils.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", warehouseCodes)).eq((Object)"warehouse_status", (Object)"enable")).list(Integer.valueOf(warehouseCodes.size()));
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return Lists.newArrayList();
        }
        List relWarehouseEos = this.relWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelWarehouseEo.class).in(RelWarehouseEo::getWarehouseCode, warehouseCodes)).eq(RelWarehouseEo::getWarehouseClassify, (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq(RelWarehouseEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, LogicWarehouseRespDto.class);
        for (LogicWarehouseRespDto respDto : respDtos) {
            relWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)respDto.getWarehouseCode())).findFirst().ifPresent(relWarehouseEo -> respDto.setPhysicsWarehouseCode(relWarehouseEo.getRefWarehouseCode()));
        }
        return respDtos;
    }

    @Override
    public List<LogicWarehouseRespDto> queryInTransitWarehouseByCode(List<String> warehouseCodes) {
        if (CollectionUtils.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"warehouse_code", warehouseCodes)).eq((Object)"warehouse_status", (Object)"enable")).list(Integer.valueOf(warehouseCodes.size()));
        List ids = list.stream().map(BaseEo::getId).collect(Collectors.toList());
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in((Object)"subordinate_logic_warehouse_id", ids)).eq((Object)"warehouse_status", (Object)"enable")).eq((Object)"warehouse_classify", (Object)"in_transit")).list(Integer.valueOf(warehouseCodes.size()));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, LogicWarehouseRespDto.class);
        return respDtos;
    }

    @Override
    public List<LogicWarehouseOrgRespDto> queryOrgList() {
        return this.logicWarehouseDas.queryOrgList();
    }

    @Override
    public List<PhysicsWarehouseRespDto> queryPhysicsWarehouse() {
        List physicsWarehouseVos = this.logicWarehouseDas.queryPhysicsWarehouse();
        if (CollectionUtils.isEmpty((Collection)physicsWarehouseVos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (PhysicsWarehouseVo physicsWarehouseVo : physicsWarehouseVos) {
            PhysicsWarehouseRespDto respDto = new PhysicsWarehouseRespDto();
            respDto.setId(physicsWarehouseVo.getId());
            respDto.setCode(physicsWarehouseVo.getWarehouseCode());
            respDto.setName(physicsWarehouseVo.getWarehouseName());
            respDtoList.add(respDto);
        }
        return respDtoList;
    }
}

