/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.PreemptionRecordReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptionRecordReportPageListRespDto;
import com.dtyunxi.tcbj.biz.service.IPreemptionRecordReportService;
import com.dtyunxi.tcbj.dao.das.PreemptionRecordReportDas;
import com.dtyunxi.tcbj.dao.eo.PreemptionRecordReportEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PreemptionRecordReportServiceImpl
implements IPreemptionRecordReportService {
    @Resource
    private PreemptionRecordReportDas preemptionRecordReportDas;

    @Override
    public PageInfo<PreemptionRecordReportPageListRespDto> queryPreemptionRecordReport(PreemptionRecordReportListPageReqDto dto) {
        ExtQueryChainWrapper filter = this.preemptionRecordReportDas.filter();
        if (!ObjectUtils.isEmpty((Object)dto.getDocumentNo())) {
            filter.like((Object)"document_no", (Object)("%" + dto.getDocumentNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsLongCode())) {
            filter.like((Object)"long_code", (Object)("%" + dto.getGoodsLongCode() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsName())) {
            filter.like((Object)"cargo_name", (Object)("%" + dto.getGoodsName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBatch())) {
            filter.like((Object)"batch", (Object)("%" + dto.getBatch() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBusinessOrderNo())) {
            filter.like((Object)"relevance_no", (Object)("%" + dto.getBusinessOrderNo() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBusinessType())) {
            filter.eq((Object)"business_type", (Object)dto.getBusinessType());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseCode())) {
            filter.like((Object)"delivery_logic_warehouse_code", (Object)("%" + dto.getLogicalWarehouseCode() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseName())) {
            filter.like((Object)"delivery_logic_warehouse_name", (Object)("%" + dto.getLogicalWarehouseName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCargoRightName())) {
            filter.like((Object)"organization_name", (Object)("%" + dto.getCargoRightName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateTimeStart())) {
            filter.ge((Object)"notice_create_time", (Object)dto.getCreateTimeStart());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCreateTimeEnd())) {
            filter.le((Object)"notice_create_time", (Object)(dto.getCreateTimeEnd() + " 23:59:59"));
        }
        filter.orderByDesc((Object[])new String[]{"notice_create_time", "id"});
        PageInfo page = filter.page(dto.getPageNum(), dto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        if (ObjectUtils.isEmpty((Object)page) || CollectionUtil.isEmpty((Collection)page.getList())) {
            return pageInfo;
        }
        BeanUtils.copyProperties((Object)page, (Object)pageInfo, (String[])new String[]{"list"});
        pageInfo.setList(page.getList().stream().map(resp -> {
            PreemptionRecordReportPageListRespDto respDto = new PreemptionRecordReportPageListRespDto();
            respDto.setId(resp.getId());
            respDto.setStatisticsTime(resp.getStatisticsTime());
            respDto.setDocumentNo(resp.getDocumentNo());
            respDto.setGoodsLongCode(resp.getLongCode());
            respDto.setGoodsName(resp.getCargoName());
            respDto.setBatch(resp.getBatch());
            respDto.setBusinessOrderNo(resp.getRelevanceNo());
            CsPcpBusinessTypeEnum byCode = CsPcpBusinessTypeEnum.getByCode((String)resp.getBusinessType());
            respDto.setBusinessType(ObjectUtils.isEmpty((Object)byCode) ? null : byCode.getCode());
            respDto.setLogicalWarehouseCode(resp.getDeliveryLogicWarehouseCode());
            respDto.setLogicalWarehouseName(resp.getDeliveryLogicWarehouseName());
            respDto.setPreemptNum(resp.getOriginPlanQuantity());
            respDto.setCargoRightName(resp.getOrganizationName());
            respDto.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)resp.getNoticeCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            return respDto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJob() {
        SimpleDateFormat df = new SimpleDateFormat(DatePattern.DATETIME_PATTERN.getPattern());
        Date dayBegin = DateUtil.getDayBegin();
        Date dayEnd = DateUtil.getDayEnd();
        SimpleDateFormat sdf = new SimpleDateFormat(DatePattern.DATE_PATTERN.getPattern());
        String statisticsTime = sdf.format(dayBegin);
        Date date = null;
        try {
            date = sdf.parse(statisticsTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        PreemptionRecordReportEo eo = new PreemptionRecordReportEo();
        eo.setStatisticsTime(date);
        List select = this.preemptionRecordReportDas.select((BaseEo)eo);
        if (!CollectionUtil.isEmpty((Collection)select)) {
            return;
        }
        List preemptionRecordReportEos = this.preemptionRecordReportDas.queryPreemptionRecordReport(df.format(dayBegin), df.format(dayEnd));
        this.preemptionRecordReportDas.insertBatch(preemptionRecordReportEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJobTest(String beginDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(DatePattern.DATE_PATTERN.getPattern());
        Date statisticsTime = null;
        try {
            statisticsTime = sdf.parse(beginDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        PreemptionRecordReportEo eo = new PreemptionRecordReportEo();
        eo.setStatisticsTime(statisticsTime);
        List select = this.preemptionRecordReportDas.select((BaseEo)eo);
        if (!CollectionUtil.isEmpty((Collection)select)) {
            return;
        }
        List preemptionRecordReportEos = this.preemptionRecordReportDas.queryPreemptionRecordReport(beginDate, endDate);
        this.preemptionRecordReportDas.insertBatch(preemptionRecordReportEos);
    }
}

