/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.api.dto.constant.enums.ChannelEnum;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShippingOrderTemplateDetailDto;
import com.dtyunxi.tcbj.api.dto.response.ShippingOrderTemplateDto;
import com.dtyunxi.tcbj.biz.enums.SaleTransferTypeEnum;
import com.dtyunxi.tcbj.biz.service.ISaleTransferReportService;
import com.dtyunxi.tcbj.dao.das.SaleTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.mapper.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleTransferReportServiceImpl
implements ISaleTransferReportService {
    private static final Logger logger = LoggerFactory.getLogger(SaleTransferReportServiceImpl.class);
    private static final String bizDate = "2024-01-01";
    private static final String YES_SYMBOL = "\u221a";
    private static final String NO_SYMBOL = "\u00d7";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private SaleTransferOrderDas saleTransferOrderDas;
    @Resource
    private CsTransferOrderMapper transferOrderMapper;
    @Autowired
    ICacheService cacheService;
    private boolean printFinancialDataFlag;
    private static final List<String> maiyouAllotTypeList = Lists.newArrayList((Object[])new String[]{AllotTypeEnum.MAIYOU_BC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType()});

    @Override
    public PageInfo<SaleTransferReportRespDto> queryByPage(SaleTransferReportReqDto reqDto) {
        logger.info("\u9500\u552e\u8c03\u62e8\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.buildParam(reqDto);
        if (Objects.equals(reqDto.getMaiyouAllotTypeFlag(), "1") && Objects.equals(reqDto.getDisposeStatus(), "1")) {
            return new PageInfo();
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo()) || CollectionUtil.isNotEmpty((Collection)reqDto.getOrderNos())) {
            List transferOrderNos = this.saleTransferOrderDas.queryTransferOrders(reqDto);
            logger.info("transferOrderNos,\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)transferOrderNos));
            if (CollectionUtil.isNotEmpty((Collection)transferOrderNos)) {
                if (transferOrderNos.size() == 1) {
                    reqDto.setOrderNo((String)transferOrderNos.get(0));
                } else {
                    reqDto.setOrderNos(transferOrderNos);
                    reqDto.setOrderNo(null);
                }
            }
        }
        PageInfo saleTransferReportRespDtoPageInfo = this.saleTransferOrderDas.queryPage(reqDto);
        this.setSaleAllotTransferInfo((PageInfo<SaleTransferReportRespDto>)saleTransferReportRespDtoPageInfo);
        if (CollectionUtil.isNotEmpty((Collection)saleTransferReportRespDtoPageInfo.getList())) {
            saleTransferReportRespDtoPageInfo.getList().forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getOrderStatus())) {
                    dto.setOrderStatusStr(SaleOrderStatusEnum.forCode((String)dto.getOrderStatus()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getSecondOrderStatus())) {
                    dto.setSecondOrderStatusStr(SecondSaleOrderStatusEnum.forCode((String)dto.getSecondOrderStatus()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getOrderType())) {
                    dto.setOrderTypeStr(SaleOrderTypeEnum.enumOf((String)dto.getOrderType()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getTransferType())) {
                    dto.setTransferTypeStr(SaleTransferTypeEnum.enumOf(dto.getTransferType()));
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getTotalVolumeWeight())) {
                    String[] split = dto.getTotalVolumeWeight().split("-");
                    dto.setTotalVolume(split[0]);
                    dto.setTotalWeight(split[1]);
                }
                if (Objects.equals(reqDto.getMaiyouAllotTypeFlag(), "1")) {
                    if (Objects.equals(dto.getTransferOrderStatus(), "finish")) {
                        dto.setDisposeStatus("2");
                        dto.setDisposeStatusStr("\u5168\u90e8\u8c03\u62e8");
                    } else {
                        dto.setDisposeStatus("0");
                        dto.setDisposeStatusStr("\u672a\u8c03\u62e8");
                    }
                } else if (dto.getTransferQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    dto.setDisposeStatus("0");
                    dto.setDisposeStatusStr("\u672a\u8c03\u62e8");
                } else if (dto.getTransferQuantity().compareTo(dto.getOrderLackQuantity()) < 0) {
                    dto.setDisposeStatus("1");
                    dto.setDisposeStatusStr("\u90e8\u5206\u8c03\u62e8");
                } else {
                    dto.setDisposeStatus("2");
                    dto.setDisposeStatusStr("\u5168\u90e8\u8c03\u62e8");
                }
                dto.setCreateTimeStr(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? com.dtyunxi.util.DateUtil.format((Date)dto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            });
        }
        return saleTransferReportRespDtoPageInfo;
    }

    private void setSaleAllotTransferInfo(PageInfo<SaleTransferReportRespDto> pageInfo) {
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        Set todoTypeSet = Arrays.stream(AllotTypeEnum.values()).map(AllotTypeEnum::getType).collect(Collectors.toSet());
        todoTypeSet.add(SaleTransferTypeEnum.SALE.getCode());
        todoTypeSet.add(SaleTransferTypeEnum.MAIYOU_CC_ALLOT_OUT.getCode());
        todoTypeSet.add(SaleTransferTypeEnum.MAIYOU_CC_ALLOT_OUT.getCode());
        todoTypeSet.add(SaleTransferTypeEnum.MAIYOU_BC_ALLOT.getCode());
        List transferOrderNos = pageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getTransferType()) && todoTypeSet.contains(f.getTransferType())).map(SaleTransferReportRespDto::getTransferOrderNos).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(transferOrderNos)) {
            return;
        }
        logger.info("\u83b7\u53d6\u9500\u552e\u8c03\u62e8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(transferOrderNos));
        List list = this.saleTransferOrderDas.queryTransferOrderList(transferOrderNos);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return;
        }
        List csTransferOrderEos = this.transferOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).in(CsTransferOrderEo::getTransferOrderNo, transferOrderNos));
        Map<String, CsTransferOrderEo> inventorytransferOrderMap = ((List)Optional.ofNullable(csTransferOrderEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, e -> e, (a1, a2) -> a2));
        Map<String, SaleTransferReportRespDto> map = list.stream().collect(Collectors.toMap(SaleTransferReportRespDto::getTransferOrderNos, e -> e, (a1, a2) -> a2));
        pageInfo.getList().forEach(e -> {
            SaleTransferReportRespDto saleTransferReportRespDto;
            if (StringUtils.isNotBlank((CharSequence)e.getTransferType()) && e.getTransferType().equals("SALE") && ObjectUtil.isNotEmpty(map.get(e.getTransferOrderNos()))) {
                saleTransferReportRespDto = (SaleTransferReportRespDto)map.get(e.getTransferOrderNos());
                e.setCenterTransferOrderNo(saleTransferReportRespDto.getCenterTransferOrderNo());
                e.setCenterTransferOrderStatus(saleTransferReportRespDto.getCenterTransferOrderStatus());
                e.setOutPhysicsWarehouseName(saleTransferReportRespDto.getOutPhysicsWarehouseName());
                e.setOutPhysicsWarehouseCode(saleTransferReportRespDto.getOutPhysicsWarehouseCode());
                e.setTransferOrderStatus(saleTransferReportRespDto.getTransferOrderStatus());
                if (StringUtils.isNotBlank((CharSequence)saleTransferReportRespDto.getCenterTransferOrderNo())) {
                    e.setCenterTransferInPhysicsWarehouseCode(saleTransferReportRespDto.getCenterTransferInPhysicsWarehouseCode());
                    e.setCenterTransferInPhysicsWarehouseName(saleTransferReportRespDto.getCenterTransferInPhysicsWarehouseName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)e.getTransferType()) && (ObjectUtil.isNotEmpty(map.get(e.getTransferOrderNos())) || ObjectUtil.isNotEmpty(inventorytransferOrderMap.get(e.getTransferOrderNos()))) && maiyouAllotTypeList.contains(e.getTransferType())) {
                saleTransferReportRespDto = map.getOrDefault(e.getTransferOrderNos(), new SaleTransferReportRespDto());
                CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)inventorytransferOrderMap.get(e.getTransferOrderNos());
                if (StringUtils.isNotBlank((CharSequence)saleTransferReportRespDto.getCenterTransferOrderNo())) {
                    e.setCenterTransferOrderNo(saleTransferReportRespDto.getTransferOrderNos());
                    e.setCenterTransferOrderStatus(saleTransferReportRespDto.getTransferOrderStatus());
                    e.setTransferOrderNos(saleTransferReportRespDto.getCenterTransferOrderNo());
                    e.setTransferOrderStatus(saleTransferReportRespDto.getCenterTransferOrderStatus());
                    e.setCenterTransferInPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
                    e.setCenterTransferInPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
                } else {
                    e.setTransferOrderStatus(transferOrderEo.getOrderStatus());
                }
                e.setOutLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
                e.setOutLogicWarehouseName(transferOrderEo.getOutLogicWarehouseName());
                e.setInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
                e.setInLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
                e.setOutPhysicsWarehouseName(transferOrderEo.getOutPhysicsWarehouseName());
                e.setOutPhysicsWarehouseCode(transferOrderEo.getOutPhysicsWarehouseCode());
                e.setInPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
                e.setInPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
                e.setInOrganization(transferOrderEo.getInOrganization());
                e.setInOrganizationId(transferOrderEo.getInOrganizationId());
                e.setOutOrganization(transferOrderEo.getOutOrganization());
                e.setOutOrganizationId(transferOrderEo.getOutOrganizationId());
            }
        });
    }

    @Override
    public List<ShippingOrderTemplateDto> queryPrintShippingOrderData(List<String> saleOrderNos) {
        logger.info("\u83b7\u53d6\u6253\u5370\u6258\u8fd0\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        List shippingOrderTemplateDtoList = this.saleTransferOrderDas.queryPrintShippingOrderData(saleOrderNos);
        if (CollectionUtil.isEmpty((Collection)shippingOrderTemplateDtoList)) {
            return Lists.newArrayList();
        }
        saleOrderNos = shippingOrderTemplateDtoList.stream().map(ShippingOrderTemplateDto::getSaleOrderNo).collect(Collectors.toList());
        this.buildShippingOrderList(shippingOrderTemplateDtoList);
        ArrayList<ShippingOrderTemplateDto> resultList = new ArrayList<ShippingOrderTemplateDto>();
        List shippingOrderTemplateDetailDtoList = this.saleTransferOrderDas.queryPrintShippingOrderDetailData(saleOrderNos);
        if (CollectionUtil.isNotEmpty((Collection)shippingOrderTemplateDetailDtoList)) {
            Map<String, List<ShippingOrderTemplateDetailDto>> detailGroupList = shippingOrderTemplateDetailDtoList.stream().collect(Collectors.groupingBy(ShippingOrderTemplateDetailDto::getSaleOrderNo));
            shippingOrderTemplateDtoList.forEach(dto -> {
                dto.setChannel(ChannelEnum.getNameByCode((String)dto.getChannel()));
                if (StringUtils.isBlank((CharSequence)dto.getChannel())) {
                    dto.setChannel("--");
                }
                dto.setZjCode(dto.getZj());
                dto.setJeCode(dto.getJe());
                dto.setZj(this.buildSymbol(dto.getZj()));
                dto.setJe(this.buildSymbol(dto.getJe()));
                dto.setOrderType(Integer.valueOf(1));
                List detailList = (List)detailGroupList.get(dto.getSaleOrderNo());
                if (CollectionUtil.isNotEmpty((Collection)detailList)) {
                    detailList.forEach(this::buildShippingOrderDetail);
                    BigDecimal totalW = detailList.stream().map(ShippingOrderTemplateDetailDto::getdWeight).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    totalW = totalW.setScale(6, RoundingMode.DOWN);
                    dto.setTotalW(new BigDecimal(totalW.stripTrailingZeros().toPlainString()));
                    BigDecimal totalV = detailList.stream().map(ShippingOrderTemplateDetailDto::getdVolume).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    totalV = totalV.setScale(6, RoundingMode.DOWN);
                    dto.setTotalV(new BigDecimal(totalV.stripTrailingZeros().toPlainString()));
                    BigDecimal totalN = detailList.stream().map(ShippingOrderTemplateDetailDto::getdNum).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    dto.setTotalN(new BigDecimal(totalN.stripTrailingZeros().toPlainString()));
                }
                dto.setTotalWeight(dto.getTotalW());
                dto.setTotalBox(new BigDecimal(dto.getTotalBox().stripTrailingZeros().toPlainString()));
                dto.setPBox(new BigDecimal(dto.getPBox().stripTrailingZeros().toPlainString()));
                dto.setVolume(dto.getTotalV());
                dto.setDtoList(detailList);
                resultList.add((ShippingOrderTemplateDto)dto);
            });
        }
        List<ShippingOrderTemplateDto> jointList = this.jointShippingOrder(resultList);
        for (ShippingOrderTemplateDto dto2 : jointList) {
            List dtoList = dto2.getDtoList();
            for (ShippingOrderTemplateDetailDto detailDto : dtoList) {
                detailDto.setLotListJson(new Gson().toJson((Object)this.saleTransferOrderDas.querySubBatchList(detailDto.getLongCode(), detailDto.getdBatch())));
            }
        }
        if (this.printFinancialDataFlag) {
            this.buildFinancialData(jointList);
        }
        logger.info("\u83b7\u53d6\u6253\u5370\u6258\u8fd0\u5355\u4fe1\u606f\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString(jointList));
        return jointList;
    }

    @Override
    public List<SaleTransferReportRespDto> querySaleTransferList(SaleTransferReportReqDto reqDto) {
        logger.info("\u67e5\u8be2\u6e20\u9053\u5355\u4e0b\u7684\u8c03\u62e8\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.saleTransferOrderDas.querySaleTransferList(reqDto);
    }

    private String buildSymbol(String str) {
        if (StringUtils.isNotBlank((CharSequence)str) && str.equals("1")) {
            return YES_SYMBOL;
        }
        return NO_SYMBOL;
    }

    private void buildParam(SaleTransferReportReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderNo()) && reqDto.getOrderNo().split(",").length > 1) {
            reqDto.setOrderNos((List)Lists.newArrayList((Object[])reqDto.getOrderNo().split(",")));
            reqDto.setOrderNo(null);
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getTransferTypeList())) {
            for (String s : reqDto.getTransferTypeList()) {
                if (!maiyouAllotTypeList.contains(s)) continue;
                reqDto.setMaiyouAllotTypeFlag("1");
            }
        }
        if (maiyouAllotTypeList.contains(reqDto.getTransferType())) {
            reqDto.setMaiyouAllotTypeFlag("1");
        }
    }

    private void buildShippingOrderList(List<ShippingOrderTemplateDto> dtoList) {
        List codes = dtoList.stream().map(ShippingOrderTemplateDto::getOutPhysicsWarehouseCode).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(codes)) {
            return;
        }
        List warehouseAddressList = this.saleTransferOrderDas.queryPhysicsWarehouseAddress(codes);
        if (CollectionUtil.isNotEmpty((Collection)warehouseAddressList)) {
            Map maps = warehouseAddressList.stream().collect(Collectors.toMap(ShippingOrderTemplateDto::getOutPhysicsWarehouseCode, Function.identity(), (k1, k2) -> k1));
            dtoList.forEach(dto -> {
                ShippingOrderTemplateDto map = (ShippingOrderTemplateDto)maps.get(dto.getOutPhysicsWarehouseCode());
                if (ObjectUtil.isNotEmpty((Object)map)) {
                    dto.setDeliveryLinkman(map.getDeliveryLinkman());
                    dto.setDeliveryPhone(map.getDeliveryPhone());
                    dto.setDeliveryAddress(map.getDeliveryAddress());
                }
            });
        }
    }

    private void buildShippingOrderDetail(ShippingOrderTemplateDetailDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getDate())) {
            String[] split = dto.getDate().split("#");
            try {
                dto.setdPro(simpleDateFormat.format(simpleDateFormat.parse(split[0])));
                dto.setdExp(simpleDateFormat.format(simpleDateFormat.parse(split[1])));
            }
            catch (Exception e) {
                logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDisableDate()) && StringUtils.isNotBlank((CharSequence)dto.getdPro()) && StringUtils.isNotBlank((CharSequence)dto.getOldApproval()) && DateUtil.parse((CharSequence)dto.getdPro()).isBefore((Date)DateUtil.parse((CharSequence)dto.getDisableDate()))) {
            dto.setdApproval(dto.getOldApproval());
            if (StringUtils.isNotBlank((CharSequence)dto.getOldItemName())) {
                dto.setdName(dto.getOldItemName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getdInt()) && dto.getdInt().equals("1")) {
            dto.setdInt("\u662f");
        } else {
            dto.setdInt("\u5426");
        }
        dto.setLongCode(dto.getdCode());
        if (StringUtils.isNotBlank((CharSequence)dto.getdCode())) {
            dto.setdCode(dto.getdCode().substring(dto.getdCode().lastIndexOf(".") + 1));
        }
        dto.setdBNum(BigDecimal.ZERO.toPlainString());
        if (ObjectUtil.isNotEmpty((Object)dto.getBigBox()) && dto.getBigBox().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal boxes = dto.getdNum().divide(dto.getBigBox(), 2, RoundingMode.DOWN);
            BigDecimal remain = dto.getdNum().remainder(dto.getBigBox());
            StringBuffer dBNumStr = new StringBuffer();
            dBNumStr.append(boxes.intValue()).append("\u7bb1");
            dBNumStr.append(remain.intValue()).append(dto.getdUnit());
            dto.setdBNum(dBNumStr.toString());
        }
        dto.setdNum(new BigDecimal(dto.getdNum().stripTrailingZeros().toPlainString()));
    }

    private void buildFinancialData(List<ShippingOrderTemplateDto> dtoList) {
        logger.info("\u6784\u5efa\u91d1\u989d\u8054\u6253\u5370\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        String saleOrderNoStr = dtoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getJeCode()) && o.getJeCode().equals("1")).map(ShippingOrderTemplateDto::getSaleOrderNo).collect(Collectors.joining(","));
        if (StringUtils.isBlank((CharSequence)saleOrderNoStr)) {
            logger.info("\u65e0\u9700\u8981\u6253\u5370\u7684\u5355\u636e");
            return;
        }
        List<String> saleOrderNos = Arrays.asList(saleOrderNoStr.split(","));
        if (CollectionUtil.isEmpty(saleOrderNos)) {
            logger.info("\u65e0\u9700\u8981\u6253\u5370\u7684\u5355\u636e");
            return;
        }
        List financialOrderTemplateDetailDtoList = this.saleTransferOrderDas.queryPrintFinancialOrderDetailData(saleOrderNos);
        if (CollectionUtil.isEmpty((Collection)financialOrderTemplateDetailDtoList)) {
            return;
        }
        Map<String, List<ShippingOrderTemplateDetailDto>> detailGroupMap = financialOrderTemplateDetailDtoList.stream().collect(Collectors.groupingBy(ShippingOrderTemplateDetailDto::getSaleOrderNo));
        ArrayList list = new ArrayList();
        dtoList.forEach(dto -> {
            ArrayList<ShippingOrderTemplateDetailDto> detailDtoList = new ArrayList<ShippingOrderTemplateDetailDto>();
            String[] saleOrders = dto.getSaleOrderNo().split(",");
            Arrays.asList(saleOrders).forEach(s -> {
                List shippingOrderTemplateDetailDtos = (List)detailGroupMap.get(s);
                if (CollectionUtil.isNotEmpty((Collection)shippingOrderTemplateDetailDtos)) {
                    detailDtoList.addAll(shippingOrderTemplateDetailDtos);
                }
            });
            if (CollectionUtil.isNotEmpty(detailDtoList)) {
                detailDtoList.forEach(d -> {
                    if (StringUtils.isNotBlank((CharSequence)d.getDate())) {
                        String[] split = d.getDate().split("#");
                        try {
                            d.setdPro(simpleDateFormat.format(simpleDateFormat.parse(split[0])));
                            d.setdExp(simpleDateFormat.format(simpleDateFormat.parse(split[1])));
                        }
                        catch (Exception e) {
                            logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)d.getDisableDate()) && StringUtils.isNotBlank((CharSequence)d.getdPro()) && StringUtils.isNotBlank((CharSequence)d.getOldApproval()) && DateUtil.parse((CharSequence)d.getdPro()).isBefore((Date)DateUtil.parse((CharSequence)d.getDisableDate()))) {
                        d.setdApproval(d.getOldApproval());
                        if (StringUtils.isNotBlank((CharSequence)d.getOldItemName())) {
                            d.setdName(d.getOldItemName());
                        }
                    }
                    d.setLongCode(d.getdCode());
                    d.setdCode(d.getdCode().substring(d.getdCode().lastIndexOf(".") + 1));
                    d.setdNum(new BigDecimal(d.getdNum().stripTrailingZeros().toPlainString()));
                    if (StringUtils.isNotBlank((CharSequence)d.getPrice())) {
                        d.setPrice(new BigDecimal(d.getPrice()).stripTrailingZeros().toPlainString());
                    }
                    if (ObjectUtil.isNotEmpty((Object)d.getTotalPrice())) {
                        d.setTotalPrice(new BigDecimal(d.getTotalPrice().stripTrailingZeros().toPlainString()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)d.getdInt()) && d.getdInt().equals("1")) {
                        d.setdInt("\u662f");
                    } else {
                        d.setdInt("\u5426");
                    }
                    d.setLotListJson(new Gson().toJson((Object)this.saleTransferOrderDas.querySubBatchList(d.getLongCode(), d.getdBatch())));
                });
                ShippingOrderTemplateDto je = new ShippingOrderTemplateDto();
                BeanUtils.copyProperties((Object)dto, (Object)je);
                je.setOrderType(Integer.valueOf(2));
                BigDecimal totalP = detailDtoList.stream().map(ShippingOrderTemplateDetailDto::getTotalPrice).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                je.setTotalP(totalP.stripTrailingZeros().toPlainString());
                if (saleOrders.length > 1) {
                    je.setDtoList(this.jointFinancialDetail(detailDtoList));
                } else {
                    je.setDtoList(detailDtoList);
                }
                list.add(je);
            }
        });
        dtoList.addAll(list);
    }

    private List<ShippingOrderTemplateDto> jointShippingOrder(List<ShippingOrderTemplateDto> dtoList) {
        logger.info("\u6258\u8fd0\u5355\u5408\u5e76\uff1a{}", (Object)JSON.toJSONString(dtoList));
        ArrayList<ShippingOrderTemplateDto> result = new ArrayList<ShippingOrderTemplateDto>();
        Map<JointShippingOrderGroupKey, List<ShippingOrderTemplateDto>> jointMap = dtoList.stream().filter(f -> f.getIfSaleTransfer() == 1).collect(Collectors.groupingBy(it -> new JointShippingOrderGroupKey(it.getPlatformOrderNo(), it.getShippingCode())));
        for (List<ShippingOrderTemplateDto> value : jointMap.values()) {
            if (value.size() == 1) {
                result.addAll(value);
                continue;
            }
            ShippingOrderTemplateDto templateDto = value.get(0);
            templateDto.setSaleOrderNo(value.stream().map(ShippingOrderTemplateDto::getSaleOrderNo).collect(Collectors.joining(",")));
            BigDecimal volume = value.stream().map(ShippingOrderTemplateDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
            templateDto.setVolume(new BigDecimal(volume.stripTrailingZeros().toPlainString()));
            templateDto.setTotalV(templateDto.getVolume());
            BigDecimal totalWeight = value.stream().map(ShippingOrderTemplateDto::getTotalWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
            templateDto.setTotalWeight(new BigDecimal(totalWeight.stripTrailingZeros().toPlainString()));
            templateDto.setTotalW(templateDto.getTotalWeight());
            BigDecimal totalN = value.stream().map(ShippingOrderTemplateDto::getTotalN).reduce(BigDecimal.ZERO, BigDecimal::add);
            templateDto.setTotalN(new BigDecimal(totalN.stripTrailingZeros().toPlainString()));
            List detailList = value.stream().flatMap(f -> f.getDtoList().stream()).collect(Collectors.toList());
            Map<String, List<ShippingOrderTemplateDetailDto>> detailListMap = detailList.stream().collect(Collectors.groupingBy(g -> g.getdCode() + "_" + g.getdBatch() + "_" + g.getdInt()));
            List<Object> detailJointList = new ArrayList<ShippingOrderTemplateDetailDto>();
            for (List<ShippingOrderTemplateDetailDto> dValue : detailListMap.values()) {
                if (dValue.size() == 1) {
                    detailJointList.addAll(dValue);
                    continue;
                }
                ShippingOrderTemplateDetailDto detailDto = dValue.get(0);
                detailDto.setdNum(dValue.stream().map(ShippingOrderTemplateDetailDto::getdNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailJointList.add(detailDto);
            }
            detailJointList = detailJointList.stream().sorted(Comparator.comparing(ShippingOrderTemplateDetailDto::getdCode)).collect(Collectors.toList());
            templateDto.setDtoList(detailJointList);
            result.add(templateDto);
        }
        return result;
    }

    private List<ShippingOrderTemplateDetailDto> jointFinancialDetail(List<ShippingOrderTemplateDetailDto> detailDtoList) {
        logger.info("\u91d1\u989d\u8054\u660e\u7ec6\u5408\u5e76\uff1a{}", (Object)JSON.toJSONString(detailDtoList));
        Map<String, List<ShippingOrderTemplateDetailDto>> groupList = detailDtoList.stream().collect(Collectors.groupingBy(g -> g.getdCode() + "_" + g.getdBatch() + "_" + g.getdInt()));
        ArrayList<ShippingOrderTemplateDetailDto> resultList = new ArrayList<ShippingOrderTemplateDetailDto>();
        for (List<ShippingOrderTemplateDetailDto> value : groupList.values()) {
            if (value.size() == 1) {
                resultList.addAll(value);
                continue;
            }
            ShippingOrderTemplateDetailDto dto = value.get(0);
            BigDecimal dNum = value.stream().map(ShippingOrderTemplateDetailDto::getdNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            dto.setdNum(new BigDecimal(dNum.stripTrailingZeros().toPlainString()));
            BigDecimal totalPrice = value.stream().map(ShippingOrderTemplateDetailDto::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            dto.setTotalPrice(new BigDecimal(totalPrice.stripTrailingZeros().toPlainString()));
            resultList.add(dto);
        }
        resultList = resultList.stream().sorted(Comparator.comparing(ShippingOrderTemplateDetailDto::getdCode)).collect(Collectors.toList());
        return resultList;
    }

    private String createShippingCode(String warehouseCode) {
        logger.info("\u751f\u4ea7\u5408\u5e76\u6258\u8fd0\u5355\u53f7\uff1a{}", (Object)warehouseCode);
        String flag = this.saleTransferOrderDas.queryPhysicsWarehouseFlag(warehouseCode);
        String date = com.dtyunxi.util.DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        Date startDate = com.dtyunxi.cube.utils.DateUtil.parseDate((String)"2023-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        if (new Date().before(startDate)) {
            date = "20230101";
        }
        StringBuilder consignmentNoBuffer = new StringBuilder();
        consignmentNoBuffer.append(flag);
        consignmentNoBuffer.append(date);
        String cacheKey = "SaleTransferReportServiceImpl_getConsignmentNo_" + flag;
        Long incur = this.cacheService.incrBy(cacheKey, 1L);
        logger.info("getConsignmentNo: redis key : {}, \u81ea\u589e\u7ed3\u679c: {}", (Object)cacheKey, (Object)incur);
        if (Objects.equals(incur, 1L)) {
            this.cacheService.expire(cacheKey, 86410);
        }
        int appendZeroSize = 7 - incur.toString().length();
        for (int i = 0; i < appendZeroSize; ++i) {
            consignmentNoBuffer.append("0");
        }
        consignmentNoBuffer.append(incur);
        consignmentNoBuffer.append("P");
        logger.info(consignmentNoBuffer.toString());
        return consignmentNoBuffer.toString();
    }

    static class JointShippingOrderGroupKey {
        private String platformOrderNo;
        private String shippingCode;

        public JointShippingOrderGroupKey(String platformOrderNo, String shippingCode) {
            this.platformOrderNo = platformOrderNo;
            this.shippingCode = shippingCode;
        }

        public String getPlatformOrderNo() {
            return this.platformOrderNo;
        }

        public String getShippingCode() {
            return this.shippingCode;
        }

        public void setPlatformOrderNo(String platformOrderNo) {
            this.platformOrderNo = platformOrderNo;
        }

        public void setShippingCode(String shippingCode) {
            this.shippingCode = shippingCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JointShippingOrderGroupKey)) {
                return false;
            }
            JointShippingOrderGroupKey other = (JointShippingOrderGroupKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$platformOrderNo = this.getPlatformOrderNo();
            String other$platformOrderNo = other.getPlatformOrderNo();
            if (this$platformOrderNo == null ? other$platformOrderNo != null : !this$platformOrderNo.equals(other$platformOrderNo)) {
                return false;
            }
            String this$shippingCode = this.getShippingCode();
            String other$shippingCode = other.getShippingCode();
            return !(this$shippingCode == null ? other$shippingCode != null : !this$shippingCode.equals(other$shippingCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JointShippingOrderGroupKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $platformOrderNo = this.getPlatformOrderNo();
            result = result * 59 + ($platformOrderNo == null ? 43 : $platformOrderNo.hashCode());
            String $shippingCode = this.getShippingCode();
            result = result * 59 + ($shippingCode == null ? 43 : $shippingCode.hashCode());
            return result;
        }

        public String toString() {
            return "SaleTransferReportServiceImpl.JointShippingOrderGroupKey(platformOrderNo=" + this.getPlatformOrderNo() + ", shippingCode=" + this.getShippingCode() + ")";
        }
    }
}

