/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.LargeBillsReqDto;
import com.dtyunxi.tcbj.api.dto.response.LargeBillsRespDto;
import com.dtyunxi.tcbj.biz.service.ILargeBillsService;
import com.dtyunxi.tcbj.dao.das.BalanceDas;
import com.dtyunxi.tcbj.dao.das.CreditAccountDas;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.GiftBalanceDas;
import com.dtyunxi.tcbj.dao.das.LargeBillsDas;
import com.dtyunxi.tcbj.dao.das.OfflineBalanceAccountDas;
import com.dtyunxi.tcbj.dao.das.OrderDas;
import com.dtyunxi.tcbj.dao.das.ReturnsQuotaAccountDas;
import com.dtyunxi.tcbj.dao.eo.BalanceEo;
import com.dtyunxi.tcbj.dao.eo.CreditAccountEo;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.eo.GiftBalanceEo;
import com.dtyunxi.tcbj.dao.eo.LargeBillsEo;
import com.dtyunxi.tcbj.dao.eo.OfflineBalanceAccountEo;
import com.dtyunxi.tcbj.dao.eo.ReturnsQuotaAccountEo;
import com.dtyunxi.tcbj.dao.vo.TerminalAmountVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LargeBillsServiceImpl
implements ILargeBillsService {
    private static Logger logger = LoggerFactory.getLogger(LargeBillsServiceImpl.class);
    private static Integer limitCount = 5000;
    @Resource
    private LargeBillsDas largeBillsDas;
    @Resource
    private CsCustomerDas csCustomerDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private GiftBalanceDas giftBalanceDas;
    @Resource
    private ReturnsQuotaAccountDas returnsQuotaAccountDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private OfflineBalanceAccountDas offlineBalanceAccountDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private HttpServletRequest request;
    private final ExecutorService executorService = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public PageInfo<LargeBillsRespDto> page(LargeBillsReqDto reqDto) {
        LargeBillsEo eo = new LargeBillsEo();
        if (!StringUtils.isBlank((CharSequence)reqDto.getStartMonth())) {
            eo = (LargeBillsEo)SqlFilterBuilder.create(LargeBillsEo.class).ge("month", (Object)reqDto.getStartMonth()).le("month", (Object)reqDto.getEndMonth()).eo();
        }
        if (!StringUtils.isBlank((CharSequence)reqDto.getCustomerName())) {
            eo.setCustomerName(reqDto.getCustomerName());
        }
        String orgInfoId = null;
        if (ObjectUtils.isEmpty((Object)reqDto.getOrgInfoId())) {
            orgInfoId = this.getHeaderOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgInfoId);
        } else {
            orgInfoId = String.valueOf(reqDto.getOrgInfoId());
        }
        eo.setOrgInfoId(StringUtils.isBlank((CharSequence)orgInfoId) ? null : Long.valueOf(Long.parseLong(orgInfoId)));
        PageInfo largeBillsEoPageInfo = this.largeBillsDas.selectPage((BaseEo)eo, reqDto.getPageNum(), reqDto.getPageSize());
        if (largeBillsEoPageInfo == null || CollectionUtils.isEmpty((Collection)largeBillsEoPageInfo.getList())) {
            return null;
        }
        PageInfo result = new PageInfo();
        ArrayList largeBillsRespDtoList = Lists.newArrayList();
        BeanUtils.copyProperties((Object)largeBillsEoPageInfo, (Object)result, (String[])new String[]{"list"});
        for (LargeBillsEo largeBillsEo : largeBillsEoPageInfo.getList()) {
            LargeBillsRespDto dto = new LargeBillsRespDto();
            BeanUtils.copyProperties((Object)largeBillsEo, (Object)dto);
            largeBillsRespDtoList.add(dto);
        }
        result.setList((List)largeBillsRespDtoList);
        return result;
    }

    @Override
    public void fixDate(String date) {
        CsCustomerEo csCustomerEo = new CsCustomerEo();
        csCustomerEo.setType(Integer.valueOf(3));
        int total = this.csCustomerDas.count((BaseEo)csCustomerEo);
        if (total <= 0) {
            logger.info("\u5927\u8d26\u5355\u6570\u636e\u4fee\u590d,\u672a\u67e5\u8be2\u5230customerId");
            throw new BizException("\u5927\u8d26\u5355\u6570\u636e\u4fee\u590d,\u672a\u67e5\u8be2\u5230customerId");
        }
        Stream.iterate(1, n -> n + 1).limit(this.getCount(total).intValue()).forEach(i -> {
            PageInfo limtCustomerList = this.csCustomerDas.selectPage((BaseEo)csCustomerEo, i, Integer.valueOf(5000));
            this.executorService.execute(() -> {
                try {
                    logger.info("\u5927\u8d26\u5355\u6570\u636e\u66f4\u65b0");
                    this.updateLargeBills(date, limtCustomerList.getList());
                }
                catch (Exception e) {
                    logger.error("\u66f4\u65b0\u5927\u8d26\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
                    e.printStackTrace();
                }
            });
        });
    }

    private Integer getCount(Integer size) {
        return (limitCount + size - 1) / limitCount;
    }

    private void updateLargeBills(String date, List<CsCustomerEo> customerEoList) {
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            logger.info("\u4fee\u590d\u671f\u672b\u5e94\u53d1\u91d1\u989d\u5386\u53f2\u6570\u636e");
            List customerIds = customerEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            String month = format.format(DateUtil.parse((String)date, (String)"yyyy-MM"));
            Map<Object, Object> terminalAmountVoMap = new HashMap();
            List terminalAmountVos = this.orderDas.selectTerminalAmount(customerIds, month);
            if (CollectionUtils.isNotEmpty((Collection)terminalAmountVos)) {
                terminalAmountVoMap = terminalAmountVos.stream().collect(Collectors.toMap(TerminalAmountVo::getCustomerId, Function.identity(), (v1, v2) -> v1));
            }
            ArrayList largeBillsEoList = Lists.newArrayList();
            for (CsCustomerEo eo : customerEoList) {
                LargeBillsEo largeBillsEo = new LargeBillsEo();
                largeBillsEo.setCustomerId(eo.getId());
                largeBillsEo.setCustomerCode(eo.getCode());
                largeBillsEo.setCustomerName(eo.getName());
                largeBillsEo.setOrgInfoId(eo.getMerchantId());
                largeBillsEo.setMonth(month);
                largeBillsEo.setTerminalCreditQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalGiftQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalReturnsQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalRebatesQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalOfflineQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalTotalAmount(BigDecimal.ZERO);
                if (terminalAmountVoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalTotalAmount(((TerminalAmountVo)terminalAmountVoMap.get(eo.getId())).getTerminalTotalAmount());
                }
                largeBillsEoList.add(largeBillsEo);
            }
            this.addLargeBillsBatch(largeBillsEoList);
        } else {
            List terminalAmountVos;
            List offlineBalanceAccountEoList;
            List balanceEoList;
            List returnsQuotaAccountEoList;
            List giftBalanceEoList;
            logger.info("\u66f4\u65b0\u5927\u8d26\u5355");
            Map<Object, Object> creditAccountEoMap = new HashMap();
            Map<Object, Object> giftBalanceEoMap = new HashMap();
            Map<Object, Object> returnsQuotaAccountEoMap = new HashMap();
            Map<Object, Object> balanceEoMap = new HashMap();
            Map<Object, Object> offlineBalanceAccountEoMap = new HashMap();
            Map<Object, Object> terminalAmountVoMap = new HashMap();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(2, -1);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            String month = format.format(cal.getTime());
            List customerIds = customerEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            List creditAccountEoList = this.creditAccountDas.select(SqlFilterBuilder.create(CreditAccountEo.class).in("creditEntityId", customerIds).eo());
            if (CollectionUtils.isNotEmpty((Collection)creditAccountEoList)) {
                creditAccountEoMap = creditAccountEoList.stream().collect(Collectors.toMap(CreditAccountEo::getCreditEntityId, Function.identity(), (v1, v2) -> v1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(giftBalanceEoList = this.giftBalanceDas.select(SqlFilterBuilder.create(GiftBalanceEo.class).in("customerId", customerIds).eo())))) {
                giftBalanceEoMap = giftBalanceEoList.stream().collect(Collectors.toMap(GiftBalanceEo::getCustomerId, Function.identity(), (v1, v2) -> v1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(returnsQuotaAccountEoList = this.returnsQuotaAccountDas.select(SqlFilterBuilder.create(ReturnsQuotaAccountEo.class).in("customerId", customerIds).eo())))) {
                returnsQuotaAccountEoMap = returnsQuotaAccountEoList.stream().collect(Collectors.toMap(ReturnsQuotaAccountEo::getCustomerId, Function.identity(), (v1, v2) -> v1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(balanceEoList = this.balanceDas.select(SqlFilterBuilder.create(BalanceEo.class).in("userId", customerIds).eq("userType", (Object)"CUSTOMER").eo())))) {
                balanceEoMap = balanceEoList.stream().collect(Collectors.toMap(BalanceEo::getUserId, Function.identity(), (v1, v2) -> v1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(offlineBalanceAccountEoList = this.offlineBalanceAccountDas.select(SqlFilterBuilder.create(OfflineBalanceAccountEo.class).in("customerId", customerIds).eo())))) {
                offlineBalanceAccountEoMap = offlineBalanceAccountEoList.stream().collect(Collectors.toMap(OfflineBalanceAccountEo::getCustomerId, Function.identity(), (v1, v2) -> v1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(terminalAmountVos = this.orderDas.selectTerminalAmount(customerIds, month)))) {
                terminalAmountVoMap = terminalAmountVos.stream().collect(Collectors.toMap(TerminalAmountVo::getCustomerId, Function.identity(), (v1, v2) -> v1));
            }
            ArrayList largeBillsEoList = Lists.newArrayList();
            for (CsCustomerEo eo : customerEoList) {
                LargeBillsEo largeBillsEo = new LargeBillsEo();
                largeBillsEo.setCustomerId(eo.getId());
                largeBillsEo.setCustomerCode(eo.getCode());
                largeBillsEo.setCustomerName(eo.getName());
                largeBillsEo.setOrgInfoId(eo.getMerchantId());
                largeBillsEo.setMonth(month);
                largeBillsEo.setTerminalCreditQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalGiftQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalReturnsQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalRebatesQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalOfflineQuota(BigDecimal.ZERO);
                largeBillsEo.setTerminalTotalAmount(BigDecimal.ZERO);
                if (creditAccountEoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalCreditQuota(((CreditAccountEo)creditAccountEoMap.get(eo.getId())).getAccountQuota());
                }
                if (giftBalanceEoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalGiftQuota(((GiftBalanceEo)giftBalanceEoMap.get(eo.getId())).getBalance());
                }
                if (returnsQuotaAccountEoMap.containsKey(eo.getId())) {
                    BigDecimal generalReturnsQuota = ((ReturnsQuotaAccountEo)returnsQuotaAccountEoMap.get(eo.getId())).getGeneralReturnsQuota() == null ? BigDecimal.ZERO : ((ReturnsQuotaAccountEo)returnsQuotaAccountEoMap.get(eo.getId())).getGeneralReturnsQuota();
                    BigDecimal advanceQuota = ((ReturnsQuotaAccountEo)returnsQuotaAccountEoMap.get(eo.getId())).getAdvanceQuota() == null ? BigDecimal.ZERO : ((ReturnsQuotaAccountEo)returnsQuotaAccountEoMap.get(eo.getId())).getAdvanceQuota();
                    largeBillsEo.setTerminalReturnsQuota(generalReturnsQuota.add(advanceQuota));
                }
                if (balanceEoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalRebatesQuota(((BalanceEo)balanceEoMap.get(eo.getId())).getBalance());
                } else {
                    largeBillsEo.setTerminalRebatesQuota(BigDecimal.ZERO);
                }
                if (offlineBalanceAccountEoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalOfflineQuota(((OfflineBalanceAccountEo)offlineBalanceAccountEoMap.get(eo.getId())).getAccountBalance());
                }
                if (terminalAmountVoMap.containsKey(eo.getId())) {
                    largeBillsEo.setTerminalTotalAmount(((TerminalAmountVo)terminalAmountVoMap.get(eo.getId())).getTerminalTotalAmount());
                }
                largeBillsEoList.add(largeBillsEo);
            }
            this.addLargeBillsBatch(largeBillsEoList);
        }
    }

    private void addLargeBillsBatch(List<LargeBillsEo> largeBillsEoList) {
        if (CollectionUtils.isNotEmpty(largeBillsEoList)) {
            if (largeBillsEoList.size() > 1000) {
                List partitionList = com.google.common.collect.Lists.partition(largeBillsEoList, (int)1000);
                partitionList.forEach(list -> this.largeBillsDas.insertBatch(list));
            } else {
                this.largeBillsDas.insertBatch(largeBillsEoList);
            }
        }
    }
}

