/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.api.dto.constant.PreemptSourceTypeConstants;
import com.dtyunxi.tcbj.api.dto.request.RpInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.response.RpInventoryPreemptionRespDto;
import com.dtyunxi.tcbj.biz.enums.OrderStatusEnum;
import com.dtyunxi.tcbj.biz.service.ICsInventoryPreemptionService;
import com.dtyunxi.tcbj.dao.das.ReInventoryPreemptionDas;
import com.dtyunxi.tcbj.dao.eo.AdjustmentInventoryEo;
import com.dtyunxi.tcbj.dao.eo.CsInventoryPreemptionEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.OutPlannedOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.eo.es.CsOtherStorageOrderEo;
import com.dtyunxi.tcbj.dao.mapper.AdjustmentInventoryMapper;
import com.dtyunxi.tcbj.dao.mapper.CsOtherStorageOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.CsTransferOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.LogicInventoryMapper;
import com.dtyunxi.tcbj.dao.mapper.OutPlannedOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.constants.CommonConstant;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsInventoryPreemptionServiceImpl
implements ICsInventoryPreemptionService {
    private static final Logger log = LoggerFactory.getLogger(CsInventoryPreemptionServiceImpl.class);
    @Autowired
    ReInventoryPreemptionDas inventoryPreemptionDas;
    @Autowired
    SaleOrderMapper saleOrderMapper;
    @Autowired
    LogicInventoryMapper logicInventoryMapper;
    @Autowired
    CsTransferOrderMapper transferOrderMapper;
    @Autowired
    CsOtherStorageOrderMapper csOtherStorageOrderMapper;
    @Autowired
    OutPlannedOrderMapper outPlannedOrderMapper;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    AdjustmentInventoryMapper adjustmentInventoryMapper;

    @Override
    public PageInfo<RpInventoryPreemptionRespDto> queryPage(RpInventoryPreemptionQueryDto queryDto) {
        PageInfo dtoPageInfo = new PageInfo();
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDas.filter().eq(StringUtils.isNotBlank((CharSequence)queryDto.getSourceNo()), (Object)"source_no", (Object)queryDto.getSourceNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getExternalOrderNo()), (Object)"external_order_no", (Object)queryDto.getExternalOrderNo())).eq(null != queryDto.getWarehouseId(), (Object)"warehouse_id", (Object)queryDto.getWarehouseId())).in(StringUtils.isNotBlank((CharSequence)queryDto.getSourceType()), (Object)"source_type", (Collection)queryDto.getSourceTypeList())).like(StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode()), (Object)"warehouse_code", (Object)queryDto.getWarehouseCode())).like(StringUtils.isNotBlank((CharSequence)queryDto.getCargoCode()), (Object)"sku_code", (Object)queryDto.getCargoCode())).like(StringUtils.isNotBlank((CharSequence)queryDto.getBatch()), (Object)"batch", (Object)queryDto.getBatch())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getValid()), (Object)"valid", (Object)queryDto.getValid())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getCargoCodeList()), (Object)"cargo_code", (Collection)queryDto.getCargoCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList())).page(queryDto.getPageNum(), queryDto.getPageSize());
        if (null == eoPageInfo) {
            return dtoPageInfo;
        }
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list"});
        List eoList = eoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoPageInfo;
        }
        boolean hasSaleOrder = false;
        boolean hasTransferOrder = false;
        boolean hasAdjustOrder = false;
        boolean hasOtherStorageOrder = false;
        boolean hasOutProductOrder = false;
        for (CsInventoryPreemptionEo inventoryPreemptionEo : eoList) {
            if (PreemptSourceTypeConstants.SALE_ORDER_TYPES.contains(inventoryPreemptionEo.getSourceType())) {
                hasSaleOrder = true;
                continue;
            }
            if (PreemptSourceTypeConstants.TRANSFER_ORDER_TYPES.contains(inventoryPreemptionEo.getSourceType())) {
                hasTransferOrder = true;
                continue;
            }
            if (PreemptSourceTypeConstants.ADJUST_ORDER_TYPES.contains(inventoryPreemptionEo.getSourceType())) {
                hasAdjustOrder = true;
                continue;
            }
            if (PreemptSourceTypeConstants.OTHER_STORAGE_ORDER_TYPES.contains(inventoryPreemptionEo.getSourceType())) {
                hasOtherStorageOrder = true;
                continue;
            }
            if (!PreemptSourceTypeConstants.OUT_PRODUCT_ORDER_TYPES.contains(inventoryPreemptionEo.getSourceType())) continue;
            hasOutProductOrder = true;
        }
        Map<Object, Object> saleOrderStatusMap = Maps.newHashMap();
        Map<Object, Object> transferOrderStatusMap = Maps.newHashMap();
        Map<Object, Object> adjustOrderStatusMap = Maps.newHashMap();
        Map<Object, Object> otherOrderStatusMap = Maps.newHashMap();
        Map<Object, Object> outProductOrderStatusMap = Maps.newHashMap();
        Set sourceNoList = eoList.stream().map(CsInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet());
        if (hasSaleOrder) {
            saleOrderStatusMap = this.saleOrderMapper.selectList((Wrapper)Wrappers.query((Object)new SaleOrderEo()).in((Object)"sale_order_no", sourceNoList)).stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, SaleOrderEo::getOrderStatus, (o, o1) -> o));
        }
        if (hasTransferOrder) {
            transferOrderStatusMap = this.csTransferOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).in(CsTransferOrderEo::getTransferOrderNo, sourceNoList)).stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getOrderStatus, (o, o1) -> o));
        }
        if (hasAdjustOrder) {
            adjustOrderStatusMap = this.adjustmentInventoryMapper.selectList((Wrapper)Wrappers.lambdaQuery(AdjustmentInventoryEo.class).in(AdjustmentInventoryEo::getAdjustmentNo, sourceNoList)).stream().collect(Collectors.toMap(AdjustmentInventoryEo::getAdjustmentNo, AdjustmentInventoryEo::getAdjustmentStatus, (o, o1) -> o));
        }
        if (hasOtherStorageOrder) {
            otherOrderStatusMap = this.csOtherStorageOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery(CsOtherStorageOrderEo.class).in(CsOtherStorageOrderEo::getStorageOrderNo, sourceNoList)).stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, CsOtherStorageOrderEo::getOrderStatus, (o, o1) -> o));
        }
        if (hasOutProductOrder) {
            outProductOrderStatusMap = this.outPlannedOrderMapper.selectList((Wrapper)Wrappers.lambdaQuery(OutPlannedOrderEo.class).in(OutPlannedOrderEo::getOrderNo, sourceNoList)).stream().collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, OutPlannedOrderEo::getOrderStatus, (o, o1) -> o));
        }
        ArrayList dtoList = Lists.newArrayList();
        for (CsInventoryPreemptionEo eo : eoList) {
            RpInventoryPreemptionRespDto dto = new RpInventoryPreemptionRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            Optional.ofNullable(saleOrderStatusMap.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatusName(Optional.ofNullable(SaleOrderStatusEnum.forCode((String)r)).map(SaleOrderStatusEnum::getDesc).orElse(""));
                dto.setOrderStatus(r);
            });
            Optional.ofNullable(transferOrderStatusMap.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatus(r);
                Lists.newArrayList((Object[])CsTransferOrderEnum.Status.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)r)).findFirst().ifPresent(status -> dto.setOrderStatusName(status.getDesc()));
            });
            Optional.ofNullable(adjustOrderStatusMap.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatus(r);
                dto.setOrderStatusName((String)CommonConstant.ADJUSTMENT_STATUS_VALUE_MAP.get(r));
            });
            Optional.ofNullable(otherOrderStatusMap.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatus(r);
                Lists.newArrayList((Object[])CsOtherStorageOrderStatusEnum.OUT.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)r)).findFirst().ifPresent(status -> dto.setOrderStatusName(status.getDesc()));
            });
            Optional.ofNullable(outProductOrderStatusMap.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatus(r);
                Lists.newArrayList((Object[])CsPlannedOrderStatusEnum.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)r)).findFirst().ifPresent(status -> dto.setOrderStatusName(status.getDesc()));
            });
            dtoList.add(dto);
        }
        dtoPageInfo.setList((List)dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<RpInventoryPreemptionRespDto> preemptedQueryPage(RpInventoryPreemptionQueryDto queryDto) {
        PageInfo eoPageInfo;
        PageInfo dtoPageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getEndTime()) && StringUtils.isNotBlank((CharSequence)queryDto.getStartTime())) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dd = df.parse(queryDto.getEndTime());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dd);
                calendar.add(5, 1);
                log.info("\u589e\u52a0\u4e00\u5929\u4e4b\u540e\uff1a" + df.format(calendar.getTime()));
                queryDto.setEndTime(df.format(calendar.getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (null == (eoPageInfo = this.inventoryPreemptionDas.selectCsShInventoryPreemption(queryDto))) {
            return dtoPageInfo;
        }
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list"});
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        Map<String, String> orderTransfer = this.transferOrderMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query((Object)new CsTransferOrderEo()).in((Object)"transfer_order_no", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet()))).eq((Object)"dr", (Object)0)).stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getOrderStatus, (o, o1) -> o));
        Map<String, String> orderOtherStorage = this.csOtherStorageOrderMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query((Object)new CsOtherStorageOrderEo()).in((Object)"storage_order_no", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet()))).eq((Object)"dr", (Object)0)).stream().collect(Collectors.toMap(CsOtherStorageOrderEo::getStorageOrderNo, CsOtherStorageOrderEo::getOrderStatus, (o, o1) -> o));
        Map<String, String> orderOutPlanned = this.outPlannedOrderMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query((Object)new OutPlannedOrderEo()).in((Object)"order_no", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet()))).eq((Object)"dr", (Object)0)).stream().collect(Collectors.toMap(OutPlannedOrderEo::getOrderNo, OutPlannedOrderEo::getOrderStatus, (o, o1) -> o));
        Map<String, String> order = this.saleOrderMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query((Object)new SaleOrderEo()).in((Object)"sale_order_no", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet()))).eq((Object)"dr", (Object)0)).stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, SaleOrderEo::getOrderStatus, (o, o1) -> o));
        Map map = this.logicInventoryMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query((Object)new LogicInventoryEo()).in((Object)"sku_code", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getSkuCode).collect(Collectors.toSet()))).in((Object)"batch", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getBatch).collect(Collectors.toSet()))).in((Object)"warehouse_code", (Collection)eoPageInfo.getList().stream().map(CsInventoryPreemptionEo::getWarehouseCode).collect(Collectors.toSet()))).eq((Object)"dr", (Object)0)).stream().collect(Collectors.toMap(k -> k.getSkuCode() + k.getBatch() + k.getWarehouseCode(), Function.identity(), (o, o1) -> o));
        List dtoList = eoPageInfo.getList().stream().map(eo -> {
            RpInventoryPreemptionRespDto dto = new RpInventoryPreemptionRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            dto.setCargoCode(eo.getSkuCode());
            dto.setLongCode(eo.getSkuCode());
            dto.setCargoName(eo.getSkuName());
            Optional.ofNullable(order.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatusName(Optional.ofNullable(SaleOrderStatusEnum.forCode((String)r)).map(SaleOrderStatusEnum::getDesc).orElse(""));
                dto.setOrderStatus(r);
            });
            Optional.ofNullable(orderTransfer.get(eo.getSourceNo())).ifPresent(r -> {
                if (StringUtils.isBlank((CharSequence)dto.getOrderStatus())) {
                    String a = r.toUpperCase();
                    dto.setOrderStatus(a);
                    dto.setOrderStatusName(Optional.ofNullable(OrderStatusEnum.toName(a)).orElse(""));
                }
            });
            Optional.ofNullable(orderOtherStorage.get(eo.getSourceNo())).ifPresent(r -> {
                if (StringUtils.isBlank((CharSequence)dto.getOrderStatus())) {
                    String a = r.toUpperCase();
                    dto.setOrderStatus(a);
                    dto.setOrderStatusName(Optional.ofNullable(OrderStatusEnum.toName(a)).orElse(""));
                }
            });
            Optional.ofNullable(orderOutPlanned.get(eo.getSourceNo())).ifPresent(r -> {
                if (StringUtils.isBlank((CharSequence)dto.getOrderStatus())) {
                    String a = r.toUpperCase();
                    dto.setOrderStatus(a);
                    dto.setOrderStatusName(Optional.ofNullable(OrderStatusEnum.toName(a)).orElse(""));
                }
            });
            Optional.ofNullable(map.get(eo.getSkuCode() + eo.getBatch() + eo.getWarehouseCode())).ifPresent(r -> {
                if (r.getProduceTime() != null) {
                    dto.setProduceTime(DateUtil.format((Date)r.getProduceTime(), (String)"yyyy-MM-dd"));
                }
                if (r.getExpireTime() != null) {
                    dto.setExpireTime(DateUtil.format((Date)r.getExpireTime(), (String)"yyyy-MM-dd"));
                }
            });
            return dto;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public RpInventoryPreemptionRespDto inventoryPreemptionCount(RpInventoryPreemptionQueryDto queryDto) {
        if (StringUtils.isNotBlank((CharSequence)queryDto.getEndTime()) && StringUtils.isNotBlank((CharSequence)queryDto.getStartTime())) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dd = df.parse(queryDto.getEndTime());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dd);
                calendar.add(5, 1);
                System.out.println("\u589e\u52a0\u4e00\u5929\u4e4b\u540e\uff1a" + df.format(calendar.getTime()));
                queryDto.setEndTime(df.format(calendar.getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return this.inventoryPreemptionDas.inventoryPreemptionCount(queryDto);
    }
}

