/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleasePlanReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleasePlanRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.IInspectionReleasePlanService;
import com.dtyunxi.tcbj.dao.das.InspectionReleaseOrderDas;
import com.dtyunxi.tcbj.dao.das.InspectionReleasePlanDas;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.eo.InspectionReleasePlanEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleasePlanServiceImpl
implements IInspectionReleasePlanService {
    @Resource
    private InspectionReleasePlanDas inspectionReleasePlanDas;
    @Resource
    private LogicInventoryDas logicInventoryDas;
    @Resource
    private InspectionReleaseOrderDas inspectionReleaseOrderDas;

    @Override
    public Long addInspectionReleasePlan(InspectionReleasePlanReqDto addReqDto) {
        InspectionReleasePlanEo inspectionReleasePlanEo = new InspectionReleasePlanEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleasePlanEo);
        this.inspectionReleasePlanDas.insert((BaseEo)inspectionReleasePlanEo);
        return inspectionReleasePlanEo.getId();
    }

    @Override
    public void modifyInspectionReleasePlan(InspectionReleasePlanReqDto modifyReqDto) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)modifyReqDto.getBatch()), (String)"\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)modifyReqDto.getSkuCode()), (String)"\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionReleasePlanDas.filter().eq((Object)"sku_code", (Object)modifyReqDto.getSkuCode())).eq((Object)"batch", (Object)modifyReqDto.getBatch())).list();
        InspectionReleasePlanEo planEo = new InspectionReleasePlanEo();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            Long id = ((InspectionReleasePlanEo)eos.get(0)).getId();
            planEo.setId(id);
            planEo.setPlanReleaseNum(Optional.ofNullable(modifyReqDto.getPlanReleaseNum()).orElse(BigDecimal.ZERO));
            this.inspectionReleasePlanDas.updateSelective((BaseEo)planEo);
        } else {
            BeanUtils.copyProperties((Object)modifyReqDto, (Object)planEo);
            planEo.setPlanReleaseNum(Optional.ofNullable(modifyReqDto.getPlanReleaseNum()).orElse(BigDecimal.ZERO));
            this.inspectionReleasePlanDas.insert((BaseEo)planEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleasePlan(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleasePlanDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleasePlanRespDto queryById(Long id) {
        InspectionReleasePlanEo inspectionReleasePlanEo = (InspectionReleasePlanEo)this.inspectionReleasePlanDas.selectByPrimaryKey(id);
        InspectionReleasePlanRespDto inspectionReleasePlanRespDto = new InspectionReleasePlanRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleasePlanEo, (BaseVo)inspectionReleasePlanRespDto);
        return inspectionReleasePlanRespDto;
    }

    @Override
    public PageInfo<InspectionReleasePlanRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleasePlanReqDto inspectionReleasePlanReqDto = (InspectionReleasePlanReqDto)JSON.parseObject((String)filter, InspectionReleasePlanReqDto.class);
        InspectionReleasePlanEo inspectionReleasePlanEo = new InspectionReleasePlanEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleasePlanReqDto, (BaseEo)inspectionReleasePlanEo);
        PageInfo eoPageInfo = this.inspectionReleasePlanDas.selectPage((BaseEo)inspectionReleasePlanEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleasePlanRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<InspectionReleasePlanRespDto> queryBatchByPage(InspectionReleasePlanReqDto dto) {
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionReleaseOrderDas.filter().in(CollectionUtil.isNotEmpty((Collection)dto.getBatchList()), (Object)"batch", (Collection)dto.getBatchList())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), (Object)"sku_code", (Collection)dto.getSkuCodeList())).list();
        ArrayList<InspectionReleasePlanRespDto> dtoList = new ArrayList<InspectionReleasePlanRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, InspectionReleasePlanRespDto.class);
        return dtoList;
    }

    @Override
    public List<LogicInventoryRespDto> queryAvailableByPage(InspectionReleasePlanReqDto dto) {
        List eos = this.logicInventoryDas.queryAvailableByPage(dto);
        ArrayList<LogicInventoryRespDto> dtoList = new ArrayList<LogicInventoryRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, LogicInventoryRespDto.class);
        return dtoList;
    }
}

