/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.StrategyAutoCheckRuleReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderChannelRespDto;
import com.dtyunxi.tcbj.api.dto.response.StrategyAutoCheckRuleReportRespDto;
import com.dtyunxi.tcbj.biz.service.IStrategyAutoCheckRuleService;
import com.dtyunxi.tcbj.dao.das.StrategyAutoCheckChannelDas;
import com.dtyunxi.tcbj.dao.das.StrategyAutoCheckOrderTypeDas;
import com.dtyunxi.tcbj.dao.das.StrategyAutoCheckRuleDas;
import com.dtyunxi.tcbj.dao.eo.StrategyAutoCheckOrderTypeEo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StrategyAutoCheckRuleServiceImpl
implements IStrategyAutoCheckRuleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StrategyAutoCheckRuleDas strategyAutoCheckRuleDas;
    @Resource
    private StrategyAutoCheckChannelDas strategyAutoCheckChannelDas;
    @Resource
    private StrategyAutoCheckOrderTypeDas strategyAutoCheckOrderTypeDas;

    @Override
    public PageInfo<StrategyAutoCheckRuleReportRespDto> queryByPage(StrategyAutoCheckRuleReportReqDto filter) {
        Page eoPageInfo = this.strategyAutoCheckRuleDas.queryByPage(filter);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getResult(), StrategyAutoCheckRuleReportRespDto.class);
        if (!CollectionUtils.isEmpty(dtoList)) {
            List ruleIdList = dtoList.stream().map(BaseRespDto::getId).distinct().collect(Collectors.toList());
            List orderChannelRespDtoList = this.strategyAutoCheckChannelDas.queryStrategyAutoCheckChannelByStrategyAutoCheckRuleIdList(ruleIdList);
            Map<Object, Object> orderChannelRespDtoListByRuleIdMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)orderChannelRespDtoList)) {
                orderChannelRespDtoListByRuleIdMap = orderChannelRespDtoList.stream().collect(Collectors.groupingBy(OrderChannelRespDto::getRuleId));
            }
            LambdaQueryWrapper orderTypeEoQueryWrapper = new LambdaQueryWrapper();
            orderTypeEoQueryWrapper.eq(BaseEo::getDr, (Object)0);
            orderTypeEoQueryWrapper.in(StrategyAutoCheckOrderTypeEo::getRuleId, ruleIdList);
            List checkOrderTypeEos = this.strategyAutoCheckOrderTypeDas.list((Wrapper)orderTypeEoQueryWrapper);
            Map<Object, Object> orderTypeCodeMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)checkOrderTypeEos)) {
                orderTypeCodeMap = checkOrderTypeEos.stream().collect(Collectors.groupingBy(StrategyAutoCheckOrderTypeEo::getRuleId));
            }
            for (StrategyAutoCheckRuleReportRespDto respDto : dtoList) {
                List autoCheckOrderTypeEos;
                List orderChannelRespDtos = (List)orderChannelRespDtoListByRuleIdMap.get(respDto.getId());
                respDto.setApplyOrderChannels(orderChannelRespDtos);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderChannelRespDtos)) {
                    respDto.setChannelSelectedType(((OrderChannelRespDto)orderChannelRespDtos.stream().findFirst().get()).getChannelSelectedType());
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(autoCheckOrderTypeEos = (List)orderTypeCodeMap.get(respDto.getId())))) {
                    List orderTypeCodeList = autoCheckOrderTypeEos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getOrderType())).map(StrategyAutoCheckOrderTypeEo::getOrderType).collect(Collectors.toList());
                    respDto.setApplyOrderType(orderTypeCodeList);
                    respDto.setOrderTypeSelectedType(((StrategyAutoCheckOrderTypeEo)autoCheckOrderTypeEos.stream().findFirst().get()).getSelectType());
                    continue;
                }
                respDto.setOrderTypeSelectedType("ALL");
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

