/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.schedule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.IStorageChargeBillService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="syncStorageChargeBillDataScheduled")
@Scope(value="prototype")
public class SyncStorageChargeBillDataScheduled
extends SingleTupleScheduleEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncStorageChargeBillDataScheduled.class);
    @Resource
    private IStorageChargeBillService storageChargeBillService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            Date date = StringUtils.isNotBlank((CharSequence)taskMsg.getContent()) ? com.dtyunxi.util.DateUtil.parse((String)taskMsg.getContent(), (String)"yyyy-MM-dd") : DateUtil.getDayBegin((Date)new Date());
            LOGGER.info("\u4ed3\u50a8\u8d26\u5355\u751f\u6210\u8c03\u5ea6\uff1a{}", (Object)date.toString());
            date = DateUtil.addMonths((Date)date, (int)-1);
            this.storageChargeBillService.syncStorageChargeBill(date, null);
            this.correctionStorageChargeBill(date);
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u62bd\u53d6\u4ed3\u50a8\u660e\u7ec6\u6570\u636e\u3011\u8c03\u5ea6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38\uff1a{},{}", (Object)com.dtyunxi.util.DateUtil.getSysDate(), (Object)JSON.toJSONString((Object)e));
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void correctionStorageChargeBill(Date date) {
        try {
            this.storageChargeBillService.correctionStorageChargeBill(date);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6b63\u4ed3\u50a8\u8d26\u5355\u6570\u636e\u5f02\u5e38");
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

