/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticInfoStatusEnum;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoSyncDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOutResultInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderLogisticsAddressRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderLogisticsInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderLogisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.CsLogisticsInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryInformationRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticOutResultInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsInfoRespDto;
import com.dtyunxi.tcbj.biz.service.ICsLogisticsInfoService;
import com.dtyunxi.tcbj.biz.utils.TransactionCallBackService;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDas;
import com.dtyunxi.tcbj.dao.das.LogisticInTransitDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.ReLogisticsInfoDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.tcbj.dao.eo.CsLogisticsInfoEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.mapper.ConsignmentOrderDeliveryInfoMapper;
import com.dtyunxi.tcbj.dao.mapper.ConsignmentOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.CsLogisticsInfoMapper;
import com.dtyunxi.tcbj.dao.mapper.CsTransferOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.OutResultOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqModifyEstimateArrivalTimeDto;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsLogisticsInfoServiceImpl
implements ICsLogisticsInfoService {
    private static final Logger log = LoggerFactory.getLogger(CsLogisticsInfoServiceImpl.class);
    @Resource
    private ReLogisticsInfoDas reLogisticsInfoDas;
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Autowired
    ConsignmentOrderMapper consignmentOrderMapper;
    @Autowired
    CsLogisticsInfoMapper logisticsInfoMapper;
    @Autowired
    OutResultOrderMapper outResultOrderMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoMapper consignmentOrderDeliveryInfoMapper;
    @Autowired
    LogisticInTransitDas logisticInTransitDas;
    @Resource
    private SaleOrderMapper saleOrderMapper;
    @Resource
    private CsTransferOrderMapper csTransferOrderMapper;

    @Override
    public Long addCsLogisticsInfo(CsLogisticsInfoReqDto addReqDto) {
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csLogisticsInfoEo);
        this.reLogisticsInfoDas.insert((BaseEo)csLogisticsInfoEo);
        return csLogisticsInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addLogistics(List<CsLogisticsInfoReqDto> addReqDto) {
        log.info("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u6279\u91cf\u5bfc\u5165:{}", (Object)JSON.toJSONString(addReqDto));
        if (CollectionUtil.isEmpty(addReqDto)) {
            return;
        }
        ArrayList eoList = Lists.newArrayList();
        for (CsLogisticsInfoReqDto dto : addReqDto) {
            CsLogisticsInfoEo logisticsInfoEo = new CsLogisticsInfoEo();
            BeanUtils.copyProperties((Object)dto, (Object)logisticsInfoEo);
            String signState = "4";
            if (Objects.equals(logisticsInfoEo.getStatus(), signState)) {
                logisticsInfoEo.setActualArrivalTime(Optional.ofNullable(logisticsInfoEo.getActualArrivalTime()).orElse(logisticsInfoEo.getCreateTime()));
                this.transactionCallBackService.execute(() -> {
                    CsLogisticsInfoRespDto respDto = new CsLogisticsInfoRespDto();
                    BeanUtils.copyProperties((Object)logisticsInfoEo, (Object)respDto);
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)JSON.toJSONString((Object)respDto));
                    this.commonsMqService.publishMessage("LOGISTICS_SIGN_EVENT", (Object)messageVo);
                });
            }
            eoList.add(logisticsInfoEo);
            if (!StringUtils.isNotBlank((CharSequence)dto.getConsignmentNo()) || dto.getExpectedArrivalTime() == null) continue;
            MessageVo messageVo = new MessageVo();
            MqModifyEstimateArrivalTimeDto mqModifyEstimateArrivalTimeDto = new MqModifyEstimateArrivalTimeDto();
            mqModifyEstimateArrivalTimeDto.setConsignmentNo(dto.getConsignmentNo());
            mqModifyEstimateArrivalTimeDto.setEstimatedTime(dto.getExpectedArrivalTime());
            messageVo.setData((Object)JSON.toJSONString((Object)mqModifyEstimateArrivalTimeDto));
            this.commonsMqService.sendSingleMessage("MODIFY_ESTIMATED_ARRIVAL_TIME", (Object)messageVo);
        }
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            this.reLogisticsInfoDas.insertBatch((List)eoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logisticsInfoSync(String str) {
        CsLogisticsInfoSyncDto csLogisticsInfoSyncDto = (CsLogisticsInfoSyncDto)JSON.parseObject((String)str, CsLogisticsInfoSyncDto.class);
        List dataInfoList = csLogisticsInfoSyncDto.getDataInfoList();
        dataInfoList.stream().sorted((o1, o2) -> {
            if (StringUtils.equals((CharSequence)o1.getOperTime(), (CharSequence)o2.getOperTime())) {
                return o1.getStatus().compareTo(o2.getStatus());
            }
            return o1.getOperTime().compareTo(o2.getOperTime());
        }).forEach(info -> {
            CsLogisticsInfoEo logisticsInfoEo = new CsLogisticsInfoEo();
            CubeBeanUtils.copyProperties((Object)logisticsInfoEo, (Object)info, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)info.getOperTime())) {
                logisticsInfoEo.setOperTime(DateUtil.parseDate((String)info.getOperTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getCreateTime())) {
                logisticsInfoEo.setCreateTime(DateUtil.parseDate((String)info.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.equals((CharSequence)logisticsInfoEo.getStatus(), (CharSequence)"4")) {
                if (StringUtils.isNotBlank((CharSequence)info.getActualArrivalTime())) {
                    logisticsInfoEo.setActualArrivalTime(DateUtil.parseDate((String)info.getActualArrivalTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                logisticsInfoEo.setActualArrivalTime(Optional.ofNullable(logisticsInfoEo.getActualArrivalTime()).orElse(logisticsInfoEo.getOperTime()));
            } else if (StringUtils.equals((CharSequence)logisticsInfoEo.getStatus(), (CharSequence)"5")) {
                List csLogisticsInfoEos = this.logisticsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsLogisticsInfoEo.class).eq(CsLogisticsInfoEo::getConsignmentNo, (Object)logisticsInfoEo.getConsignmentNo())).eq(CsLogisticsInfoEo::getStatus, (Object)"4")).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByDesc(BaseEo::getCreateTime));
                if (CollectionUtils.isNotEmpty((Collection)csLogisticsInfoEos) && null != ((CsLogisticsInfoEo)csLogisticsInfoEos.get(0)).getActualArrivalTime()) {
                    logisticsInfoEo.setActualArrivalTime(((CsLogisticsInfoEo)csLogisticsInfoEos.get(0)).getActualArrivalTime());
                } else if (StringUtils.isNotBlank((CharSequence)info.getActualArrivalTime())) {
                    logisticsInfoEo.setActualArrivalTime(DateUtil.parseDate((String)info.getActualArrivalTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            String signState = "4";
            if (Objects.equals(logisticsInfoEo.getStatus(), signState)) {
                this.transactionCallBackService.execute(() -> {
                    CsLogisticsInfoRespDto respDto = new CsLogisticsInfoRespDto();
                    BeanUtils.copyProperties((Object)logisticsInfoEo, (Object)respDto);
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)JSON.toJSONString((Object)respDto));
                    this.commonsMqService.publishMessage("LOGISTICS_SIGN_EVENT", (Object)messageVo);
                });
            }
            this.reLogisticsInfoDas.insert((BaseEo)logisticsInfoEo);
        });
    }

    @Override
    public void modifyCsLogisticsInfo(CsLogisticsInfoReqDto modifyReqDto) {
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csLogisticsInfoEo);
        this.reLogisticsInfoDas.updateSelective((BaseEo)csLogisticsInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsLogisticsInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.reLogisticsInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsLogisticsInfoRespDto queryById(Long id) {
        CsLogisticsInfoEo csLogisticsInfoEo = (CsLogisticsInfoEo)this.reLogisticsInfoDas.selectByPrimaryKey(id);
        CsLogisticsInfoRespDto csLogisticsInfoRespDto = new CsLogisticsInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)csLogisticsInfoEo, (BaseVo)csLogisticsInfoRespDto);
        return csLogisticsInfoRespDto;
    }

    @Override
    public List<CsLogisticsInfoRespDto> queryByCspNos(List<String> cspNoList) {
        if (CollectionUtils.isEmpty(cspNoList)) {
            return Lists.newArrayList();
        }
        List consignmentOrderEos = this.consignmentOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).in(ConsignmentOrderEo::getExternalOrderNo, cspNoList)).in(ConsignmentOrderEo::getOrderStatus, (Collection)Lists.newArrayList((Object[])new Integer[]{1, 2}))).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)consignmentOrderEos)) {
            List consignmentOrderRespDtos = this.consignmentOrderDas.queryDeliveryInfor(cspNoList);
            if (CollectionUtils.isEmpty((Collection)consignmentOrderRespDtos)) {
                return Lists.newArrayList();
            }
            for (ConsignmentOrderRespDto dto : consignmentOrderRespDtos) {
                ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
                BeanUtils.copyProperties((Object)dto, (Object)consignmentOrderEo);
                consignmentOrderEo.setExternalOrderNo(dto.getPlatformOrderNo());
                consignmentOrderEos.add(consignmentOrderEo);
            }
            if (CollectionUtils.isEmpty((Collection)consignmentOrderEos)) {
                return Lists.newArrayList();
            }
        }
        List wmsConsignmentNos = consignmentOrderEos.stream().map(ConsignmentOrderEo::getWmsConsignmentNo).distinct().collect(Collectors.toList());
        List outResultOrderNos = consignmentOrderEos.stream().map(ConsignmentOrderEo::getOutResultNo).distinct().collect(Collectors.toList());
        List consignmentNos = consignmentOrderEos.stream().map(ConsignmentOrderEo::getConsignmentNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        List csLogisticsInfoEos = this.logisticsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsLogisticsInfoEo.class).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.in(CsLogisticsInfoEo::getConsignmentNo, (Collection)wmsConsignmentNos)).or()).in(CsLogisticsInfoEo::getCspNo, (Collection)cspNoList);
        })).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByAsc(BaseEo::getCreateTime));
        List consignmentOrderDeliveryInfoEos = this.consignmentOrderDeliveryInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderDeliveryInfoEo.class).in(ConsignmentOrderDeliveryInfoEo::getConsignmentNo, consignmentNos)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List outResultOrderEos = this.outResultOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OutResultOrderEo.class).in(OutResultOrderEo::getDocumentNo, outResultOrderNos)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList respDtoList = Lists.newArrayList();
        for (ConsignmentOrderEo consignmentOrderEo : consignmentOrderEos) {
            CsLogisticsInfoEo csLogisticsInfoEo;
            if (!Objects.equals(1, consignmentOrderEo.getConsignmentType())) continue;
            long maxId = csLogisticsInfoEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getConsignmentNo(), (CharSequence)consignmentOrderEo.getWmsConsignmentNo()) || StringUtils.equals((CharSequence)o.getCspNo(), (CharSequence)consignmentOrderEo.getExternalOrderNo())).mapToLong(BaseEo::getId).max().orElse(-1L);
            CsLogisticsInfoRespDto respDto = new CsLogisticsInfoRespDto();
            if (maxId > 0L && null != (csLogisticsInfoEo = (CsLogisticsInfoEo)csLogisticsInfoEos.stream().filter(o -> Objects.equals(o.getId(), maxId)).findFirst().orElse(null))) {
                BeanUtils.copyProperties((Object)csLogisticsInfoEo, (Object)respDto);
            }
            respDto.setConsignmentNo(consignmentOrderEo.getWmsConsignmentNo());
            respDto.setSecondaryConsignmentNo(consignmentOrderEo.getSecondaryConsignmentNo());
            respDto.setWarehouseName(consignmentOrderEo.getPhysicsWarehouseName());
            respDto.setCspNo(consignmentOrderEo.getExternalOrderNo());
            consignmentOrderDeliveryInfoEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getConsignmentNo(), (CharSequence)consignmentOrderEo.getConsignmentNo())).findFirst().ifPresent(originConsignmentOrderDeliveryInfoEo -> {
                respDto.setShipTime(originConsignmentOrderDeliveryInfoEo.getDeliveryTime());
                respDto.setCarrierName(originConsignmentOrderDeliveryInfoEo.getCarrierName());
                respDto.setCarrierCode(originConsignmentOrderDeliveryInfoEo.getCarrierCode());
                respDto.setCarrierNo(originConsignmentOrderDeliveryInfoEo.getCarrierNo());
                respDto.setCarrierType(originConsignmentOrderDeliveryInfoEo.getCarrierType());
                respDto.setCarLicenseNo(originConsignmentOrderDeliveryInfoEo.getCarLicenseNo());
                respDto.setDriverName(originConsignmentOrderDeliveryInfoEo.getDriverName());
                respDto.setDriverPhone(originConsignmentOrderDeliveryInfoEo.getDriverPhone());
            });
            List filterConsignmentOrderEos = consignmentOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWmsConsignmentNo(), (CharSequence)respDto.getConsignmentNo())).collect(Collectors.toList());
            long maxConsignmentOrderId = filterConsignmentOrderEos.stream().mapToLong(BaseEo::getId).max().orElse(-1L);
            filterConsignmentOrderEos.stream().filter(o -> Objects.equals(maxConsignmentOrderId, o.getId())).findFirst().flatMap(lastConsignmentOrderEo -> consignmentOrderDeliveryInfoEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getConsignmentNo(), (CharSequence)lastConsignmentOrderEo.getConsignmentNo())).findFirst()).ifPresent(lastConsignmentOrderDeliveryInfoEo -> respDto.setActualArrivalTime(lastConsignmentOrderDeliveryInfoEo.getActualArriveTime()));
            OutResultOrderEo outResultOrderEo = null;
            if (StringUtils.isNotBlank((CharSequence)respDto.getCspNo())) {
                outResultOrderEo = outResultOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getExternalOrderNo(), (CharSequence)respDto.getCspNo())).findFirst().orElse(null);
            } else if (CollectionUtils.isNotEmpty(filterConsignmentOrderEos)) {
                String outResultNo = ((ConsignmentOrderEo)filterConsignmentOrderEos.get(0)).getOutResultNo();
                outResultOrderEo = outResultOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getDocumentNo(), (CharSequence)outResultNo)).findFirst().orElse(null);
            }
            if (null != outResultOrderEo) {
                respDto.setTotalCartons(String.valueOf(outResultOrderEo.getTotalCartons()));
                respDto.setMergeQuantity(String.valueOf(outResultOrderEo.getMergeQuantity()));
                respDto.setExpectedArrivalTime(outResultOrderEo.getEstimatedTime());
            }
            respDto.setUnit("\u4e2a");
            respDtoList.add(respDto);
        }
        log.info("queryByCspNos respDtoList: {}", (Object)JSON.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    @Override
    public PageInfo<CsLogisticsInfoRespDto> queryByPage(CsLogisticsInfoReqDto csLogisticsInfoReqDto) {
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)csLogisticsInfoReqDto, (BaseEo)csLogisticsInfoEo);
        csLogisticsInfoEo.setOrderByDesc("id");
        PageInfo eoPageInfo = this.reLogisticsInfoDas.selectPage((BaseEo)csLogisticsInfoEo, csLogisticsInfoReqDto.getPageNum(), csLogisticsInfoReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsLogisticsInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public LogisticsInfoRespDto queryLogisticsInfoReqDto(String shippingCode) {
        OutResultOrderEo outResultOrderEo = new OutResultOrderEo();
        outResultOrderEo.setShippingCode(shippingCode);
        List outResultOrderEoList = this.outResultOrderDas.select((BaseEo)outResultOrderEo);
        if (CollectionUtil.isEmpty((Collection)outResultOrderEoList)) {
            throw new BizException("\u627e\u4e0d\u5230\u7269\u6d41\u4fe1\u606f\u3002");
        }
        outResultOrderEo = outResultOrderEoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getShippingJson())).findFirst().orElseThrow(() -> new BizException("\u627e\u4e0d\u5230\u7269\u6d41\u4fe1\u606f\u3002"));
        LogisticsInfoRespDto logisticsInfoRespDto = new LogisticsInfoRespDto();
        logisticsInfoRespDto.setCarrierName(outResultOrderEo.getShippingCompany());
        logisticsInfoRespDto.setConsignmentNo(outResultOrderEo.getShippingCode());
        logisticsInfoRespDto.setDeliveryWay(outResultOrderEo.getShippingType());
        List csLogisticsInfoEos = this.reLogisticsInfoDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsLogisticsInfoEo.class).eq(CsLogisticsInfoEo::getConsignmentNo, (Object)outResultOrderEo.getConsignmentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByDesc(CsLogisticsInfoEo::getOperTime));
        List detailList = Optional.ofNullable(csLogisticsInfoEos).orElseGet(ArrayList::new).stream().map(eo -> {
            LogisticsInfoRespDto.LogisticsInfoDetail detail = new LogisticsInfoRespDto.LogisticsInfoDetail();
            BeanUtils.copyProperties((Object)eo, (Object)detail);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"9", (CharSequence)eo.getStatus())) {
                detail.setOperInfo(detail.getRemark());
            }
            return detail;
        }).collect(Collectors.toList());
        logisticsInfoRespDto.setDetailList(detailList);
        return logisticsInfoRespDto;
    }

    @Override
    public ConsignmentOrderLogisticsRespDto queryConsignmentLogisticsInfoReqDto(String consignmentNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)consignmentNo), (String)"\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ConsignmentOrderLogisticsRespDto respDto = new ConsignmentOrderLogisticsRespDto();
        ConsignmentOrderLogisticsAddressRespDto dto = this.consignmentOrderDas.queryLogisticsAddress(consignmentNo);
        if (ObjectUtil.isEmpty((Object)dto)) {
            return respDto;
        }
        BeanUtils.copyProperties((Object)dto, (Object)respDto);
        if (StringUtils.isBlank((CharSequence)respDto.getWmsConsignmentNo())) {
            return respDto;
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reLogisticsInfoDas.filter().eq((Object)"consignment_no", (Object)respDto.getWmsConsignmentNo())).orderByDesc((Object)"oper_time")).list();
        if (CollectionUtils.isNotEmpty((Collection)eos)) {
            List dtos = eos.stream().map(o -> {
                ConsignmentOrderLogisticsInfoRespDto vo = new ConsignmentOrderLogisticsInfoRespDto();
                DtoHelper.eo2Dto((BaseEo)o, (BaseVo)vo);
                if (!Objects.equals(o.getStatus(), "9")) {
                    vo.setStatusName((String)LogisticInfoStatusEnum.map.get(o.getStatus()));
                } else {
                    vo.setStatusName(o.getRemark());
                }
                return vo;
            }).collect(Collectors.toList());
            respDto.setConsignmentOrderLogisticsInfoRespDtoList(dtos);
        }
        return respDto;
    }

    @Override
    public List<DeliveryInformationRespDto> queryResultDeliveryInformation(String documentNo) {
        return this.consignmentOrderDas.queryResultDeliveryInformation(documentNo);
    }

    @Override
    public List<DeliveryInformationRespDto> queryOutDeliveryInformation(String documentNo) {
        return this.consignmentOrderDas.queryOutDeliveryInformation(documentNo);
    }

    @Override
    public List<DeliveryInformationRespDto> queryTakeDeliveryInformation(String documentNo) {
        return this.consignmentOrderDas.queryTakeDeliveryInformation(documentNo);
    }

    @Override
    public List<DeliveryInformationRespDto> queryTakeDeliveryResultInformation(String documentNo) {
        return this.consignmentOrderDas.queryTakeDeliveryResultInformation(documentNo);
    }

    @Override
    public List<LogisticOutResultInfoRespDto> queryLogisticsOutResultByList(LogisticOutResultInfoReqDto queryDto) {
        return this.logisticInTransitDas.queryLogisticsOutResultByList(queryDto);
    }
}

