/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SecurityCodeReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SecurityCodeReportRespDto;
import com.dtyunxi.tcbj.biz.service.query.ISecurityCodeReportService;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDas;
import com.dtyunxi.tcbj.dao.das.SecurityCodeDas;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SecurityCodeReportServiceImpl
implements ISecurityCodeReportService {
    @Resource
    private OutResultOrderDas outResultOrderDas;
    @Resource
    private SecurityCodeDas securityCodeDas;

    @Override
    public RestResponse<PageInfo<SecurityCodeReportRespDto>> getSecurityCodeReportListPage(@RequestBody(required=false) SecurityCodeReportReqDto securityCodeReportReqDto) {
        Page page = this.outResultOrderDas.getLogisticsSecurityCodeListPage(securityCodeReportReqDto);
        List pageResult = page.getResult();
        if (CollectionUtils.isNotEmpty((Collection)pageResult)) {
            for (SecurityCodeReportRespDto securityCodeReportRespDto : pageResult) {
                String businessType;
                CsPcpBusinessTypeEnum businessTypeEnum;
                String deliveryTime = securityCodeReportRespDto.getDeliveryTime();
                if (Objects.nonNull(deliveryTime)) {
                    System.out.println(deliveryTime);
                }
                if (!Objects.nonNull(businessTypeEnum = CsPcpBusinessTypeEnum.getByCode((String)(businessType = securityCodeReportRespDto.getBusinessType())))) continue;
                String desc = businessTypeEnum.getDesc();
                securityCodeReportRespDto.setBusinessType(desc);
            }
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)pageResult)) {
            result.setList(pageResult);
        }
        return new RestResponse((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> generateSecurityCodeReport() {
        String currenDate = DateUtil.getCurrenDate();
        this.securityCodeDas.initData(currenDate);
        return new RestResponse();
    }
}

