/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.express;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDeliverQuantityReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDeliverQuantityRespDto;
import com.dtyunxi.tcbj.biz.dto.express.SfDsBkCostChargeModeDto;
import com.dtyunxi.tcbj.biz.dto.express.SfDsBkCostChargeModeInfo;
import com.dtyunxi.tcbj.biz.dto.express.SfDsBkExpressAreaDto;
import com.dtyunxi.tcbj.biz.dto.express.VoteRangeInfoDto;
import com.dtyunxi.tcbj.biz.service.IExpressCostDeliverQuantityService;
import com.dtyunxi.tcbj.biz.service.impl.express.HandlerAbstractCostReportServiceImpl;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractCostReportService_1")
public class SfDsBkTemplateServiceImpl
extends HandlerAbstractCostReportServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(SfDsBkTemplateServiceImpl.class);
    @Resource
    private IExpressCostDeliverQuantityService expressCostDeliverQuantityService;

    @Override
    public ExpressCostDetailEo calculationData(ExpressCostDetailEo eo) {
        logger.info("\u5feb\u9012\u8d39\u7528\u6a21\u7248\u8ba1\u7b971\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        ExpressCostDetailEo returnEo = new ExpressCostDetailEo();
        BeanUtils.copyProperties((Object)eo, (Object)returnEo);
        ExpressCostContractEo contractEo = eo.getExpressCostContractEo();
        if (contractEo != null) {
            this.converWeight(returnEo, contractEo);
            this.setWeightRange(returnEo);
            if (StringUtils.isNotBlank((CharSequence)contractEo.getParams())) {
                String params = contractEo.getParams();
                SfDsBkCostChargeModeDto chargeModeDto = (SfDsBkCostChargeModeDto)JSON.parseObject((String)params, SfDsBkCostChargeModeDto.class);
                this.calculationPremium(returnEo, contractEo);
                SfDsBkCostChargeModeInfo chargeModeInfo = this.getChargeModeInfo(eo, chargeModeDto.getChargeModes());
                ExpressCostAreaEo expressCostAreaEo = this.getAppointArea(eo);
                if (expressCostAreaEo != null) {
                    if (ObjectUtils.isEmpty((Object)returnEo.getChargedWeight())) {
                        this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a");
                        return returnEo;
                    }
                    this.calculateFreight(returnEo, expressCostAreaEo, contractEo, chargeModeInfo);
                    this.setCalculationInfo(returnEo, contractEo, expressCostAreaEo);
                } else {
                    String address = eo.getProvince();
                    String city = eo.getCity();
                    String area = eo.getArea();
                    if (StringUtils.isNotBlank((CharSequence)city)) {
                        address = address + city;
                    }
                    if (StringUtils.isNotBlank((CharSequence)area)) {
                        address = address + area;
                    }
                    this.setAbnormalCauses(returnEo, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                }
            } else {
                this.setAbnormalCauses(returnEo, "\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u7a7a");
            }
        } else {
            this.setAbnormalCauses(returnEo, "\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f");
        }
        this.calculationAmount(returnEo);
        super.calculateOcsSystemWeight(returnEo);
        return returnEo;
    }

    private void calculateFreight(ExpressCostDetailEo returnEo, ExpressCostAreaEo expressCostAreaEo, ExpressCostContractEo costContractEo, SfDsBkCostChargeModeInfo chargeModeInfo) {
        logger.info("\u5feb\u9012\u8d39\u7528\u8ba1\u7b97\u903b\u8f91\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{JSON.toJSONString((Object)returnEo), JSON.toJSONString((Object)expressCostAreaEo), JSON.toJSONString((Object)costContractEo), JSON.toJSONString((Object)chargeModeInfo)});
        BigDecimal weight = returnEo.getChargedWeight();
        String params = expressCostAreaEo.getParams();
        SfDsBkExpressAreaDto areaDto = (SfDsBkExpressAreaDto)JSON.parseObject((String)params, SfDsBkExpressAreaDto.class);
        VoteRangeInfoDto voteRangeInfoDto = this.getVoteRangeInfoDto(chargeModeInfo.getSort(), areaDto);
        String peakSeason = costContractEo.getPeakSeason();
        BigDecimal ascentRatio = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((CharSequence)peakSeason) && this.ifPeakSeasonHit(peakSeason, returnEo.getOutboundTime()) && costContractEo.getAscentRatio() != null) {
            ascentRatio = ascentRatio.add(costContractEo.getAscentRatio().divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP));
        }
        if (weight.compareTo(chargeModeInfo.getFirstWeight()) < 0) {
            BigDecimal firstWeightPrice = voteRangeInfoDto.getFirstWeight();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
            if (ascentRatio.compareTo(BigDecimal.ZERO) > 0) {
                returnEo.setFloatAmount(firstWeightPrice.multiply(ascentRatio));
            }
        } else if (weight.compareTo(chargeModeInfo.getLadderTwoMinWeight()) >= 0) {
            BigDecimal firstWeightPrice = voteRangeInfoDto.getFirstWeight();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
            BigDecimal weight1 = chargeModeInfo.getLadderTwoContinuationWeightOne();
            returnEo.setContinuedOne(weight1.multiply(voteRangeInfoDto.getContinuationWeightOne()));
            returnEo.setContinuedOnePer(voteRangeInfoDto.getContinuationWeightOne());
            BigDecimal weight2 = weight.subtract(chargeModeInfo.getLadderOneMaxWeight());
            returnEo.setContinuedTwo(weight2.multiply(voteRangeInfoDto.getContinuationWeightTwo()));
            returnEo.setContinuedTwoPer(voteRangeInfoDto.getContinuationWeightTwo());
            if (ascentRatio.compareTo(BigDecimal.ZERO) > 0) {
                returnEo.setFloatAmount(firstWeightPrice.add(returnEo.getContinuedOne()).add(returnEo.getContinuedTwo()).multiply(ascentRatio));
            }
        } else {
            BigDecimal firstWeightPrice = voteRangeInfoDto.getFirstWeight();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
            BigDecimal weight1 = weight.subtract(chargeModeInfo.getFirstWeight());
            returnEo.setContinuedOne(weight1.multiply(voteRangeInfoDto.getContinuationWeightOne()));
            returnEo.setContinuedOnePer(voteRangeInfoDto.getContinuationWeightOne());
            if (ascentRatio.compareTo(BigDecimal.ZERO) > 0) {
                returnEo.setFloatAmount(firstWeightPrice.add(returnEo.getContinuedOne()).multiply(ascentRatio));
            }
        }
    }

    private VoteRangeInfoDto getVoteRangeInfoDto(Integer sort, SfDsBkExpressAreaDto areaDto) {
        if (sort == 1) {
            return areaDto.getVoteRangeOne();
        }
        if (sort == 2) {
            return areaDto.getVoteRangeTwo();
        }
        if (sort == 3) {
            return areaDto.getVoteRangeThree();
        }
        if (sort == 4) {
            return areaDto.getVoteRangeFour();
        }
        return null;
    }

    private SfDsBkCostChargeModeInfo getChargeModeInfo(ExpressCostDetailEo eo, List<SfDsBkCostChargeModeInfo> chargeModes) {
        logger.info("\u6a21\u72482\u5339\u914d\u8ba1\u7b97\u9636\u68af\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)eo), (Object)JSON.toJSONString(chargeModes));
        ExpressCostDeliverQuantityReqDto reqDto = new ExpressCostDeliverQuantityReqDto();
        reqDto.setBookkeepingMonth(eo.getBookkeepingMonth());
        reqDto.setWarehouseCode(eo.getWarehouseCode());
        reqDto.setTransportType(eo.getTransportType());
        reqDto.setLogisticCode(eo.getLogisticCode());
        logger.info("\u67e5\u8be2\u6708\u53d1\u8d27\u4e86\u7edf\u8ba1\u7968\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List<ExpressCostDeliverQuantityRespDto> queryList = this.expressCostDeliverQuantityService.queryList(reqDto);
        Integer pollNum = eo.getPollNum();
        if (CollectionUtil.isNotEmpty(queryList)) {
            logger.info("\u67e5\u8be2\u6708\u53d1\u8d27\u4e86\u7edf\u8ba1\u7968\u6570\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(queryList));
            pollNum = queryList.get(0).getChargeNum();
        }
        for (SfDsBkCostChargeModeInfo chargeMode : chargeModes) {
            if (chargeMode.getMaxTicket() == null) {
                if (pollNum < chargeMode.getMinTicket()) continue;
                return chargeMode;
            }
            if (pollNum >= chargeMode.getMinTicket() && pollNum < chargeMode.getMaxTicket()) {
                return chargeMode;
            }
            if (chargeMode.getMinTicket() != chargeMode.getMaxTicket() || pollNum <= chargeMode.getMinTicket()) continue;
            return chargeMode;
        }
        return null;
    }
}

