/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.IInventoryDetailReportService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="inventoryDetailReport")
@Scope(value="prototype")
public class InventoryDetailReportJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(InventoryDetailReportJob.class);
    @Resource
    private IInventoryDetailReportService inventoryDetailReportService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            Date date;
            logger.error("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                date = DateUtil.parse((String)taskMsg.getContent(), (String)"yyyy-MM-dd HH:mm:ss");
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                date = calendar.getTime();
            }
            this.inventoryDetailReportService.executeJob(date);
        }
        catch (Exception e) {
            logger.error("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

