/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.ISalesOrderShipmentStatisticsService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="salesOrderShipmentStatisticsTask")
@Scope(value="prototype")
public class SalesOrderShipmentStatisticsTask
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SalesOrderShipmentStatisticsTask.class);
    @Resource
    private ISalesOrderShipmentStatisticsService warehouseIssueStatisticsService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            logger.error("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -7);
            Date startDate = calendar.getTime();
            Date endDate = new Date();
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                Map stringDateMap = (Map)JSON.parseObject((String)taskMsg.getContent(), (TypeReference)new TypeReference<Map<String, Date>>(){}, (Feature[])new Feature[0]);
                if (ObjectUtils.isNotEmpty(stringDateMap.get("startDate"))) {
                    startDate = (Date)stringDateMap.get("startDate");
                }
                if (ObjectUtils.isNotEmpty(stringDateMap.get("endDate"))) {
                    endDate = (Date)stringDateMap.get("endDate");
                }
            }
            logger.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u5f00\u59cb\u65f6\u95f4:{}", (Object)JSON.toJSONString((Object)DateUtil.formatDateTime((Date)startDate)));
            logger.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u7ed3\u675f\u65f6\u95f4:{}", (Object)JSON.toJSONString((Object)DateUtil.formatDateTime((Date)endDate)));
            this.warehouseIssueStatisticsService.syncSalesOrderShipmentStatistics(startDate, endDate);
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7edf\u8ba1\u4efb\u52a1\u7ed3\u675f");
    }
}

