/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.schedule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.InitDataReqDto;
import com.dtyunxi.tcbj.biz.schedule.SyncStorageApportDataScheduled;
import com.dtyunxi.tcbj.biz.schedule.SyncStorageChargeDetailDataScheduled;
import com.dtyunxi.tcbj.biz.service.ILogicInventorySnapService;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="logicInventorySnapTask")
@Scope(value="prototype")
public class LogicInventorySnapTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(LogicInventorySnapTask.class);
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;
    @Resource
    private SyncStorageChargeDetailDataScheduled syncStorageChargeDetailDataScheduled;
    @Resource
    private SyncStorageApportDataScheduled syncStorageApportDataScheduled;
    @Autowired
    private ILogicInventorySnapService logicInventorySnapService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u4ed3\u50a8\u5feb\u7167\u8c03\u5ea6\u542f\u52a8");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            InitDataReqDto initDataReqDto = new InitDataReqDto();
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                initDataReqDto = (InitDataReqDto)JSON.parseObject((String)taskMsg.getContent(), InitDataReqDto.class);
            }
            Date date = initDataReqDto.getDate() != null ? DateUtil.getDayBegin((Date)initDataReqDto.getDate()) : DateUtil.getDayBegin((Date)DateUtil.addDays((Date)new Date(), (int)-1));
            Calendar calendar = Calendar.getInstance();
            initDataReqDto.setDate(date);
            this.logicInventorySnapService.initDataExt(initDataReqDto);
            try {
                String dateFormat = DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                log.info("\u5feb\u7167\u751f\u6210\u5b8c\uff0c\u6267\u884c\u66f4\u65b0\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff1a{}", (Object)dateFormat);
                this.logicInventorySnapService.updateSnapTotalBalanceAndBoardSingle(dateFormat, dateFormat);
            }
            catch (Exception e) {
                log.error("\u5feb\u7167\u751f\u6210\u5b8c\uff0c\u6267\u884c\u66f4\u65b0\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                CompletableFuture.runAsync(() -> {
                    log.info("\u6267\u884c\u751f\u6210\u4ed3\u50a8\u76f8\u5173\u6570\u636e");
                    calendar.setTime(date);
                    calendar.add(5, 1);
                    taskMsg.setContent(DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
                    this.syncStorageChargeDetailDataScheduled.setTaskMsg(taskMsg);
                    this.syncStorageChargeDetailDataScheduled.run();
                });
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u751f\u6210\u4ed3\u50a8\u76f8\u5173\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    public static Date getStartTime(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 0);
        dateStart.set(12, 0);
        dateStart.set(13, 0);
        return dateStart.getTime();
    }

    public static Date getEndTime(Date date) {
        Calendar dateEnd = Calendar.getInstance();
        dateEnd.setTime(date);
        dateEnd.set(11, 23);
        dateEnd.set(12, 59);
        dateEnd.set(13, 59);
        return dateEnd.getTime();
    }
}

