/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.es;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.dtyunxi.tcbj.api.dto.request.OrganizationSplitReportReDto;
import com.dtyunxi.tcbj.api.dto.request.SaleIntransitEarlyWarningQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitAnalysisReportReDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsSaleReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetPlatformOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.tcbj.api.dto.request.es.SaleOrderContrastPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.OrganizationSplitReportContRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrganizationSplitReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleIntransitEarlyWarningCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleIntransitEarlyWarningReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuSplitReportContRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuSplitReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SplitAnalysisReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.AddressVO;
import com.dtyunxi.tcbj.api.dto.response.es.OrderTagRecordVo;
import com.dtyunxi.tcbj.api.dto.response.es.PlatformOrderVO;
import com.dtyunxi.tcbj.api.dto.response.es.SaleOrderItemRespEsVo;
import com.dtyunxi.tcbj.api.dto.response.es.SaleOrderRespEsVo;
import com.dtyunxi.tcbj.api.dto.response.es.SaleRefundRespVo;
import com.dtyunxi.tcbj.api.dto.response.es.SaleReturnOrderCountVO;
import com.dtyunxi.tcbj.biz.service.es.TradeEsService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.dao.das.PlatformOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.SaleRefundEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TradeEsServiceImpl
implements TradeEsService {
    private static Logger logger = LoggerFactory.getLogger(TradeEsServiceImpl.class);
    private static List<String> deliveryStatus = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.WAIT_DELIVERY.getCode(), SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()});
    @Resource
    private PlatformOrderDas platformOrderDas;
    @Resource
    private SaleOrderDas saleOrderDas;

    @Override
    public PageInfo<PlatformOrderVO> queryPlatformOrderListPage(GetPlatformOrderListPageParams pageParams) {
        List<String> strings;
        if (StringUtils.isNotBlank((CharSequence)pageParams.getOrderNo()) && (strings = Arrays.asList(pageParams.getOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setOrderNoList(strings);
            pageParams.setOrderNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getPlatformCreateTimeStart())) {
            pageParams.setPlatformCreateTimeStart(pageParams.getPlatformCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getPlatformCreateTimeEnd())) {
            pageParams.setPlatformCreateTimeEnd(pageParams.getPlatformCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getSaleOrderCreateTimeStart())) {
            pageParams.setSaleOrderCreateTimeStart(pageParams.getSaleOrderCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getSaleOrderCreateTimeEnd())) {
            pageParams.setSaleOrderCreateTimeEnd(pageParams.getSaleOrderCreateTimeEnd() + " 23:59:59");
        }
        logger.info("queryPlatformOrderListPage\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        PageHelper.startPage((int)pageParams.getPageNum(), (int)pageParams.getPageSize());
        PageInfo platformOrderVOPageInfo = null;
        platformOrderVOPageInfo = StringUtils.isNotBlank((CharSequence)pageParams.getType()) && pageParams.getType().equals(BusinessTypeCodeEnum.COMPENSATION_ORDER.getCode()) ? new PageInfo(this.platformOrderDas.queryCompensationOrderListPage(pageParams)) : new PageInfo(this.platformOrderDas.queryPlatformOrderListPage(pageParams));
        if (CollectionUtil.isNotEmpty((Collection)platformOrderVOPageInfo.getList())) {
            platformOrderVOPageInfo.getList().forEach(vo -> {
                AddressVO addressVO = new AddressVO();
                addressVO.setProvince(vo.getProvince());
                addressVO.setCity(vo.getCity());
                addressVO.setDistrict(vo.getDistrict());
                addressVO.setDetailAddress(vo.getDetailAddress());
                vo.setOrderAddress(addressVO);
            });
        }
        return platformOrderVOPageInfo;
    }

    @Override
    public PageInfo<SaleOrderRespEsVo> querySaleOrderListPage(GetSaleOrderListPageEsParams pageEsParams) {
        this.getPageParam(pageEsParams);
        logger.info("querySaleOrderListPage\uff1a{}", (Object)JSON.toJSONString((Object)pageEsParams));
        PageHelper.startPage((int)pageEsParams.getPageNum(), (int)pageEsParams.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.querySaleOrderListPage(pageEsParams));
        if (CollectionUtil.isNotEmpty((Collection)saleOrderRespEsVoPageInfo.getList())) {
            Set orderIds = saleOrderRespEsVoPageInfo.getList().stream().map(SaleOrderRespEsVo::getId).collect(Collectors.toSet());
            Map<Long, List<OrderTagRecordVo>> tagMap = this.saleOrderDas.queryTags(orderIds).stream().collect(Collectors.groupingBy(OrderTagRecordVo::getOrderId));
            saleOrderRespEsVoPageInfo.getList().forEach(vo -> {
                List shippingInfoList;
                if (StringUtils.isNotBlank((CharSequence)vo.getDeliveryWay()) && StringUtils.isNotBlank((CharSequence)vo.getShippingJson()) && CollectionUtil.isNotEmpty((Collection)(shippingInfoList = JSON.parseArray((String)vo.getShippingJson(), CsWmsShippingInfoReqDto.class)))) {
                    vo.setDeliveryWay(((CsWmsShippingInfoReqDto)shippingInfoList.get(0)).getLogisticsType());
                }
                vo.setOrderTags((List)tagMap.get(vo.getId()));
                AddressVO addressVO = new AddressVO();
                addressVO.setProvince(vo.getProvince());
                addressVO.setProvinceCode(vo.getProvinceCode());
                addressVO.setCity(vo.getCity());
                addressVO.setCityCode(vo.getCityCode());
                addressVO.setDistrict(vo.getCounty());
                addressVO.setDistrictCode(vo.getCountyCode());
                addressVO.setDetailAddress(vo.getDetailAddress());
                vo.setOrderAddress(addressVO);
                this.disVolumeAndWeight((SaleOrderRespEsVo)vo);
            });
        }
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public List<SaleOrderRespEsVo> querySaleOrderList(GetSaleOrderListPageEsParams params) {
        this.getPageParam(params);
        logger.info("querySaleOrderList\uff1a{}", (Object)JSON.toJSONString((Object)params));
        List saleOrderList = this.saleOrderDas.querySaleOrderList(params);
        return saleOrderList;
    }

    private void disVolumeAndWeight(SaleOrderRespEsVo vo) {
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getVolumeAndWeight()) && vo.getVolumeAndWeight().split("-").length == 2) {
                String[] split = vo.getVolumeAndWeight().split("-");
                vo.setVolume(new BigDecimal(split[0]));
                vo.setWeight(new BigDecimal(split[1]));
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5355\u636e\u4f53\u79ef\u53ca\u91cd\u91cf\u5f02\u5e38\uff1a{}", (Object)vo.getSaleOrderNo());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void getPageParam(GetSaleOrderListPageEsParams pageEsParams) {
        List<String> strings;
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getSaleOrderCreateTimeStart())) {
            pageEsParams.setSaleOrderCreateTimeStart(pageEsParams.getSaleOrderCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getSaleOrderCreateTimeEnd())) {
            pageEsParams.setSaleOrderCreateTimeEnd(pageEsParams.getSaleOrderCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getDeliveryTimeEnd())) {
            pageEsParams.setDeliveryTimeEnd(pageEsParams.getDeliveryTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getDeliveryTimeStart())) {
            pageEsParams.setDeliveryTimeStart(pageEsParams.getDeliveryTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getUpdateTimeStart())) {
            pageEsParams.setUpdateTimeStart(pageEsParams.getUpdateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getUpdateTimeEnd())) {
            pageEsParams.setUpdateTimeEnd(pageEsParams.getUpdateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getBizDateStart())) {
            pageEsParams.setBizDateStart(pageEsParams.getBizDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageEsParams.getBizDateEnd())) {
            pageEsParams.setBizDateEnd(pageEsParams.getBizDateEnd() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)pageEsParams.getOrderSource())) {
            String[] split = pageEsParams.getOrderSource().split(",");
            List orderSourceList = Arrays.asList(split).stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList());
            pageEsParams.setOrderSource(null);
            pageEsParams.setOrderSourceList(orderSourceList);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageEsParams.getOrderNo()) && (strings = Arrays.asList(pageEsParams.getOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageEsParams.setOrderNoList(strings);
            pageEsParams.setOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageEsParams.getEasOrderNo()) && (strings = Arrays.asList(pageEsParams.getEasOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageEsParams.setEasOrderNoList(strings);
            pageEsParams.setEasOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageEsParams.getSaleOrderStatus()) && (strings = Arrays.asList(pageEsParams.getSaleOrderStatus().replace("\uff0c", ",").split(","))).size() > 1) {
            pageEsParams.setSaleOrderStatusList(strings);
            pageEsParams.setSaleOrderStatus(null);
        }
    }

    @Override
    public PageInfo<SaleRefundRespVo> querySaleRefundOrderListPage(EsSaleReturnOrderListPageParams pageParams) {
        List<String> strings;
        logger.info("\u5185\u90e8\u9500\u552e\u9000\u8ba2\u5355\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        if (StringUtils.isNotBlank((CharSequence)pageParams.getActualReturnTimeStart())) {
            pageParams.setActualReturnTimeStart(pageParams.getActualReturnTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getActualReturnTimeEnd())) {
            pageParams.setActualReturnTimeEnd(pageParams.getActualReturnTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getCreateTimeStart())) {
            pageParams.setCreateTimeStart(pageParams.getCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getCreateTimeEnd())) {
            pageParams.setCreateTimeEnd(pageParams.getCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getBizOrderCreateTimeStart())) {
            pageParams.setBizOrderCreateTimeStart(pageParams.getBizOrderCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getBizOrderCreateTimeEnd())) {
            pageParams.setBizOrderCreateTimeEnd(pageParams.getBizOrderCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getSaleReturnOrderNo()) && (strings = Arrays.asList(pageParams.getSaleReturnOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setSaleReturnOrderNoList(strings);
            pageParams.setSaleReturnOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutBizOrderNo()) && (strings = Arrays.asList(pageParams.getOutBizOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setOutBizOrderNoList(strings);
            pageParams.setOutBizOrderNo(null);
        }
        PageHelper.startPage((int)pageParams.getPageNum(), (int)pageParams.getPageSize());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "2");
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", SaleRefundEo.class.getTypeName());
        return new PageInfo(this.saleOrderDas.querySaleRefundOrderListPage(pageParams));
    }

    @Override
    public SaleReturnOrderCountVO querySaleRefundOrderCount(EsSaleReturnOrderListPageParams pageParams) {
        List<String> strings;
        logger.info("\u5185\u90e8\u9500\u552e\u9000\u8ba2\u5355\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)pageParams));
        if (StringUtils.isNotBlank((CharSequence)pageParams.getActualReturnTimeStart())) {
            pageParams.setActualReturnTimeStart(pageParams.getActualReturnTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getActualReturnTimeEnd())) {
            pageParams.setActualReturnTimeEnd(pageParams.getActualReturnTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getCreateTimeStart())) {
            pageParams.setCreateTimeStart(pageParams.getCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getCreateTimeEnd())) {
            pageParams.setCreateTimeEnd(pageParams.getCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getBizOrderCreateTimeStart())) {
            pageParams.setBizOrderCreateTimeStart(pageParams.getBizOrderCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)pageParams.getBizOrderCreateTimeEnd())) {
            pageParams.setBizOrderCreateTimeEnd(pageParams.getBizOrderCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getSaleReturnOrderNo()) && (strings = Arrays.asList(pageParams.getSaleReturnOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setSaleReturnOrderNoList(strings);
            pageParams.setSaleReturnOrderNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageParams.getOutBizOrderNo()) && (strings = Arrays.asList(pageParams.getOutBizOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            pageParams.setOutBizOrderNoList(strings);
            pageParams.setOutBizOrderNo(null);
        }
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1");
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", SaleRefundEo.class.getTypeName());
        return this.saleOrderDas.querySaleRefundOrderCount(pageParams);
    }

    @Override
    public PageInfo<SaleOrderRespEsVo> querySaleOrderMonitorPage(GetSaleOrderListPageEsParams pageEsParams) {
        this.getPageParam(pageEsParams);
        logger.info("querySaleOrderMonitorPage\uff1a{}", (Object)JSON.toJSONString((Object)pageEsParams));
        PageHelper.startPage((int)pageEsParams.getPageNum(), (int)pageEsParams.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.querySaleOrderMonitorPage(pageEsParams));
        if (CollectionUtil.isNotEmpty((Collection)saleOrderRespEsVoPageInfo.getList())) {
            saleOrderRespEsVoPageInfo.getList().forEach(vo -> {
                boolean b;
                List shippingInfoList;
                if (StringUtils.isNotBlank((CharSequence)vo.getDeliveryWay()) && StringUtils.isNotBlank((CharSequence)vo.getShippingJson()) && CollectionUtil.isNotEmpty((Collection)(shippingInfoList = JSON.parseArray((String)vo.getShippingJson(), CsWmsShippingInfoReqDto.class)))) {
                    vo.setDeliveryWay(((CsWmsShippingInfoReqDto)shippingInfoList.get(0)).getLogisticsType());
                }
                try {
                    if (Objects.nonNull(vo.getOverdueDeliveryTime())) {
                        String HHMM = DateTimeUtils.getDayByMm(vo.getOverdueDeliveryTime());
                        vo.setOverdueDeliveryStr(HHMM);
                    }
                }
                catch (Exception e) {
                    logger.info("\u8f6c\u6362\u65f6\u95f4\u9519\u8bef:{}", (Object)e.getMessage());
                }
                try {
                    if (Objects.nonNull(vo.getOverdueReceivedTime())) {
                        String day = DateTimeUtils.getDayByMm(vo.getOverdueReceivedTime());
                        vo.setOverdueReceivedStr(day);
                    }
                }
                catch (Exception e) {
                    logger.info("\u8f6c\u6362\u5929\u5c0f\u65f6\u5206\u949f\u9519\u8bef:{}", (Object)e.getMessage());
                }
                boolean bl = b = SaleOrderStatusEnum.WAIT_PICK.getCode().equals(vo.getOrderStatus()) && SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode().equals(vo.getSecondOrderStatus());
                if (deliveryStatus.contains(vo.getOrderStatus()) || b) {
                    vo.setPreemptionStockFalg(YesOrNoEnum.YES.getType());
                } else {
                    vo.setPreemptionStockFalg(YesOrNoEnum.NO.getType());
                }
                AddressVO addressVO = new AddressVO();
                addressVO.setProvince(vo.getProvince());
                addressVO.setCity(vo.getCity());
                addressVO.setDistrict(vo.getCounty());
                addressVO.setDetailAddress(vo.getDetailAddress());
                vo.setOrderAddress(addressVO);
            });
        }
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public SaleOrderCountRespDto querySaleOrderMonitorCount(SaleOrderReqDto filter) {
        return this.saleOrderDas.querySaleOrderMonitorCount(filter);
    }

    @Override
    public PageInfo<SaleOrderItemRespEsVo> queryOutSaleOrderDetail(SaleOrderContrastPageEsParams pageEsParams) {
        PageHelper.startPage((int)pageEsParams.getPageNum(), (int)pageEsParams.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.queryOutSaleOrderDetail(pageEsParams));
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public PageInfo<SaleOrderItemRespEsVo> querySaleOrderDetail(SaleOrderContrastPageEsParams pageEsParams) {
        PageHelper.startPage((int)pageEsParams.getPageNum(), (int)pageEsParams.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.querySaleOrderDetail(pageEsParams));
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public PageInfo<OrganizationSplitReportRespDto> queryOrganizationSplit(OrganizationSplitReportReDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.queryOrganizationSplit(dto));
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public OrganizationSplitReportContRespDto queryOrganizationSplitCount(OrganizationSplitReportReDto dto) {
        return this.saleOrderDas.queryOrganizationSplitCount(dto);
    }

    @Override
    public PageInfo<SkuSplitReportRespDto> querySkuSplit(OrganizationSplitReportReDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo saleOrderRespEsVoPageInfo = new PageInfo(this.saleOrderDas.querySkuSplit(dto));
        return saleOrderRespEsVoPageInfo;
    }

    @Override
    public SkuSplitReportContRespDto querySkuSplitCount(OrganizationSplitReportReDto dto) {
        return this.saleOrderDas.querySkuSplitCount(dto);
    }

    @Override
    public List<SplitAnalysisReportRespDto> querySplitAnalysis(SplitAnalysisReportReDto dto) {
        return this.saleOrderDas.querySplitAnalysis(dto);
    }

    @Override
    public OrganizationSplitReportContRespDto querySplitAnalysisCount(SplitAnalysisReportReDto dto) {
        return this.saleOrderDas.querySplitAnalysisCount(dto);
    }

    @Override
    public PageInfo<SaleIntransitEarlyWarningReportRespDto> querySaleIntransitEarlyWarning(SaleIntransitEarlyWarningQueryReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.saleOrderDas.querySaleIntransitEarlyWarning(dto));
        return pageInfo;
    }

    @Override
    public SaleIntransitEarlyWarningCountRespDto querySaleIntransitEarlyWarningCount(SaleIntransitEarlyWarningQueryReqDto dto) {
        return this.saleOrderDas.querySaleIntransitEarlyWarningCount(dto);
    }
}

