/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.CountRelateNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryTimeLimitReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.tcbj.api.dto.response.CountRelateNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryTimeLimitRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderDetailRespVo;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.vo.DatalargescreenDeliveryTimeVo;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.IOutNoticeOrderService;
import com.dtyunxi.tcbj.dao.das.DeliveryNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.OutNoticeOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutNoticeOrderServiceImpl
implements IOutNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(OutNoticeOrderServiceImpl.class);
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private DeliveryNoticeOrderDas deliveryNoticeOrderDas;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;

    @Override
    public Long addOutNoticeOrder(OutNoticeOrderReqDto addReqDto) {
        OutNoticeOrderEo outNoticeOrderEo = new OutNoticeOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)outNoticeOrderEo);
        this.outNoticeOrderDas.insert((BaseEo)outNoticeOrderEo);
        return outNoticeOrderEo.getId();
    }

    @Override
    public void modifyOutNoticeOrder(OutNoticeOrderReqDto modifyReqDto) {
        OutNoticeOrderEo outNoticeOrderEo = new OutNoticeOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)outNoticeOrderEo);
        this.outNoticeOrderDas.updateSelective((BaseEo)outNoticeOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOutNoticeOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.outNoticeOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OutNoticeOrderRespDto queryById(Long id) {
        OutNoticeOrderEo outNoticeOrderEo = (OutNoticeOrderEo)this.outNoticeOrderDas.selectByPrimaryKey(id);
        OutNoticeOrderRespDto outNoticeOrderRespDto = new OutNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)outNoticeOrderEo, (BaseVo)outNoticeOrderRespDto);
        return outNoticeOrderRespDto;
    }

    @Override
    public PageInfo<OutNoticeOrderRespDto> queryByPage(OutNoticeOrderReqDto filter) {
        Page outNoticeOrderRespVos = this.outNoticeOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)outNoticeOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List outNoticeOrderRespVoList = outNoticeOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)outNoticeOrderRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)outNoticeOrderRespVoList, OutNoticeOrderRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public OutNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        OutNoticeOrderEo query = new OutNoticeOrderEo();
        query.setDocumentNo(documentNo);
        OutNoticeOrderEo outNoticeOrderEo = (OutNoticeOrderEo)this.outNoticeOrderDas.selectOne((BaseEo)query);
        OutNoticeOrderRespDto outNoticeOrderRespDto = new OutNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)outNoticeOrderEo, (BaseVo)outNoticeOrderRespDto);
        return outNoticeOrderRespDto;
    }

    @Override
    public List<OutNoticeOrderRespDto> queryByDocumentNos(Set<String> documentNos) {
        if (CollUtil.isEmpty(documentNos)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)this.outNoticeOrderDas.filter().in((Object)"document_no", documentNos)).list();
        if (CollUtil.isEmpty((Collection)eos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, OutNoticeOrderRespDto.class);
        return respDtos;
    }

    @Override
    public PageInfo<OutNoticeOrderDetailRespVo> queryInTransitQualifiedNotice(QueryInTransitQualifiedNoticeReqDto reqDto) {
        return this.outNoticeOrderDas.queryInTransitQualifiedNotice(reqDto);
    }

    @Override
    public CountRelateNoticeOrderRespDto countRelateNoticeOrder(CountRelateNoticeOrderReqDto reqDto) {
        CountRelateNoticeOrderRespDto respDto = new CountRelateNoticeOrderRespDto();
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.saleOrderDas.filter().select(new String[]{"sale_order_no", "order_status", "second_order_status", "physics_warehouse_code", "order_level"}).eq((Object)(Objects.equals(reqDto.getType(), 3) || Objects.equals(reqDto.getType(), 4) ? "platform_order_no" : "platform_parent_order_no"), (Object)reqDto.getMasterOrderNo())).eq(StringUtils.isNotEmpty((CharSequence)reqDto.getPhysicsWarehouseCode()), (Object)"physics_warehouse_code", (Object)reqDto.getPhysicsWarehouseCode())).notIn((Object)"order_status", new Object[]{SaleOrderStatusEnum.OBSOLETE.getCode()})).list();
        Optional.of(list).filter(CollectionUtils::isNotEmpty).ifPresent(orderEos -> {
            if (orderEos.stream().anyMatch(order -> Objects.equals(2, order.getOrderLevel()))) {
                orderEos = orderEos.stream().filter(order -> Objects.equals(2, order.getOrderLevel())).collect(Collectors.toList());
            }
            orderEos = orderEos.stream().filter(order -> Objects.equals(SaleOrderStatusEnum.WAIT_DELIVERY.getCode(), order.getOrderStatus())).collect(Collectors.toList());
            respDto.setOrderCount(Integer.valueOf(orderEos.size()));
            if (reqDto.getType() == 4 || reqDto.getType() == 3) {
                respDto.setDetailMap(orderEos.stream().filter(o -> SaleOrderStatusEnum.WAIT_DELIVERY.getCode().equals(o.getOrderStatus())).collect(Collectors.groupingBy(SaleOrderEo::getPhysicsWarehouseCode, Collectors.counting())));
            }
        });
        respDto.setAllSplit(list.stream().filter(o -> !StringUtils.equals((CharSequence)"SPLIT", (CharSequence)o.getOrderStatus())).allMatch(o -> "WAIT_PICK".equals(o.getOrderStatus()) || StringUtils.isNotBlank((CharSequence)o.getSecondOrderStatus()) && "WAIT_PICK_LOCK_UN_APPOINT".equals(o.getSecondOrderStatus()) || SaleOrderStatusEnum.WAIT_DELIVERY.getCode().equals(o.getOrderStatus()) || SaleOrderStatusEnum.RECEIVED.getCode().equals(o.getOrderStatus()) || SaleOrderStatusEnum.COMPLETE.getCode().equals(o.getOrderStatus())));
        logger.info("\u8fd4\u56de\u7684\u5408\u5355\u8ba2\u5355\u6570\u636e\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto));
        return respDto;
    }

    @Override
    public DatalargescreenDeliveryTimeVo queryDeliveryTimeExt(String warehouseCode) {
        return this.homePageStatisticsAssistService.queryDeliveryTimeLimit(warehouseCode);
    }

    @Override
    public PageInfo<DeliveryTimeLimitRespDto> queryDeliveryTime(DeliveryTimeLimitReqDto deliveryTimeLimitReqDto) {
        PageInfo pageInfo = this.outNoticeOrderDas.queryDeliveryTime(deliveryTimeLimitReqDto);
        logger.info("\u67e5\u8be2\u7ed3\u679c,pageInfo:{}", (Object)JSONObject.toJSONString((Object)pageInfo.getList()));
        return pageInfo;
    }
}

