/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.DateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class NoGreateUtil {
    @Resource
    private ICacheService cacheService;

    private long generate(String key, Date expireTime) {
        boolean exists = this.cacheService.exists(key);
        if (exists) {
            return this.cacheService.incr(key);
        }
        int expireSecond = DateUtil.getDifferMinute((Date)new Date(), (Date)expireTime) * 60;
        return this.cacheService.incr(key, (long)expireSecond);
    }

    public String generateSaleOrderMergeNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = "MER" + NoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        return "MER" + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }
}

