/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxyImpl;
import com.dtyunxi.huieryun.util.EoUtil;
import com.dtyunxi.tcbj.biz.interceptor.CostPlacedFlagInterceptUtils;
import com.dtyunxi.tcbj.biz.interceptor.CostPlacedFlagRealSqlStrategyUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.jdbc.PreparedStatementLogger;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class CostPlacedFlagUpdateInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(CostPlacedFlagUpdateInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        DruidPooledPreparedStatement o;
        String key = CostPlacedFlagInterceptUtils.revIntercept();
        if (StrUtil.isBlank((CharSequence)key)) {
            return invocation.proceed();
        }
        Statement s = (Statement)invocation.getArgs()[0];
        Statement stmt = null;
        Object realTargetObj = CostPlacedFlagUpdateInterceptor.realTarget(s);
        if (realTargetObj instanceof DruidPooledPreparedStatement) {
            o = (DruidPooledPreparedStatement)CostPlacedFlagUpdateInterceptor.realTarget(s);
            stmt = o.getStatement();
        } else {
            o = (PreparedStatementLogger)CostPlacedFlagUpdateInterceptor.realTarget(s);
            stmt = ((DruidPooledPreparedStatement)o.getPreparedStatement()).getStatement();
        }
        PreparedStatement pstmt = null;
        if (stmt instanceof PreparedStatementProxyImpl) {
            pstmt = ((PreparedStatementProxyImpl)stmt).getRawObject();
        }
        String sql = CostPlacedFlagRealSqlStrategyUtil.getSql(pstmt);
        String[] split = key.split("__");
        log.info("\u66f4\u65b0sql:{}", (Object)sql);
        String sqlType = split[1];
        List<Long> ids = CostPlacedFlagInterceptUtils.getChangeIds(sql, sqlType, split[0]);
        if (CollectionUtil.isNotEmpty(ids)) {
            CostPlacedFlagInterceptUtils.checkPlacedFlag(split[0], ids);
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    public static Object realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return CostPlacedFlagUpdateInterceptor.realTarget(metaObject.getValue("h"));
        }
        return target;
    }

    private Object getField(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private Class<?> getaClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        return this.getEoClass(mappedStatement);
    }

    private Class<?> getEoClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        return EoUtil.getEoClass(classType);
    }

    public void setProperties(Properties properties) {
    }
}

