/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.mq;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.biz.service.ILogicInventorySnapService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="SNAP_WMS_BALANCE_UPDATE")
public class InventorySnapWmsBalanceUpdateProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(InventorySnapWmsBalanceUpdateProcess.class);
    @Resource
    private ILogicInventorySnapService logicInventorySnapService;

    public MessageResponse process(String message) {
        try {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            log.info("\u66f4\u65b0\u5e93\u5b58\u5feb\u7167WMS\u671f\u672b\u5e93\u5b58\u6570\u91cf\uff1a{}", (Object)message);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, -1);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String date = df.format(calendar.getTime());
            this.logicInventorySnapService.wmsBalanceUpdate(date, date);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5e93\u5b58\u5feb\u7167WMS\u671f\u672b\u5e93\u5b58\u6570\u91cf\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

