/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.constant.ReInsuranceBillTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticsStatusEnum;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderAddressDas;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDas;
import com.dtyunxi.tcbj.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.tcbj.dao.das.FinInsuranceSettingsDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticsSettingsDas;
import com.dtyunxi.tcbj.dao.das.ReInsuranceBillDas;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.SaleTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.FinInsuranceSettingsEo;
import com.dtyunxi.tcbj.dao.eo.FinLogisticsSettingsEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsuranceBillEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleTransferOrderEo;
import com.dtyunxi.tcbj.dao.mapper.DeliveryResultOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.ReInsurancePremiumMapper;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.tcbj.dao.vo.CostBelongVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceCustomerInfoVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceFeeVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dao.das.IDailyDeliveryReportDas;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailCombineDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsurancePremiumServiceImpl
implements IReInsurancePremiumService {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumServiceImpl.class);
    private static final String INSURANCE_REPORT_LOCK_KEY = "INSURANCE_REPORT_LOCK_KEY";
    private static final String INSURANCE_UPDATE_LOCK_KEY = "INSURANCE_UPDATE_LOCK_KEY";
    private static final String BILL_UPDATE_LOCK_KEY = "BILL_UPDATE_LOCK_KEY";
    @Resource
    private ReInsurancePremiumDas reInsurancePremiumDas;
    @Resource
    private ReInsuranceBillDas reInsuranceBillDas;
    @Resource
    private IReInsuranceBillService billService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ReInsurancePremiumMapper insurancePremiumMapper;
    @Resource
    private FinInsuranceSettingsDas finInsuranceSettingsDas;
    @Resource
    private FinLogisticsSettingsDas finLogisticsSettingsDas;
    @Resource
    private IDailyDeliveryReportDas iDailyDeliveryReportDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private IDailyDeliveryFeeFilterConfigService feeFilterService;
    @Resource
    private IDailyDeliveryFeeFilterExtConfigService dailyDeliveryFeeFilterExtConfigService;
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Resource
    private ConsignmentOrderAddressDas consignmentOrderAddressDas;
    @Resource(name="tradeEsReportQueryApiImpl")
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi icsShipmenetEnterpriseQueryApi;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Autowired
    private SaleOrderMapper saleOrderMapper;
    @Resource
    private FeeAttributionConfigDas feeAttributionConfigDas;
    @Resource
    private SaleTransferOrderDas saleTransferOrderDas;
    @Autowired
    private DeliveryResultOrderMapper deliveryResultOrderMapper;

    @Override
    public Long addReInsurancePremium(ReInsurancePremiumReqDto addReqDto) {
        ReInsurancePremiumEo reInsurancePremiumEo = new ReInsurancePremiumEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsurancePremiumEo);
        this.reInsurancePremiumDas.insert((BaseEo)reInsurancePremiumEo);
        return reInsurancePremiumEo.getId();
    }

    @Override
    public void modifyReInsurancePremium(ReInsurancePremiumReqDto modifyReqDto) {
        ReInsurancePremiumEo reInsurancePremiumEo = new ReInsurancePremiumEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsurancePremiumEo);
        this.reInsurancePremiumDas.updateSelective((BaseEo)reInsurancePremiumEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReInsurancePremium(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.reInsurancePremiumDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ReInsurancePremiumRespDto queryById(Long id) {
        ReInsurancePremiumEo reInsurancePremiumEo = (ReInsurancePremiumEo)this.reInsurancePremiumDas.selectByPrimaryKey(id);
        ReInsurancePremiumRespDto reInsurancePremiumRespDto = new ReInsurancePremiumRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsurancePremiumEo, (BaseVo)reInsurancePremiumRespDto);
        return reInsurancePremiumRespDto;
    }

    @Override
    public PageInfo<ReInsurancePremiumRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List eos;
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)filter);
        ReInsurancePremiumReqDto reInsurancePremiumReqDto = (ReInsurancePremiumReqDto)JSON.parseObject((String)filter, ReInsurancePremiumReqDto.class);
        this.setDate(reInsurancePremiumReqDto);
        reInsurancePremiumReqDto.setPageNum(pageNum);
        reInsurancePremiumReqDto.setPageSize(pageSize);
        PageInfo dtoPageInfo = this.reInsurancePremiumDas.queryByPage(reInsurancePremiumReqDto);
        List relevanceNos = dtoPageInfo.getList().stream().map(ReInsurancePremiumRespDto::getRelevanceNo).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        List dtoList = dtoPageInfo.getList().stream().map(eo -> {
            eo.setBillType(ReInsuranceBillTypeEnum.getNameByCode((String)eo.getBillType()));
            eo.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)eo.getFlag()));
            eo.setShippingTypeName(eo.getShippingType());
            if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                eo.setBusinessTypeName(eo.getBusinessType());
                if (StringUtils.isNotBlank((CharSequence)ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()))) {
                    eo.setBusinessTypeName(ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo()) && map.containsKey(eo.getRelevanceNo())) {
                eo.setExternalOrderNo((String)map.get(eo.getRelevanceNo()));
                Object[] externalOrderArray = eo.getExternalOrderNo().split(",");
                eo.setExternalOrderNo((String)Lists.newArrayList((Object[])externalOrderArray).stream().sorted().findFirst().get());
            }
            return eo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryFlagCount(ReInsurancePremiumReqDto reqDto) {
        return this.reInsurancePremiumDas.queryFlagCount(reqDto);
    }

    private void setDate(ReInsurancePremiumReqDto reInsurancePremiumReqDto) {
        try {
            if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
                String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
                reInsurancePremiumReqDto.setInOutTimeBegin(simpleDateFormat.parse(begin));
                reInsurancePremiumReqDto.setInOutTimeEnd(simpleDateFormat.parse(end));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String generateInsuranceReportNew(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210generateInsuranceReportNew\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto == null || reqDto.getInOutTimeBegin() == null || reqDto.getInOutTimeEnd() == null) {
            return "\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a";
        }
        int lockTtlSeconds = 1800;
        int totalProcessed = 0;
        int skippedDays = 0;
        SimpleDateFormat dayKeyFormat = new SimpleDateFormat("yyyyMMdd");
        Calendar cursor = Calendar.getInstance();
        cursor.setTime(reqDto.getInOutTimeBegin());
        cursor.set(11, 0);
        cursor.set(12, 0);
        cursor.set(13, 0);
        cursor.set(14, 0);
        Calendar endCursor = Calendar.getInstance();
        endCursor.setTime(reqDto.getInOutTimeEnd());
        endCursor.set(11, 0);
        endCursor.set(12, 0);
        endCursor.set(13, 0);
        endCursor.set(14, 0);
        while (!cursor.after(endCursor)) {
            Date dayStart = cursor.getTime();
            Calendar dayEndCal = (Calendar)cursor.clone();
            dayEndCal.set(11, 23);
            dayEndCal.set(12, 59);
            dayEndCal.set(13, 59);
            dayEndCal.set(14, 999);
            Date dayEnd = dayEndCal.getTime();
            if (dayEnd.after(reqDto.getInOutTimeEnd())) {
                dayEnd = reqDto.getInOutTimeEnd();
            }
            String dayKey = dayKeyFormat.format(dayStart);
            String dayLockKey = "INSURANCE_REPORT_LOCK_KEY:" + dayKey;
            ReInsurancePremiumReqDto dayReqDto = new ReInsurancePremiumReqDto();
            BeanUtil.copyProperties((Object)reqDto, (Object)dayReqDto, (String[])new String[0]);
            dayReqDto.setInOutTimeBegin(dayStart);
            dayReqDto.setInOutTimeEnd(dayEnd);
            int processedForDay = this.generateInsuranceReportNewForSingleDay(dayReqDto, dayLockKey, lockTtlSeconds, dayKey);
            if (processedForDay < 0) {
                ++skippedDays;
            } else {
                totalProcessed += processedForDay;
            }
            cursor.add(5, 1);
        }
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210\u5b8c\u6210\uff0c\u5171\u5904\u7406{}\u6761\u6570\u636e\uff0c\u8df3\u8fc7{}\u5929", (Object)totalProcessed, (Object)skippedDays);
        return "00000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateInsuranceReportNewForSingleDay(ReInsurancePremiumReqDto reqDto, String lockKey, int lockTtlSeconds, String dayKey) {
        boolean lockFlag = this.cacheService.setIfAbsent(lockKey, (Object)1, lockTtlSeconds);
        if (!lockFlag) {
            this.logger.info("\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u6570\u636e\u751f\u6210\u670d\u52a1\u8fdb\u884c\u4e2d\uff0c\u8df3\u8fc7\u65e5\u671f\uff1a{}", (Object)dayKey);
            return -1;
        }
        int totalProcessed = 0;
        try {
            Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
            HashMap insureMaps = new HashMap(64);
            HashMap<String, InsuranceCustomerInfoVo> physicsWareMap = new HashMap<String, InsuranceCustomerInfoVo>(32);
            HashMap<String, String> startPlaceMap = new HashMap<String, String>(16);
            HashMap<String, String> dateFormatCache = new HashMap<String, String>(32);
            List<DailyDeliveryFeeFilterExtConfigRespDto> filter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u4fdd\u8d39\u5254\u9664\u8d39\u7528\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString(filter));
            }
            CsShipmenetEnterpriseQueryDto enterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
            enterpriseQueryDto.setPageNum(Integer.valueOf(1));
            enterpriseQueryDto.setPageSize(Integer.valueOf(1000));
            PageInfo enterpriseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.icsShipmenetEnterpriseQueryApi.queryByPage(enterpriseQueryDto));
            Map shipmenetEnterpriseRespDtoMap = Optional.ofNullable(enterpriseRespDtoPageInfo.getList()).map(m -> enterpriseRespDtoPageInfo.getList().stream().collect(Collectors.toMap(o -> o.getShipmentEnterpriseCode() + "-" + o.getCustomerCode(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            int pageSize = 5000;
            DailyDeliveryReportDto reportQueryDto = new DailyDeliveryReportDto();
            reportQueryDto.setPageNum(Integer.valueOf(1));
            reportQueryDto.setPageSize(Integer.valueOf(pageSize));
            reportQueryDto.setOrderShippingTimeStart(reqDto.getInOutTimeBegin());
            reportQueryDto.setOrderShippingTimeEnd(reqDto.getInOutTimeEnd());
            reportQueryDto.setOrderShippingTimeStartStr(DateUtil.getDateFormat((Date)reqDto.getInOutTimeBegin(), (String)"yyyy-MM-dd HH:mm:ss"));
            reportQueryDto.setOrderShippingTimeEndStr(DateUtil.getDateFormat((Date)reqDto.getInOutTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reportQueryDto));
            }
            PageInfo reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
            while (ObjectUtils.isNotEmpty((Object)reportDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)reportDtoPageInfo.getList())) {
                List longCodes;
                ArrayList<ReInsuranceBillEo> billEoList = new ArrayList<ReInsuranceBillEo>();
                int originalSize = reportDtoPageInfo.getList().size();
                List<Object> filteredDailyList = this.filterAllotSaleForSaleTransfer(reportDtoPageInfo.getList());
                if (this.logger.isInfoEnabled() && originalSize != filteredDailyList.size()) {
                    this.logger.info("\u9500\u552e\u8c03\u62e8\u8fc7\u6ee4\u540e\u5206\u9875\u5355\u636e\u6570\u53d8\u5316\uff1a{} -> {}", (Object)originalSize, (Object)filteredDailyList.size());
                }
                if (CollectionUtils.isEmpty(filteredDailyList)) {
                    reportQueryDto.setPageNum(Integer.valueOf(reportQueryDto.getPageNum() + 1));
                    reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
                    continue;
                }
                List dailyReportIds = filteredDailyList.stream().map(DailyDeliveryReportDto::getId).collect(Collectors.toList());
                List existingBillIds = this.reInsurancePremiumDas.getExistingBillDailyReportIds(dailyReportIds);
                if (CollectionUtils.isNotEmpty((Collection)existingBillIds)) {
                    HashSet existingIdSet = new HashSet(existingBillIds);
                    int beforeFilterSize = filteredDailyList.size();
                    filteredDailyList = filteredDailyList.stream().filter(d -> !existingIdSet.contains(d.getId())).collect(Collectors.toList());
                    if (this.logger.isInfoEnabled() && beforeFilterSize != filteredDailyList.size()) {
                        this.logger.info("\u5df2\u751f\u6210\u8d26\u5355\u8fc7\u6ee4\u751f\u6548\uff1a{} -> {}", (Object)beforeFilterSize, (Object)filteredDailyList.size());
                    }
                }
                if (CollectionUtils.isEmpty(filteredDailyList)) {
                    reportQueryDto.setPageNum(Integer.valueOf(reportQueryDto.getPageNum() + 1));
                    reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
                    continue;
                }
                List ids = filteredDailyList.stream().map(DailyDeliveryReportDto::getId).collect(Collectors.toList());
                List dailyDeliveryReportDetailList = this.reInsurancePremiumDas.getDailyDeliveryReportDetail(ids);
                Map dailyDeliveryReportDetailMap = Optional.ofNullable(dailyDeliveryReportDetailList).map(m -> m.stream().collect(Collectors.groupingBy(DailyDeliveryReportDetailCombineDto::getDailyDeliveryReportId))).orElse(new HashMap());
                Map insuranceItemVoMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDetailList) && CollectionUtils.isNotEmpty(longCodes = dailyDeliveryReportDetailList.stream().map(DailyDeliveryReportDetailCombineDto::getLongCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList()))) {
                    List list = this.reInsurancePremiumDas.getPcpItemByLongCode(longCodes);
                    insuranceItemVoMap = Optional.ofNullable(list).map(m -> m.stream().collect(Collectors.toMap(InsuranceItemVo::getLongCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
                }
                for (DailyDeliveryReportDto dailyDeliveryReportDto : filteredDailyList) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("generateInsuranceReport\u5904\u7406\u5355\u636e\uff1a{}", (Object)dailyDeliveryReportDto.getId());
                    }
                    ReInsuranceBillEo insuranceBillEo = new ReInsuranceBillEo();
                    CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)dailyDeliveryReportDto, (String[])new String[0]);
                    insuranceBillEo.setLinkDailyReportId(dailyDeliveryReportDto.getId());
                    insuranceBillEo.setExternalOrderNo(dailyDeliveryReportDto.getEasOrderNo());
                    insuranceBillEo.setWmsConsignmentNo(dailyDeliveryReportDto.getConsignmentNo());
                    insuranceBillEo.setWmsMergeDocumentNo(dailyDeliveryReportDto.getJoinMergeDocumentNo());
                    insuranceBillEo.setCustomerName(dailyDeliveryReportDto.getReceivingCustomer());
                    insuranceBillEo.setCustomerAddress(dailyDeliveryReportDto.getReceivingAddress());
                    insuranceBillEo.setInOutTime(dailyDeliveryReportDto.getOrderShippingTime());
                    insuranceBillEo.setDocumentNo(dailyDeliveryReportDto.getOutResultNo());
                    insuranceBillEo.setShippingCompany(dailyDeliveryReportDto.getShippingCompanyName());
                    insuranceBillEo.setShippingCompanyCode(dailyDeliveryReportDto.getShippingCompany());
                    insuranceBillEo.setShippingType(dailyDeliveryReportDto.getTransportStyle());
                    insuranceBillEo.setStartPlace(dailyDeliveryReportDto.getStartCity());
                    insuranceBillEo.setEndPlace(dailyDeliveryReportDto.getReceivingAddressCity());
                    insuranceBillEo.setEndPlaceCode(dailyDeliveryReportDto.getReceivingAddressCityCode());
                    insuranceBillEo.setEndProvince(dailyDeliveryReportDto.getReceivingAddressProvince());
                    insuranceBillEo.setEndProvinceCode(dailyDeliveryReportDto.getReceivingAddressProvinceCode());
                    insuranceBillEo.setOutLogicWarehouseCode(dailyDeliveryReportDto.getLogicWarehouseCode());
                    insuranceBillEo.setOutLogicWarehouseName(dailyDeliveryReportDto.getLogicWarehouse());
                    insuranceBillEo.setInLogicWarehouseCode(dailyDeliveryReportDto.getInLogicWarehouseCode());
                    insuranceBillEo.setInLogicWarehouseName(dailyDeliveryReportDto.getInLogicWarehouse());
                    insuranceBillEo.setBillOrgName(StringUtils.isNotBlank((CharSequence)dailyDeliveryReportDto.getBillOrgName()) ? dailyDeliveryReportDto.getBillOrgName() : dailyDeliveryReportDto.getInventoryOrganizationName());
                    insuranceBillEo.setBillOrgCode(StringUtils.isNotBlank((CharSequence)dailyDeliveryReportDto.getBillOrgCode()) ? dailyDeliveryReportDto.getBillOrgCode() : dailyDeliveryReportDto.getInventoryOrganizationCode());
                    insuranceBillEo.setLinkDailyReportId(dailyDeliveryReportDto.getId());
                    insuranceBillEo.setMuchFlagDailyReportId(Objects.equals(1, dailyDeliveryReportDto.getMuchDeliveryFlag()) ? dailyDeliveryReportDto.getId() : null);
                    insuranceBillEo.setOrderRemark(dailyDeliveryReportDto.getRemark());
                    insuranceBillEo.setPlacedFlag(Integer.valueOf(0));
                    insuranceBillEo.setTransportNo(dailyDeliveryReportDto.getTransportNo());
                    insuranceBillEo.setReceivingPerson(dailyDeliveryReportDto.getReceivingPerson());
                    insuranceBillEo.setCostBelongOrgId(insuranceBillEo.getOutOrganizationId());
                    insuranceBillEo.setCostBelongOrgName(insuranceBillEo.getOutOrganizationName());
                    insuranceBillEo.setId(null);
                    ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
                    List dailydetailEo = (List)dailyDeliveryReportDetailMap.get(dailyDeliveryReportDto.getId());
                    if (CollectionUtil.isEmpty((Collection)dailydetailEo)) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("\u65e0\u660e\u7ec6\u4fe1\u606f\uff0c\u4e0d\u751f\u6210\u8ba1\u8d39\uff0c\u62a5\u8868ID\uff1a{}", (Object)dailyDeliveryReportDto.getId());
                        continue;
                    }
                    StringBuilder billReason = new StringBuilder();
                    BigDecimal quantity = BigDecimal.ZERO;
                    BigDecimal insureTotalPrice = BigDecimal.ZERO;
                    try {
                        int billQuotaVerify;
                        String orderShippingTime;
                        if (null == insuranceBillEo.getRemark() && null == insuranceBillEo.getCustomerName() && null == insuranceBillEo.getCustomerAddress() && null == insuranceBillEo.getStartPlace() && null == insuranceBillEo.getEndPlace() && null == insuranceBillEo.getExternalOrderNo()) {
                            this.getCommonOtherData(insuranceBillEo, physicsWareMap, startPlaceMap);
                        }
                        if (StringUtils.isNotBlank((CharSequence)dailyDeliveryReportDto.getEasOrderNo())) {
                            insuranceBillEo.setExternalOrderNo(dailyDeliveryReportDto.getEasOrderNo());
                        }
                        if (null != dailyDeliveryReportDto.getLogicWarehouse()) {
                            insuranceBillEo.setOutLogicWarehouseName(dailyDeliveryReportDto.getLogicWarehouse());
                        }
                        if (null != dailyDeliveryReportDto.getInLogicWarehouse()) {
                            insuranceBillEo.setInLogicWarehouseName(dailyDeliveryReportDto.getInLogicWarehouse());
                        }
                        if (null != dailyDeliveryReportDto.getInventoryOrganizationName()) {
                            insuranceBillEo.setOutOrganizationName(dailyDeliveryReportDto.getInventoryOrganizationName());
                        }
                        if (null != dailyDeliveryReportDto.getConsignmentNo()) {
                            insuranceBillEo.setWmsConsignmentNo(dailyDeliveryReportDto.getConsignmentNo());
                        }
                        if (null != dailyDeliveryReportDto.getOutNoticeNo()) {
                            insuranceBillEo.setOutDocumentNo(dailyDeliveryReportDto.getOutNoticeNo());
                        }
                        if (null != dailyDeliveryReportDto.getPhysicalWarehouseCode()) {
                            insuranceBillEo.setOutPhysicsWarehouseCode(dailyDeliveryReportDto.getPhysicalWarehouseCode());
                        }
                        if (null != dailyDeliveryReportDto.getPhysicalWarehouse()) {
                            insuranceBillEo.setOutPhysicsWarehouseName(dailyDeliveryReportDto.getPhysicalWarehouse());
                        }
                        if (null != dailyDeliveryReportDto.getOutInventoryOrg()) {
                            insuranceBillEo.setOutOrganizationName(dailyDeliveryReportDto.getOutInventoryOrg());
                        }
                        if (null != dailyDeliveryReportDto.getInInventoryOrg()) {
                            insuranceBillEo.setInOrganizationName(dailyDeliveryReportDto.getInInventoryOrg());
                        }
                        InsuranceFeeVo insuranceFeeVo = null;
                        if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getShippingCompany()) && "\u4e2d\u901a".equals(insuranceBillEo.getShippingCompany())) {
                            insuranceBillEo.setShippingCompany("\u4e2d\u901a\u5feb\u9012");
                        }
                        if (dailyDeliveryReportDto.getOrderShippingTime() != null) {
                            String dateKey = String.valueOf(dailyDeliveryReportDto.getOrderShippingTime().getTime());
                            orderShippingTime = dateFormatCache.computeIfAbsent(dateKey, k -> DateUtil.getDateFormat((Date)dailyDto.getOrderShippingTime(), (String)"yyyy-MM-dd"));
                        } else {
                            orderShippingTime = null;
                        }
                        List insureFeeList = null;
                        if (orderShippingTime != null) {
                            insureFeeList = this.reInsurancePremiumDas.getInsureFee(orderShippingTime, insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany());
                        }
                        if (insureFeeList == null || CollectionUtils.isEmpty(insureFeeList)) {
                            billReason.append("[\u7269\u6d41\u516c\u53f8:").append(insuranceBillEo.getShippingCompany()).append(",\u627f\u8fd0\u65b9\u5f0f:").append(insuranceBillEo.getShippingType()).append("\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else if (insureFeeList.size() > 1) {
                            billReason.append("[\u7269\u6d41\u516c\u53f8:").append(insuranceBillEo.getShippingCompany()).append(",\u627f\u8fd0\u65b9\u5f0f:").append(insuranceBillEo.getShippingType()).append("\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else {
                            insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
                            insuranceBillEo.setUseInsuranceRate(insuranceFeeVo.getInsuranceRate());
                        }
                        insuranceBillEo.setBillingFeeFlag(Integer.valueOf(1));
                        if (null == dailydetailEo || dailydetailEo.isEmpty()) {
                            String str = "\u65e0\u4fdd\u8d39\u660e\u7ec6\u6570\u636e";
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("\u65e0\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\uff0c\u62a5\u8868ID\uff1a{}", (Object)dailyDeliveryReportDto.getId());
                            }
                            insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                            insuranceBillEo.setNoBillingReason(str);
                            quantity = null;
                            insureTotalPrice = null;
                        } else {
                            String billReasonStr = billReason.toString();
                            for (DailyDeliveryReportDetailCombineDto productDto : dailydetailEo) {
                                CsShipmenetEnterpriseRespDto shipmenetEnterpriseRespDto;
                                StringBuilder builder = new StringBuilder();
                                if (StringUtils.isNotBlank((CharSequence)billReasonStr)) {
                                    builder.append(billReasonStr);
                                }
                                ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                                CubeBeanUtils.copyProperties((Object)premiumEo, (Object)insuranceBillEo, (String[])new String[]{"id", "reason", "create_time", "create_person", "update_person", "update_time"});
                                premiumEo.setPlacedFlag(Integer.valueOf(0));
                                premiumEo.setBillingFeeFlag(Integer.valueOf(1));
                                premiumEo.setLinkDailyReportId(productDto.getId());
                                premiumEo.setExternalOrderNo(dailyDeliveryReportDto.getEasOrderNo());
                                premiumEo.setLongCode(productDto.getLongCode());
                                premiumEo.setCargoName(productDto.getProductName());
                                premiumEo.setQuantity(productDto.getQuantity());
                                premiumEo.setCreateTime(null);
                                premiumEo.setUpdateTime(null);
                                premiumEo.setBatch(productDto.getBatch());
                                if (null != dailyDeliveryReportDto.getConsignmentNo()) {
                                    premiumEo.setWmsConsignmentNo(dailyDeliveryReportDto.getConsignmentNo());
                                }
                                if (null != dailyDeliveryReportDto.getOutNoticeNo()) {
                                    premiumEo.setOutDocumentNo(dailyDeliveryReportDto.getOutNoticeNo());
                                }
                                if (null != dailyDeliveryReportDto.getPhysicalWarehouseCode()) {
                                    premiumEo.setOutPhysicsWarehouseCode(dailyDeliveryReportDto.getPhysicalWarehouseCode());
                                }
                                if (null != dailyDeliveryReportDto.getPhysicalWarehouse()) {
                                    premiumEo.setOutPhysicsWarehouseName(dailyDeliveryReportDto.getPhysicalWarehouse());
                                }
                                if (null != productDto.getReceivingCustomer() && null != productDto.getShipmentEnterpriseCode() && ObjectUtils.isNotEmpty((Object)(shipmenetEnterpriseRespDto = (CsShipmenetEnterpriseRespDto)shipmenetEnterpriseRespDtoMap.get(productDto.getShipmentEnterpriseCode() + "-" + productDto.getReceivingCustomer())))) {
                                    premiumEo.setBillingFeeFlag(Integer.valueOf(0));
                                    premiumEo.setNoBillingReason("\u5ba2\u6237\u548c\u627f\u8fd0\u5546\u6709\u5339\u914d\u5173\u7cfb");
                                    insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                                    insuranceBillEo.setNoBillingReason("\u5ba2\u6237\u548c\u627f\u8fd0\u5546\u6709\u5339\u914d\u5173\u7cfb");
                                }
                                DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
                                configReqDto.setFilterPhysicalWarehouse(premiumEo.getOutPhysicsWarehouseCode());
                                configReqDto.setFilterLogicWarehouse(premiumEo.getOutLogicWarehouseCode());
                                configReqDto.setFilterBusinessType(premiumEo.getBusinessType());
                                configReqDto.setLogisticsCompany(premiumEo.getShippingCompany());
                                configReqDto.setFilterInventoryOrg(premiumEo.getOutOrganizationName());
                                configReqDto.setTransportStyle(premiumEo.getShippingType());
                                boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(filter, configReqDto);
                                if (filterApplicable) {
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("\u547d\u4e2d\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\uff0c\u660e\u7ec6ID\uff1a{}", (Object)productDto.getId());
                                    }
                                    premiumEo.setBillingFeeFlag(Integer.valueOf(0));
                                    premiumEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                                    insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                                    insuranceBillEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                                }
                                if (premiumEo.getBillingFeeFlag() == 0) {
                                    if (builder.length() > 0) {
                                        premiumEo.setReason(builder.toString().replace("null", "\u4e3a\u7a7a"));
                                        premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                                    } else {
                                        premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                                    }
                                    premiumEoList.add(premiumEo);
                                    continue;
                                }
                                if (null == premiumEo.getQuantity()) {
                                    premiumEo.setQuantity(BigDecimal.ZERO);
                                }
                                quantity = quantity.add(premiumEo.getQuantity());
                                InsuranceItemVo itemEo = (InsuranceItemVo)insuranceItemVoMap.get(premiumEo.getLongCode());
                                String longCode = premiumEo.getLongCode();
                                if (ObjectUtils.isEmpty((Object)itemEo)) {
                                    builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a ").append(longCode).append(" \u7684\u5546\u54c1]");
                                } else {
                                    if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a ").append(longCode).append(" \u7684\u5546\u54c1\u7c7b\u578b\uff0c\u4e3a\u7a7a]");
                                    } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a ").append(longCode).append(" \u7684\u5546\u54c1\u7c7b\u578b\u3010").append(itemEo.getItemType()).append("\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                                    } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                        premiumEo.setItemType(SubTypeEnum.PRODUCT.getType());
                                    } else {
                                        premiumEo.setItemType(itemEo.getItemType());
                                    }
                                    if (null != productDto.getRecommendPrice()) {
                                        premiumEo.setRecommendPrice(productDto.getRecommendPrice());
                                    }
                                    if (null != productDto.getInternalTransaction()) {
                                        premiumEo.setClaimPrice(productDto.getInternalTransaction());
                                        if (premiumEo.getClaimPrice().compareTo(BigDecimal.ZERO) == 0) {
                                            builder.append("[\u5546\u54c1\u957f\u7f16\u7801= ").append(longCode).append(" \u7684\u5185\u90e8\u91c7\u8d2d\u4ef7\u4e3a0]");
                                        }
                                    } else {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801= ").append(longCode).append(" \u7684\u5185\u90e8\u91c7\u8d2d\u4ef7\u4e3a\u7a7a]");
                                    }
                                }
                                if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                                    InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                                    premiumEo.setLogisticsSetttingsId(feeVo.getId());
                                    if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                                        builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                                    } else {
                                        if (longCode != null && longCode.startsWith("A.A")) {
                                            premiumEo.setUseDiscount(feeVo.getProductDiscount());
                                        } else {
                                            premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                                        }
                                        premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                    }
                                }
                                if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                                    premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                                    premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
                                }
                                if (null == premiumEo.getUseDiscount() || null == premiumEo.getInsureUnitPrice()) {
                                    builder.append("[\u6295\u4fdd\u4ef7\u6216\u6298\u6263\u4e3a\u7a7a]");
                                }
                                insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                                if (builder.length() > 0) {
                                    premiumEo.setReason(builder.toString().replace("null", "\u4e3a\u7a7a"));
                                    premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                                } else {
                                    premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                                }
                                premiumEoList.add(premiumEo);
                            }
                        }
                        insuranceBillEo.setQuantity(quantity);
                        insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
                        if (Objects.equals(insuranceBillEo.getBillingFeeFlag(), 0)) {
                            insuranceBillEo.setInsureFee(BigDecimal.ZERO);
                            continue;
                        }
                        int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
                        if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                            insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                            if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                                if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                                    insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                                    continue;
                                }
                                insuranceBillEo.setInsureFee(new BigDecimal("0"));
                                continue;
                            }
                            billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                            continue;
                        }
                        billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                    }
                    catch (Exception e) {
                        billReason.append(e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        if (billReason.length() > 0) {
                            insuranceBillEo.setReason(billReason.toString().replace("null", "\u4e3a\u7a7a"));
                            insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                        } else {
                            insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                        }
                        insuranceBillEo.setCreateTime(null);
                        insuranceBillEo.setUpdateTime(null);
                        insuranceBillEo.setPremiumEoList(premiumEoList);
                        billEoList.add(insuranceBillEo);
                    }
                }
                if (CollectionUtils.isNotEmpty(billEoList)) {
                    this.billService.addInsurePremiumAndBill(billEoList);
                    totalProcessed += billEoList.size();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u5df2\u5904\u7406{}\u6761\u8d26\u5355\u6570\u636e", (Object)totalProcessed);
                    }
                }
                reportQueryDto.setPageNum(Integer.valueOf(reportQueryDto.getPageNum() + 1));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\uff0c\u9875\u7801\uff1a{}", (Object)reportQueryDto.getPageNum());
                }
                reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
            }
            int n = totalProcessed;
            return n;
        }
        finally {
            this.cacheService.delCache(lockKey);
            this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210\u7ed3\u675f\uff0c\u65e5\u671f\uff1a{}\uff0c\u5171\u5904\u7406{}\u6761\u6570\u636e", (Object)dayKey, (Object)totalProcessed);
        }
    }

    private List<DailyDeliveryReportDto> filterAllotSaleForSaleTransfer(List<DailyDeliveryReportDto> dailyList) {
        if (CollectionUtils.isEmpty(dailyList)) {
            return dailyList;
        }
        Set relevanceNos = dailyList.stream().map(DailyDeliveryReportDto::getRelevanceNo).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(relevanceNos)) {
            return dailyList;
        }
        List matchedSaleTransfers = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.saleTransferOrderDas.filter().eq((Object)"dispose_status", (Object)2)).eq((Object)"dr", (Object)0)).and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.in((Object)"transfer_order_no", (Collection)relevanceNos)).or()).in((Object)"sale_order_no", (Collection)relevanceNos);
        })).list();
        if (CollectionUtils.isEmpty((Collection)matchedSaleTransfers)) {
            return dailyList;
        }
        this.logger.info("\u547d\u4e2d\u9500\u552e\u8c03\u62e8\u5173\u7cfb\u6761\u6570\uff1a{}", (Object)matchedSaleTransfers.size());
        Set matchedTransferOrderNos = matchedSaleTransfers.stream().map(SaleTransferOrderEo::getTransferOrderNo).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set matchedSaleOrderNos = matchedSaleTransfers.stream().map(SaleTransferOrderEo::getSaleOrderNo).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(matchedTransferOrderNos) || CollectionUtils.isEmpty(matchedSaleOrderNos)) {
            return dailyList;
        }
        Map<String, List<DailyDeliveryReportDto>> consignmentGroup = dailyList.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getConsignmentNo())).collect(Collectors.groupingBy(DailyDeliveryReportDto::getConsignmentNo));
        HashSet keepIds = new HashSet();
        HashMap consignmentKeepRelevanceMap = new HashMap();
        for (Map.Entry<String, List<DailyDeliveryReportDto>> entry : consignmentGroup.entrySet()) {
            List<DailyDeliveryReportDto> group = entry.getValue();
            boolean hasMatchedSaleOrder = group.stream().anyMatch(d -> StringUtils.isNotBlank((CharSequence)d.getRelevanceNo()) && matchedSaleOrderNos.contains(d.getRelevanceNo()));
            if (!hasMatchedSaleOrder) continue;
            Optional<DailyDeliveryReportDto> allotSaleTransfer = group.stream().filter(d -> "allot_sale".equals(d.getBusinessType()) && StringUtils.isNotBlank((CharSequence)d.getRelevanceNo()) && matchedTransferOrderNos.contains(d.getRelevanceNo())).findFirst();
            allotSaleTransfer.ifPresent(dto -> {
                keepIds.add(dto.getId());
                if (StringUtils.isNotBlank((CharSequence)dto.getConsignmentNo())) {
                    consignmentKeepRelevanceMap.put(dto.getConsignmentNo(), dto.getRelevanceNo());
                }
            });
        }
        if (CollectionUtils.isEmpty(keepIds)) {
            return dailyList;
        }
        ArrayList<DailyDeliveryReportDto> result = new ArrayList<DailyDeliveryReportDto>(dailyList.size());
        for (DailyDeliveryReportDto dto2 : dailyList) {
            if (keepIds.contains(dto2.getId())) {
                result.add(dto2);
                continue;
            }
            String consignmentNo = dto2.getConsignmentNo();
            if (StringUtils.isBlank((CharSequence)consignmentNo)) {
                result.add(dto2);
                continue;
            }
            List<DailyDeliveryReportDto> group = consignmentGroup.get(consignmentNo);
            if (CollectionUtils.isEmpty(group)) {
                result.add(dto2);
                continue;
            }
            boolean groupHasMatchedSaleOrder = group.stream().anyMatch(d -> StringUtils.isNotBlank((CharSequence)d.getRelevanceNo()) && matchedSaleOrderNos.contains(d.getRelevanceNo()));
            if (groupHasMatchedSaleOrder) continue;
            result.add(dto2);
        }
        if (result.size() != dailyList.size()) {
            this.logger.info("\u9500\u552e\u8c03\u62e8\u8fc7\u6ee4\u751f\u6548\uff1a\u539f\u59cb{}\u6761\uff0c\u8fc7\u6ee4\u540e{}\u6761", (Object)dailyList.size(), (Object)result.size());
        }
        if (ObjectUtils.isNotEmpty(consignmentKeepRelevanceMap)) {
            List sample = consignmentKeepRelevanceMap.entrySet().stream().limit(10L).collect(Collectors.toList());
            this.logger.info("\u9500\u552e\u8c03\u62e8\u8fc7\u6ee4\u4fdd\u7559\u6620\u5c04\u6570\u91cf\uff1a{}\uff0c\u6837\u672c\uff1a{}", (Object)consignmentKeepRelevanceMap.size(), (Object)JSON.toJSONString(sample));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateInsuranceReport(Date generateDate) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210\uff1a{}", (Object)generateDate);
        Boolean lockFlag = this.cacheService.setCache(INSURANCE_REPORT_LOCK_KEY, (Object)1, 120);
        if (!lockFlag.booleanValue()) {
            return "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u6570\u636e\u751f\u6210\u670d\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85\u751f\u6210\u5b8c\u540e\u518d\u6267\u884c";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String calDate = dateFormat.format(generateDate);
        this.logger.info("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u65e5\u671f:{}:\u7684\u4fdd\u8d39\u6570\u636e", (Object)calDate);
        String calDateBegin = calDate + " 00:00:00";
        String calDateEnd = calDate + " 23:59:59";
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u66f4\u65b0\u5f02\u5e38\u4fe1\u606f\uff0c\u66f4\u65b0\u65f6\u95f4\uff1a{}\uff0c{}", (Object)calDateBegin, (Object)calDateEnd);
        Long outResultNoCount = this.reInsurancePremiumDas.getOutResultNoCountByDate(calDateBegin, calDateEnd);
        if (outResultNoCount == 0L) {
            String info = "\u4fdd\u8d39\u62a5\u8868\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u83b7\u53d6\u5230\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\u6761\u6570\u4e3a0,\u751f\u6210\u4fdd\u8d39\u62a5\u8868\u7ed3\u679c\u6570\u4e3a0\uff0c\u7ed3\u675f\u751f\u6210";
            this.logger.info(info);
            return info;
        }
        HashMap itemMaps = new HashMap();
        HashMap warehouseMaps = new HashMap();
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        HashMap costBelongMaps = new HashMap();
        HashMap insureMaps = new HashMap();
        HashMap<String, InsuranceCustomerInfoVo> physicsWareMap = new HashMap<String, InsuranceCustomerInfoVo>();
        HashMap<String, String> startPlaceMap = new HashMap<String, String>(8);
        Integer pageNum = 0;
        Integer pageSize = 1000;
        List outResultOrderEoList = this.reInsurancePremiumDas.getOutResultNoListByDate(calDateBegin, calDateEnd, pageNum, pageSize);
        while (CollectionUtils.isNotEmpty((Collection)outResultOrderEoList)) {
            for (OutResultOrderEo orderEo : outResultOrderEoList) {
                this.logger.info("generateInsuranceReport\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orderEo));
                ReInsuranceBillEo insuranceBillEo = new ReInsuranceBillEo();
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)orderEo, (String[])new String[0]);
                ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
                List detailEoList = this.reInsurancePremiumDas.getOutResultOrderDetail(orderEo.getDocumentNo());
                StringBuilder billReason = new StringBuilder();
                BigDecimal quantity = BigDecimal.ZERO;
                BigDecimal insureTotalPrice = BigDecimal.ZERO;
                try {
                    int billQuotaVerify;
                    Object str;
                    CostBelongVo belongVo;
                    LogicWarehouseEo logicWarehouseEo;
                    SaleOrderEo saleOrderEo;
                    this.getCommonOtherData(insuranceBillEo, physicsWareMap, startPlaceMap);
                    if (StringUtils.contains((CharSequence)insuranceBillEo.getRelevanceNo(), (CharSequence)"DD") && null != (saleOrderEo = (SaleOrderEo)this.saleOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SaleOrderEo.class).eq(SaleOrderEo::getSaleOrderNo, (Object)insuranceBillEo.getRelevanceNo())))) {
                        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                            insuranceBillEo.setExternalOrderNo(saleOrderEo.getEasOrderNo());
                        } else {
                            insuranceBillEo.setExternalOrderNo(saleOrderEo.getEasOutOrderNo());
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)insuranceBillEo.getExternalOrderNo())) {
                        insuranceBillEo.setExternalOrderNo(insuranceBillEo.getRelevanceNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getOutLogicWarehouseCode())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(insuranceBillEo.getOutLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            insuranceBillEo.setOutOrganizationId(logicWarehouseEo.getOrganizationId());
                            insuranceBillEo.setOutOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + insuranceBillEo.getOutLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getInLogicWarehouseCode())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(insuranceBillEo.getInLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            insuranceBillEo.setInOrganizationId(logicWarehouseEo.getOrganizationId());
                            insuranceBillEo.setInOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u5165\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + insuranceBillEo.getInLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (ObjectUtils.isEmpty((Object)(belongVo = this.reInsurancePremiumDas.getCostBelong(insuranceBillEo.getOutLogicWarehouseCode(), insuranceBillEo.getInLogicWarehouseCode(), costBelongMaps)))) {
                        if (!StringUtils.isBlank((CharSequence)insuranceBillEo.getOutOrganizationName())) {
                            insuranceBillEo.setCostBelongOrgId(insuranceBillEo.getOutOrganizationId());
                            insuranceBillEo.setCostBelongOrgName(insuranceBillEo.getOutOrganizationName());
                        }
                    } else {
                        insuranceBillEo.setCostBelongOrgId(belongVo.getCostBelongOrgId());
                        insuranceBillEo.setCostBelongOrgName(belongVo.getCostBelongOrgName());
                    }
                    InsuranceFeeVo insuranceFeeVo = null;
                    List insureFeeList = this.reInsurancePremiumDas.getInsureFee(calDateBegin, insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany());
                    if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                        str = "[\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append((String)str);
                    } else if (insureFeeList.size() > 1) {
                        String str2 = "[\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append(str2);
                    } else {
                        insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
                        insuranceBillEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
                        this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
                    }
                    if (CollectionUtils.isEmpty((Collection)detailEoList)) {
                        str = "[\u751f\u6210\u4fdd\u8d39\u9519\u8bef,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7:{" + orderEo.getDocumentNo() + "}:\u65e0\u660e\u7ec6\u6570\u636e]";
                        this.logger.warn((String)str);
                        billReason.append((String)str);
                        quantity = null;
                        insureTotalPrice = null;
                    }
                    for (OutResultOrderDetailEo orderDetailEo : detailEoList) {
                        StringBuilder builder = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)billReason.toString())) {
                            builder.append((CharSequence)billReason);
                        }
                        ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                        CubeBeanUtils.copyProperties((Object)premiumEo, (Object)insuranceBillEo, (String[])new String[]{"reason"});
                        premiumEo.setLongCode(orderDetailEo.getSkuCode());
                        premiumEo.setCargoName(orderDetailEo.getSkuName());
                        premiumEo.setQuantity(orderDetailEo.getQuantity());
                        quantity = quantity.add(premiumEo.getQuantity());
                        InsuranceItemVo itemEo = this.reInsurancePremiumDas.getPcpItemByLongCode(premiumEo.getLongCode(), itemMaps);
                        if (ObjectUtils.isEmpty((Object)itemEo)) {
                            builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1]");
                        } else {
                            if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\uff0c\u4e3a\u7a7a]");
                            } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u3010" + itemEo.getItemType() + "\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                            } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                premiumEo.setItemType(SubTypeEnum.PRODUCT.getType());
                            } else {
                                premiumEo.setItemType(itemEo.getItemType());
                            }
                            if (!ObjectUtils.isEmpty((Object)itemEo.getClaimPrice())) {
                                premiumEo.setClaimPrice(itemEo.getClaimPrice());
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                            InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                            premiumEo.setLogisticsSetttingsId(feeVo.getId());
                            if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                                builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                            } else {
                                if (premiumEo.getLongCode().startsWith("A.A")) {
                                    premiumEo.setUseDiscount(feeVo.getProductDiscount());
                                } else {
                                    premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                                }
                                premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                            }
                        }
                        if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                            premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                            premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
                        }
                        insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                        premiumEo.setCreateTime(new Date());
                        premiumEo.setUpdateTime(new Date());
                        if (builder.length() > 0) {
                            premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                            premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                        } else {
                            premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                        }
                        premiumEoList.add(premiumEo);
                    }
                    insuranceBillEo.setQuantity(quantity);
                    insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
                    int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                        if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                            if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                                insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                                continue;
                            }
                            insuranceBillEo.setInsureFee(new BigDecimal("0"));
                            continue;
                        }
                        billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                        continue;
                    }
                    billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                }
                catch (Exception e) {
                    billReason.append(e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    if (billReason.length() > 0) {
                        insuranceBillEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
                        insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    } else {
                        insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                    }
                    this.billService.addInsurePremiumAndBill(insuranceBillEo, premiumEoList);
                }
            }
            if (outResultOrderEoList.size() < pageSize) {
                outResultOrderEoList = null;
                continue;
            }
            outResultOrderEoList.clear();
            outResultOrderEoList = this.reInsurancePremiumDas.getOutResultNoListByDate(calDateBegin, calDateEnd, pageNum, pageSize);
        }
        this.cacheService.delCache(INSURANCE_REPORT_LOCK_KEY);
        this.logger.info("\u7ed3\u675f\u751f\u6210\u51fa\u5e93\u65e5\u671f:{}:\u7684\u4fdd\u8d39\u6570\u636e", (Object)calDate);
        return "00000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateInsuranceExceptionReport(ReInsurancePremiumExceptionDto exceptionDto) {
        Integer errCount;
        this.logger.info("\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u5f02\u5e38\u6570\u636e\uff1a{},{},{},{},{}", new Object[]{exceptionDto.getBeginDate(), exceptionDto.getEndDate(), exceptionDto.getShippingCompanyCode(), exceptionDto.getShippingType(), exceptionDto.getInsuranceCompany()});
        Boolean lockFlag = this.cacheService.setCache(INSURANCE_UPDATE_LOCK_KEY, (Object)1, 300);
        if (!lockFlag.booleanValue()) {
            throw new BizException("INSU0001", "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u5f02\u5e38\u6570\u636e\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String calDateBegin = null;
        String calDateEnd = null;
        if (exceptionDto.getBeginDate() != null) {
            String beginDate = dateFormat.format(exceptionDto.getBeginDate());
            calDateBegin = beginDate.substring(0, 10) + " 00:00:00";
        }
        if (exceptionDto.getEndDate() != null) {
            String endDate = dateFormat.format(exceptionDto.getEndDate());
            calDateEnd = endDate.substring(0, 10) + " 23:59:59";
        }
        if ((errCount = this.reInsurancePremiumDas.getInsuranceCountByDate(calDateBegin, calDateEnd, exceptionDto)) == 0) {
            this.logger.info("\u4fdd\u8d39\u62a5\u8868\u66f4\u65b0\u65e5\u671f\u8d77:{},\u66f4\u65b0\u65e5\u671f\u6b62:{},\u5f02\u5e38\u6570\u636e\u6570\u4e3a0", (Object)calDateBegin, calDateEnd);
            return "\u4fdd\u8d39\u62a5\u8868\u4e8e\u8be5\u67e5\u8be2\u6761\u4ef6\u5185\u65e0\u5f02\u5e38\u6570\u636e\uff0c\u66f4\u65b0\u7ed3\u675f\u3002";
        }
        Integer errPremiumCount = 0;
        Integer billUpNum = 0;
        Integer billUpSuccNum = 0;
        Integer billUpErrNum = 0;
        Integer premiumUpSuccNum = 0;
        Integer premiumUpErrNum = 0;
        HashMap itemMaps = new HashMap();
        HashMap warehouseMaps = new HashMap();
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        HashMap costBelongMaps = new HashMap();
        HashMap insureMaps = new HashMap();
        Integer pageNum = 0;
        Integer pageSize = 1000;
        List billEoList = this.reInsurancePremiumDas.getInsuranceBillListByDate(exceptionDto, calDateBegin, calDateEnd, pageNum, pageSize);
        while (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            billUpNum = billUpNum + billEoList.size();
            for (ReInsuranceBillEo billEo : billEoList) {
                ReInsuranceBillEo billUpEo = new ReInsuranceBillEo();
                billUpEo.setId(billEo.getId());
                billUpEo.setUseInsuranceRate(billEo.getUseInsuranceRate());
                billUpEo.setCostBelongOrgId(billEo.getCostBelongOrgId());
                billUpEo.setCostBelongOrgName(billEo.getCostBelongOrgName());
                billUpEo.setOutOrganizationId(billEo.getOutOrganizationId());
                billUpEo.setOutOrganizationName(billEo.getOutOrganizationName());
                billUpEo.setInOrganizationId(billEo.getInOrganizationId());
                billUpEo.setInOrganizationName(billEo.getInOrganizationName());
                billUpEo.setUseAmountConfig(billEo.getUseAmountConfig());
                List outResultDetailList = this.reInsurancePremiumDas.getOutResultOrderDetailNotInPremium(billEo.getDocumentNo());
                ArrayList<ReInsurancePremiumEo> notInPremiumEos = new ArrayList<ReInsurancePremiumEo>();
                BigDecimal notAddQuantity = billEo.getQuantity() == null ? new BigDecimal(0) : billEo.getQuantity();
                for (OutResultOrderDetailEo notGenerateDetailEo : outResultDetailList) {
                    ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                    CubeBeanUtils.copyProperties((Object)premiumEo, (Object)billEo, (boolean)false, (String[])new String[]{"id", "insureUnitPrice", "insureTotalPrice", "useInsuranceRate"});
                    premiumEo.setLongCode(notGenerateDetailEo.getSkuCode());
                    premiumEo.setCargoName(notGenerateDetailEo.getSkuName());
                    premiumEo.setQuantity(notGenerateDetailEo.getQuantity());
                    premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    notInPremiumEos.add(premiumEo);
                    notAddQuantity = notAddQuantity.add(notGenerateDetailEo.getQuantity());
                }
                if (CollectionUtils.isNotEmpty(notInPremiumEos)) {
                    this.reInsurancePremiumDas.insertBatch(notInPremiumEos);
                    billUpEo.setQuantity(notAddQuantity);
                }
                ArrayList<ReInsurancePremiumEo> premiumUpEoList = new ArrayList<ReInsurancePremiumEo>();
                List detailEoList = this.reInsurancePremiumDas.getReInsurancePremiumEo(billEo.getDocumentNo());
                StringBuilder billReason = new StringBuilder();
                BigDecimal insureTotalPrice = new BigDecimal("0");
                if (CollectionUtils.isEmpty((Collection)detailEoList)) {
                    String str = "\u66f4\u65b0\u4fdd\u8d39\u9519\u8bef,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7:{" + billEo.getDocumentNo() + "}:\u65e0\u660e\u7ec6\u6570\u636e";
                    this.logger.warn(str);
                    billReason.append(str);
                    insureTotalPrice = null;
                }
                try {
                    LogicWarehouseEo logicWarehouseEo;
                    if (StringUtils.isNotBlank((CharSequence)billEo.getOutLogicWarehouseCode()) && ObjectUtils.isEmpty((Object)billEo.getOutOrganizationName())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(billEo.getOutLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            billUpEo.setOutOrganizationId(logicWarehouseEo.getOrganizationId());
                            billUpEo.setOutOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + billEo.getOutLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)billEo.getInLogicWarehouseCode()) && ObjectUtils.isEmpty((Object)billEo.getInOrganizationName())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(billEo.getInLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            billUpEo.setInOrganizationId(logicWarehouseEo.getOrganizationId());
                            billUpEo.setInOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u5165\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + billEo.getInLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (ObjectUtils.isEmpty((Object)billEo.getCostBelongOrgId())) {
                        CostBelongVo belongVo = this.reInsurancePremiumDas.getCostBelong(billEo.getOutLogicWarehouseCode(), billEo.getInLogicWarehouseCode(), costBelongMaps);
                        if (ObjectUtils.isEmpty((Object)belongVo)) {
                            if (!ObjectUtils.isEmpty((Object)billUpEo.getOutOrganizationName())) {
                                billUpEo.setCostBelongOrgId(billUpEo.getOutOrganizationId());
                                billUpEo.setCostBelongOrgName(billUpEo.getOutOrganizationName());
                            }
                        } else {
                            billUpEo.setCostBelongOrgId(belongVo.getCostBelongOrgId());
                            billUpEo.setCostBelongOrgName(belongVo.getCostBelongOrgName());
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
                        if (StringUtils.isBlank((CharSequence)billEo.getShippingCompany())) {
                            billEo.setShippingCompany(((ReInsurancePremiumEo)detailEoList.get(0)).getShippingCompany());
                        }
                        if (StringUtils.isBlank((CharSequence)billEo.getShippingCompanyCode())) {
                            billEo.setShippingCompanyCode(((ReInsurancePremiumEo)detailEoList.get(0)).getShippingCompanyCode());
                        }
                    }
                    List insureFeeList = this.reInsurancePremiumDas.getInsureFee(dateFormat.format(billEo.getInOutTime()), billEo.getShippingCompanyCode(), billEo.getShippingType(), insureMaps, billEo.getShippingCompany());
                    if (ObjectUtils.isEmpty((Object)billEo.getUseInsuranceRate())) {
                        String str = "[\u51fa\u5e93\u65e5\u671f:" + dateFormat.format(billEo.getInOutTime()) + ",\u7269\u6d41\u516c\u53f8:" + billEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + billEo.getShippingType();
                        if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                            billReason.append(str + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else if (insureFeeList.size() > 1) {
                            billReason.append(str + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else {
                            billUpEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
                        }
                    }
                    for (ReInsurancePremiumEo orderDetailEo : detailEoList) {
                        Integer n;
                        if (InsuranceFlagEnum.CORRECT.getCode().equals(orderDetailEo.getFlag())) {
                            if (!ObjectUtils.isNotEmpty((Object)insureTotalPrice)) continue;
                            insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(orderDetailEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                            continue;
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append(billReason.toString());
                        Integer n2 = errPremiumCount;
                        Integer n3 = errPremiumCount = Integer.valueOf(errPremiumCount + 1);
                        ReInsurancePremiumEo premiumUpEo = new ReInsurancePremiumEo();
                        premiumUpEo.setId(orderDetailEo.getId());
                        premiumUpEo.setItemType(orderDetailEo.getItemType());
                        premiumUpEo.setClaimPrice(orderDetailEo.getClaimPrice());
                        premiumUpEo.setUseDiscount(orderDetailEo.getUseDiscount());
                        premiumUpEo.setQuantity(orderDetailEo.getQuantity());
                        premiumUpEo.setInsureUnitPrice(orderDetailEo.getInsureUnitPrice());
                        premiumUpEo.setInsureTotalPrice(orderDetailEo.getInsureTotalPrice());
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getOutOrganizationId())) {
                            premiumUpEo.setOutOrganizationId(billUpEo.getOutOrganizationId());
                            premiumUpEo.setOutOrganizationName(billUpEo.getOutOrganizationName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getInOrganizationId())) {
                            premiumUpEo.setInOrganizationId(billUpEo.getInOrganizationId());
                            premiumUpEo.setInOrganizationName(billUpEo.getInOrganizationName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getCostBelongOrgId())) {
                            premiumUpEo.setCostBelongOrgId(billUpEo.getCostBelongOrgId());
                            premiumUpEo.setCostBelongOrgName(billUpEo.getCostBelongOrgName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getClaimPrice()) || orderDetailEo.getClaimPrice().compareTo(BigDecimal.ZERO) == 0 || ObjectUtils.isEmpty((Object)orderDetailEo.getItemType())) {
                            InsuranceItemVo itemEo = this.reInsurancePremiumDas.getPcpItemByLongCode(orderDetailEo.getLongCode(), itemMaps);
                            if (ObjectUtils.isEmpty((Object)itemEo)) {
                                builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1]");
                            } else {
                                if (ObjectUtils.isEmpty((Object)orderDetailEo.getItemType())) {
                                    if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a]");
                                    } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u3010" + itemEo.getItemType() + "\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                                    } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                        premiumUpEo.setItemType(Integer.valueOf(SubTypeEnum.PRODUCT.getType()));
                                    } else {
                                        premiumUpEo.setItemType(Integer.valueOf(itemEo.getItemType()));
                                    }
                                }
                                if (!ObjectUtils.isEmpty((Object)itemEo.getClaimPrice())) {
                                    premiumUpEo.setClaimPrice(itemEo.getClaimPrice());
                                }
                            }
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getUseDiscount())) {
                            if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                                builder.append("[\u627e\u4e0d\u5230\u5bf9\u5e94\u6709\u6548\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\uff0c\u6298\u6263\u4e0e\u8d39\u7387\u5747\u4e0d\u77e5]");
                            } else {
                                InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                                premiumUpEo.setLogisticsSetttingsId(feeVo.getId());
                                if (ObjectUtils.isNotEmpty((Object)premiumUpEo.getItemType())) {
                                    if (premiumUpEo.getLongCode().startsWith("A.A")) {
                                        premiumUpEo.setUseDiscount(feeVo.getProductDiscount());
                                    } else {
                                        premiumUpEo.setUseDiscount(feeVo.getMaterialDiscount());
                                    }
                                    premiumUpEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                    billUpEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                }
                            }
                        }
                        if (ObjectUtils.isNotEmpty((Object)premiumUpEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumUpEo.getUseDiscount())) {
                            premiumUpEo.setInsureUnitPrice(premiumUpEo.getClaimPrice().multiply(premiumUpEo.getUseDiscount()));
                            premiumUpEo.setInsureTotalPrice(Optional.ofNullable(premiumUpEo.getInsureUnitPrice()).orElse(BigDecimal.ZERO).multiply(premiumUpEo.getQuantity()));
                        }
                        insureTotalPrice = Optional.ofNullable(insureTotalPrice).orElse(BigDecimal.ZERO).add(Optional.ofNullable(premiumUpEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                        premiumUpEo.setUpdateTime(new Date());
                        if (builder.length() > 0) {
                            premiumUpEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                            premiumUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            n3 = premiumUpErrNum;
                            n = premiumUpErrNum = Integer.valueOf(premiumUpErrNum + 1);
                        } else {
                            premiumUpEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                            premiumUpEo.setReason("");
                            n3 = premiumUpSuccNum;
                            n = premiumUpSuccNum = Integer.valueOf(premiumUpSuccNum + 1);
                        }
                        premiumUpEoList.add(premiumUpEo);
                    }
                    billUpEo.setInsureTotalPrice(insureTotalPrice);
                    if (ObjectUtils.isEmpty((Object)billEo.getUseAmountConfig())) {
                        if (ObjectUtils.isEmpty((Object)useAmountConfig)) {
                            billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                        } else {
                            billUpEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                        }
                    }
                    if (ObjectUtils.isNotEmpty((Object)billUpEo.getInsureTotalPrice()) && ObjectUtils.isNotEmpty((Object)billUpEo.getUseInsuranceRate())) {
                        billUpEo.setInsureFee(billUpEo.getInsureTotalPrice().multiply(billUpEo.getUseInsuranceRate()));
                        if (ObjectUtils.isNotEmpty((Object)billUpEo.getUseAmountConfig()) && billUpEo.getInsureTotalPrice().compareTo(billUpEo.getUseAmountConfig()) < 0) {
                            billUpEo.setInsureFee(new BigDecimal("0"));
                        }
                    } else {
                        billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                    }
                    billUpEo.setUpdateTime(new Date());
                }
                catch (Exception e) {
                    billReason.append(e.getMessage());
                    for (ReInsurancePremiumEo eo : premiumUpEoList) {
                        eo.setReason(eo.getReason() + "[" + e.getMessage() + "]");
                        eo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    }
                    e.printStackTrace();
                }
                finally {
                    Object object;
                    Integer n;
                    if (billReason.length() > 0) {
                        billUpEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
                        billUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                        n = billUpErrNum;
                        billUpErrNum = billUpErrNum + 1;
                        object = billUpErrNum;
                    } else {
                        billUpEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                        billUpEo.setReason("");
                        n = billUpSuccNum;
                        billUpSuccNum = billUpSuccNum + 1;
                        object = billUpSuccNum;
                    }
                    this.billService.updateInsurePremiumAndBill(billUpEo, premiumUpEoList);
                }
            }
            pageNum = pageNum + pageSize;
            if (billEoList.size() < pageSize) {
                billEoList = null;
                continue;
            }
            billEoList.clear();
            billEoList = this.reInsurancePremiumDas.getInsuranceBillListByDate(exceptionDto, calDateBegin, calDateEnd, pageNum, pageSize);
        }
        this.cacheService.delCache(INSURANCE_UPDATE_LOCK_KEY);
        String msg = "\u6267\u884c\u66f4\u65b0\u5f02\u5e38\u6570\u636e\u5b8c\u6210:\u5f53\u524d\u5df2\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u5f02\u5e38\u6570\u636e" + errPremiumCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + premiumUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + premiumUpErrNum + "\u6761\uff1b\u5bf9\u5e94\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0" + billUpNum + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + billUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + billUpErrNum + "\u6761\u3002";
        this.logger.info(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> updateInsuranceByLogistics(ReInsurancePremiumReportUpdateReqDto dto) {
        String msg;
        String updateEnd;
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u66f4\u65b0\uff1a{}", (Object)dto);
        Boolean lockFlag = this.cacheService.setCache(BILL_UPDATE_LOCK_KEY, (Object)1, 120);
        if (!lockFlag.booleanValue()) {
            throw new BizException("INSU0003", "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u8d26\u5355\u6570\u636e\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u66f4\u65b0");
        }
        SimpleDateFormat updateFormat = new SimpleDateFormat("yyyy-MM");
        String updateBegin = dto.getUpdateTime() + "-01 00:00:00";
        Long i = this.reInsurancePremiumDas.clearByDate(updateBegin, updateEnd = dto.getUpdateTime() + "-30 23:59:59");
        if (i > 0L) {
            this.logger.info("\u65e5\u671f:{}\u5b58\u5728\u5df2\u5f52\u6863\u6570\u636e", (Object)dto.getUpdateTime());
            return new RestResponse("100000", "\u76f8\u5173\u6570\u636e\u5df2\u5f52\u6863,\u65e0\u6cd5\u751f\u6210");
        }
        Integer billCount = 0;
        Integer premiumCount = 0;
        Integer billUpSuccNum = 0;
        Integer billUpErrNum = 0;
        Integer premiumUpSuccNum = 0;
        Integer premiumUpErrNum = 0;
        DailyDeliveryReportListQueryDto listQueryDto = new DailyDeliveryReportListQueryDto();
        try {
            listQueryDto.setOrderShippingTimeStart(updateFormat.parse(updateBegin));
            listQueryDto.setOrderShippingTimeEnd(updateFormat.parse(updateEnd));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List eoList = this.iDailyDeliveryReportDas.pageQuery(listQueryDto);
        for (DailyDeliveryReportEo reportEo : eoList) {
            FinInsuranceSettingsEo insuranceEo;
            Date time;
            String transportCode;
            String shipCode = reportEo.getShipmentEnterpriseCode();
            FinLogisticsSettingsEo logisticsEo = this.finLogisticsSettingsDas.getBySomeType(shipCode, transportCode = reportEo.getTransportStyleCode(), time = reportEo.getOrderShippingTime());
            if (ObjectUtils.isEmpty((Object)logisticsEo) || LogisticsStatusEnum.INVALID.getStatus().equals(logisticsEo.getStatus()) || ObjectUtils.isEmpty((Object)(insuranceEo = (FinInsuranceSettingsEo)this.finInsuranceSettingsDas.selectByPrimaryKey(logisticsEo.getInsuranceId())))) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateBegin = dateFormat.format(logisticsEo.getEfffectiveTimeBegin()) + " 00:00:00";
            String dateEnd = dateFormat.format(logisticsEo.getEfffectiveTimeEnd()) + " 23:59:59";
            ReInsuranceBillEo searchBillEo = new ReInsuranceBillEo();
            CsShipmenetEnterpriseRespDto enterpriseRespDto = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.icsShipmenetEnterpriseQueryApi.queryByPrimaryKey(Long.valueOf(logisticsEo.getShipmentEnterpriseCode())));
            if (enterpriseRespDto == null || StringUtils.isBlank((CharSequence)enterpriseRespDto.getShipmentEnterpriseCode())) continue;
            searchBillEo.setShippingCompanyCode(enterpriseRespDto.getShipmentEnterpriseCode());
            String shippingTypeName = CsShipmentLogisticsTypeEnum.formType((Integer)Integer.valueOf(logisticsEo.getLogisticsType()));
            searchBillEo.setShippingType(shippingTypeName);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.ge((String)"in_out_time", (Object)dateBegin));
            sqlFilters.add(SqlFilter.le((String)"in_out_time", (Object)dateEnd));
            searchBillEo.setOrderBy("in_out_time");
            searchBillEo.setSqlFilters(sqlFilters);
            Integer billNum = this.reInsuranceBillDas.count((BaseEo)searchBillEo);
            if (billNum == 0) {
                throw new BizException("RIP006", "\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0\u5b8c\u6210\uff0c\u66f4\u65b0\u6570\u636e0\u6761");
            }
            searchBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
            Integer errBillNum = this.reInsuranceBillDas.count((BaseEo)searchBillEo);
            if (errBillNum > 0) {
                throw new BizException("RIP003", "\u4fdd\u8d39\u8d26\u5355\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u5728\u3010\u4fdd\u8d39\u660e\u7ec6\u3011\u9875\u9762-\u5904\u7406\u66f4\u65b0\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u7684\u5f02\u5e38\u6570\u636e\u540e\u91cd\u8bd5");
            }
            Integer pageNum = 0;
            Integer pageSize = 1000;
            searchBillEo.setFlag(null);
            Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
            List billEoList = this.reInsuranceBillDas.selectList((BaseEo)searchBillEo, pageNum, pageSize);
            while (CollectionUtils.isNotEmpty((Collection)billEoList)) {
                for (ReInsuranceBillEo billEo : billEoList) {
                    Integer n = billCount;
                    Integer n2 = billCount = Integer.valueOf(billCount + 1);
                    if (billEo.getPlacedFlag() == 1) continue;
                    ReInsuranceBillEo billUpEo = new ReInsuranceBillEo();
                    billUpEo.setId(billEo.getId());
                    billUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        billUpEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                    } else {
                        billUpEo.setUseAmountConfig(billEo.getUseAmountConfig());
                    }
                    BigDecimal insureTotalPrice = new BigDecimal("0");
                    ArrayList<ReInsurancePremiumEo> premiumUpEoList = new ArrayList<ReInsurancePremiumEo>();
                    List detailEoList = this.reInsurancePremiumDas.getReInsurancePremiumEo(billEo.getDocumentNo());
                    try {
                        for (ReInsurancePremiumEo orderDetailEo : detailEoList) {
                            Integer n3 = premiumCount;
                            Integer n4 = premiumCount = Integer.valueOf(premiumCount + 1);
                            ReInsurancePremiumEo premiumUpEo = new ReInsurancePremiumEo();
                            premiumUpEo.setId(orderDetailEo.getId());
                            if (SubTypeEnum.PRODUCT.getType().equals(orderDetailEo.getItemType())) {
                                premiumUpEo.setUseDiscount(logisticsEo.getProductDiscount());
                            } else if (SubTypeEnum.MATERIEL.getType().equals(orderDetailEo.getItemType())) {
                                premiumUpEo.setUseDiscount(logisticsEo.getMaterialDiscount());
                            }
                            premiumUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                            billUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                            premiumUpEo.setInsureUnitPrice(Optional.ofNullable(orderDetailEo.getClaimPrice()).orElse(BigDecimal.ZERO).multiply(Optional.ofNullable(premiumUpEo.getUseDiscount()).orElse(BigDecimal.ZERO)));
                            premiumUpEo.setInsureTotalPrice(Optional.ofNullable(premiumUpEo.getInsureUnitPrice()).orElse(BigDecimal.ZERO).multiply(orderDetailEo.getQuantity()));
                            insureTotalPrice = insureTotalPrice.add(premiumUpEo.getInsureTotalPrice());
                            premiumUpEo.setUpdateTime(new Date());
                            premiumUpEoList.add(premiumUpEo);
                        }
                        billUpEo.setInsureTotalPrice(insureTotalPrice);
                        if (insureTotalPrice.compareTo(billUpEo.getUseAmountConfig()) >= 0) {
                            billUpEo.setInsureFee(billUpEo.getInsureTotalPrice().multiply(billUpEo.getUseInsuranceRate()));
                        } else {
                            billUpEo.setInsureFee(new BigDecimal("0"));
                        }
                        billUpEo.setUpdateTime(new Date());
                    }
                    catch (Exception e) {
                        billUpEo.setReason(e.getMessage());
                        e.printStackTrace();
                        msg = e.getMessage();
                    }
                    finally {
                        Integer n5;
                        Object object;
                        if (StringUtils.isNotBlank((CharSequence)billUpEo.getReason())) {
                            billUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            for (Object eo : premiumUpEoList) {
                                eo.setReason(billUpEo.getReason());
                                eo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            }
                            premiumUpErrNum = premiumUpErrNum + premiumUpEoList.size();
                            object = billUpErrNum;
                            n5 = billUpErrNum = Integer.valueOf(billUpErrNum + 1);
                        } else {
                            premiumUpSuccNum = premiumUpSuccNum + premiumUpEoList.size();
                            object = billUpSuccNum;
                            n5 = billUpSuccNum = Integer.valueOf(billUpSuccNum + 1);
                        }
                        this.billService.updateInsurePremiumAndBill(billUpEo, premiumUpEoList);
                    }
                }
                pageNum = pageNum + pageSize;
                if (billEoList.size() < pageSize) {
                    billEoList = null;
                    continue;
                }
                billEoList.clear();
                billEoList = this.reInsuranceBillDas.selectList((BaseEo)searchBillEo, pageNum, pageSize);
            }
        }
        this.cacheService.delCache(BILL_UPDATE_LOCK_KEY);
        msg = "\u6267\u884c\u66f4\u65b0\u8d26\u5355\u6570\u636e\u5b8c\u6210:\u5f53\u524d\u5df2\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u6570\u636e" + premiumCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + premiumUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + premiumUpErrNum + "\u6761\uff1b\u5bf9\u5e94\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0" + billCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + billUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + billUpErrNum + "\u6761\u3002";
        if (billUpErrNum > 0) {
            msg = msg + "\u8bf7\u67e5\u770b\u5177\u4f53\u539f\u56e0\u91cd\u65b0\u4fee\u6b63\u540e\uff0c\u751f\u6210\u660e\u7ec6\u518d\u66f4\u65b0\u8d26\u5355";
        }
        this.logger.info(msg);
        return new RestResponse((Object)msg);
    }

    private void getCommonOtherData(ReInsuranceBillEo insuranceBillEo, Map<String, InsuranceCustomerInfoVo> physicsWareMap, Map<String, String> startPlaceMap) {
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)insuranceBillEo.getBusinessType());
        switch (typeEnum) {
            case ORDER_SALES_OUT: 
            case BAIJIAN_DIRECT_SALES: 
            case AGENCY_ORDER: {
                InsuranceCustomerInfoVo cusInfoVo = this.reInsurancePremiumDas.getOrderSalesOutData(insuranceBillEo.getRelevanceNo());
                if (cusInfoVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)cusInfoVo, (String[])new String[0]);
                break;
            }
            case OTHER_OUT: {
                InsuranceCustomerInfoVo otherOutVo = this.reInsurancePremiumDas.getOtherOutData(insuranceBillEo.getRelevanceNo());
                if (otherOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)otherOutVo, (String[])new String[0]);
                break;
            }
            case OUTSOURCE_REFUND: 
            case PURCHASE_REFUND: {
                InsuranceCustomerInfoVo refundVo = this.reInsurancePremiumDas.getOutResourceAndPurchaseRefundData(insuranceBillEo.getRelevanceNo());
                if (refundVo == null) break;
                insuranceBillEo.setOrderRemark(refundVo.getOrderRemark());
                insuranceBillEo.setExternalOrderNo(refundVo.getExternalOrderNo());
                break;
            }
            case ALLOT_OUT: 
            case ALLOT_OUT_ONLY: {
                InsuranceCustomerInfoVo allotOutVo = this.reInsurancePremiumDas.getAllotOutData(insuranceBillEo.getRelevanceNo(), physicsWareMap);
                if (allotOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)allotOutVo, (String[])new String[0]);
                break;
            }
            default: {
                insuranceBillEo.setRemark("\u83b7\u53d6\u5ba2\u6237\u5730\u5740\u3001\u5ba2\u6237\u540d\u79f0\u3001\u5916\u90e8\u5355\u53f7\u7b49\u6269\u5c55\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7c7b\u578b\u9519\u8bef\uff0c\u8be5\u7c7b\u578b\u3010" + insuranceBillEo.getBusinessType() + "\u3011\u4e0d\u5b58\u5728");
            }
        }
        insuranceBillEo.setStartPlace(this.reInsurancePremiumDas.getStartPlace(insuranceBillEo.getOutLogicWarehouseCode(), startPlaceMap));
        if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getDocumentNo())) {
            ConsignmentOrderAddressEo addressEo = this.reInsurancePremiumDas.queryAddress(insuranceBillEo.getDocumentNo());
            if (ObjectUtils.isNotEmpty((Object)addressEo)) {
                insuranceBillEo.setCustomerAddress(addressEo.getDetailAddress());
            } else {
                insuranceBillEo.setCustomerAddress(null);
            }
        }
    }

    @Override
    public String clearInsuranceByDate(ReInsurancePremiumReqDto reqDto) {
        List billEoList;
        List premiumEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list();
        if (CollectionUtils.isNotEmpty((Collection)premiumEoList)) {
            List ids = premiumEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsurancePremiumDas.logicDeleteByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(billEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsuranceBillDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list()))) {
            List ids = billEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsuranceBillDas.logicDeleteByIds(ids);
        }
        return null;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4fdd\u8d39\u660e\u7ec6\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumEo updateEo = new ReInsurancePremiumEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List reInsurancePremiumEos = this.reInsurancePremiumDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = reInsurancePremiumEos.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.reInsurancePremiumDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        this.logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillOrg(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fee\u6539\u4fdd\u8d39\u660e\u7ec6\u8ba1\u8d39\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumEo premiumEo = (ReInsurancePremiumEo)this.reInsurancePremiumDas.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)premiumEo), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        ReInsuranceBillEo billEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(premiumEo.getBillId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)premiumEo), (String)"\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        billEo.setBillOrgCode(reqDto.getBillOrgCode());
        billEo.setBillOrgName(reqDto.getBillOrgName());
        billEo.setOrderRemark(reqDto.getOrderRemark());
        billEo.setRemark(reqDto.getOrderRemark());
        this.reInsuranceBillDas.updateSelective((BaseEo)billEo);
        premiumEo.setOrderRemark(reqDto.getOrderRemark());
        premiumEo.setRemark(reqDto.getOrderRemark());
        this.reInsurancePremiumDas.updateSelective((BaseEo)premiumEo);
    }

    @Override
    public void generateInsuranceReportImport(ReInsuranceBillReqDto billReqDto) {
        int billQuotaVerify;
        String str;
        this.logger.info("\u5bfc\u5165\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\u548c\u8d26\u5355\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)billReqDto));
        ReInsuranceBillEo insuranceBillEo = (ReInsuranceBillEo)BeanUtil.copyProperties((Object)billReqDto, ReInsuranceBillEo.class, (String[])new String[0]);
        StringBuilder billReason = new StringBuilder();
        InsuranceFeeVo insuranceFeeVo = null;
        String orderShippingTime = DateUtil.getDateFormat((Date)insuranceBillEo.getInOutTime(), (String)"yyyy-MM-dd");
        HashMap insureMaps = new HashMap();
        List insureFeeList = this.reInsurancePremiumDas.getInsureFee(orderShippingTime, insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany());
        if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
            str = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
            billReason.append(str);
        } else if (insureFeeList.size() > 1) {
            str = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
            billReason.append(str);
        } else {
            insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
            insuranceBillEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
            this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
        }
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal insureTotalPrice = BigDecimal.ZERO;
        ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
        for (ReInsurancePremiumReqDto reqDto : billReqDto.getPremiumReqDtoList()) {
            ReInsurancePremiumEo premiumEo = (ReInsurancePremiumEo)BeanUtil.copyProperties((Object)reqDto, ReInsurancePremiumEo.class, (String[])new String[0]);
            premiumEo.setId(null);
            StringBuilder builder = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                premiumEo.setLogisticsSetttingsId(feeVo.getId());
                if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                    builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                } else {
                    if (premiumEo.getLongCode().startsWith("A.A")) {
                        premiumEo.setUseDiscount(feeVo.getProductDiscount());
                    } else {
                        premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                    }
                    premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                }
            }
            this.logger.info("\u8ba1\u7b97\u6295\u4fdd\u5355\u4ef7");
            if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
            }
            if (null == premiumEo.getUseDiscount() || null == premiumEo.getInsureUnitPrice()) {
                builder.append("[\u6295\u4fdd\u4ef7\u6216\u6298\u6263\u4e3a\u7a7a]");
            }
            insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
            quantity = quantity.add(premiumEo.getQuantity());
            if (builder.length() > 0) {
                premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
            } else {
                premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            }
            premiumEoList.add(premiumEo);
        }
        insuranceBillEo.setQuantity(quantity);
        insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
        insuranceBillEo.setBillingFeeFlag(Integer.valueOf(1));
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        this.logger.info("\u8ba1\u7b97\u4fdd\u8d39\u8d26\u5355\u7684\u4fdd\u8d39");
        int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
        if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
            insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
            if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                    insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                } else {
                    insuranceBillEo.setInsureFee(new BigDecimal("0"));
                }
            } else {
                billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
            }
        } else {
            billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
        }
        if (billReason.length() > 0) {
            insuranceBillEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
            insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
        } else {
            insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
        }
        insuranceBillEo.setPremiumEoList(premiumEoList);
        this.billService.addInsurePremiumAndBill(Lists.newArrayList((Object[])new ReInsuranceBillEo[]{insuranceBillEo}));
    }

    @Override
    public List<InsuranceItemVo> getPcpItemByLongCode(List<String> longCodes) {
        return this.reInsurancePremiumDas.getPcpItemByLongCode(longCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByIds(List<Long> ids) {
        this.logger.info("\u5220\u9664\u4fdd\u8d39\u8d39\u7528\uff1a{}", ids);
        List premiumEoList = this.reInsurancePremiumDas.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)premiumEoList)) {
            return;
        }
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664");
        premiumEoList.forEach(premiumEo -> {
            if (ObjectUtils.isNotEmpty((Object)premiumEo.getBillId())) {
                List premiumEos;
                ReInsuranceBillEo billEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(premiumEo.getBillId());
                if (ObjectUtils.isNotEmpty((Object)billEo)) {
                    this.reInsuranceBillDas.logicDeleteById(billEo.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)(premiumEos = ((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().eq((Object)"bill_id", (Object)premiumEo.getBillId())).list()))) {
                    List pIds = premiumEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.reInsurancePremiumDas.logicDeleteByIds(pIds);
                }
            } else {
                this.reInsurancePremiumDas.logicDeleteById(premiumEo.getId());
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ignoreExcByIds(List<Long> ids) {
        this.logger.info("\u5ffd\u7565\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(ids));
        List premiumEoList = this.reInsurancePremiumDas.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)premiumEoList), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u660e\u7ec6\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        List billIds = premiumEoList.stream().map(ReInsurancePremiumEo::getBillId).filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        List billEoList = this.reInsuranceBillDas.selectByIds(billIds);
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            List billPlacedFlagList = billEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
            AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(billPlacedFlagList), (String)"\u5b58\u5728\u5355\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        premiumEoList.forEach(eo -> {
            eo.setReason("");
            eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            this.reInsurancePremiumDas.updateSelective((BaseEo)eo);
        });
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            billEoList.forEach(eo -> {
                eo.setReason("");
                eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                this.reInsuranceBillDas.updateSelective((BaseEo)eo);
            });
        }
    }
}

