/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.utils;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYMMDDHHMM = "yyMMddHHmm";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_mm = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMM_CH = "yyyy\u5e74MM\u6708dd\u65e5hh:mm";
    public static final String YYYYMMDDHHMM_CH_24 = "yyyy\u5e74MM\u6708dd\u65e5HH:mm";
    public static final String YYMMDD = "yyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_mm_ss_SSS = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String HH_mm = "HH:mm";
    public static final String US_MM_DD = "dd MMM";

    private DateUtils() {
    }

    public static Date addDate(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(5, i);
        return c.getTime();
    }

    public static int diffByDay(Date time) {
        Date now = new Date();
        return DateUtils.diffByDay(time, now);
    }

    public static int diffByDay(Date var1, Date var2) {
        int day = (int)((var2.getTime() - var1.getTime()) / 86400000L);
        return day;
    }

    public static Calendar getCalendar(Date time) {
        Calendar c = Calendar.getInstance();
        if (null != time) {
            c.setTime(time);
        }
        return c;
    }

    public static Integer getDay(String deliverGoodsDate) {
        String str = deliverGoodsDate.split("-")[2];
        if (str.substring(0, 1).equals("0")) {
            return Integer.valueOf(str.replace("0", ""));
        }
        return Integer.valueOf(str);
    }

    public static Integer getDays(String date) {
        Date time = new Date();
        Date parse = com.dtyunxi.util.DateUtil.parse((String)date, (String)DatePattern.MONTH_PATTERN.getPattern());
        if (time.after(parse = DateUtils.getMaxMonthDate(parse))) {
            return DateUtils.getDaysOfMonth(parse);
        }
        return DateUtils.getMonthDay(time);
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static int getMonthDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static void main(String[] args) {
        Date preArriveimeStart = new Date();
        preArriveimeStart = com.dtyunxi.util.DateUtil.parse((String)String.format("%s %s", com.dtyunxi.util.DateUtil.format((Date)preArriveimeStart, (String)YYYY_MM_DD), "23:59:59"), (String)YYYY_MM_DD_HH_mm_ss);
        System.out.println(preArriveimeStart.after(DateUtils.getStartTime()));
    }

    public static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(13, 0);
        todayStart.set(12, 0);
        todayStart.set(11, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }
}

