/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.aop;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.override.MybatisMapperProxy;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.datalimit.aop.FilerMethod;
import com.dtyunxi.huieryun.datalimit.service.IMetaDataQueryService;
import com.dtyunxi.huieryun.datalimit.utils.ControlledEntityHolder;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitContext;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitRuleHandler;
import com.dtyunxi.huieryun.util.EoUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.persistence.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.CollectionUtils;

@Aspect
public class DataLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(DataLimitAspect.class);
    private static final Set<String> ALL_SKIP_TABLE_SET = new HashSet<String>(1);
    private final DataLimitRuleHandler dataLimitRuleHandler;
    private final IMetaDataQueryService metaDataQueryService;
    private static final ThreadLocal<Map<String, Integer>> LOCAL_STACK_MAP;
    private static final ThreadLocal<Set<String>> skipPermissionTables;
    private static final String AUTHORITY_SELECTOR = "data_limit_authority_selector";
    private static final String AUTHORITY_SELECTOR_IGNORE = "data_limit_authority_selector_ignore";
    private static final String AUTHORITY_SELECTOR_COUNTER = "data_limit_authority_selector_counter";

    public DataLimitAspect(DataLimitRuleHandler dataLimitRuleHandler, IMetaDataQueryService metaDataQueryService) {
        this.dataLimitRuleHandler = dataLimitRuleHandler;
        this.metaDataQueryService = metaDataQueryService;
        log.info("\u6269\u5c55\u6570\u636e\u6743\u9650\u62e6\u622a\u5df2\u5f00\u542f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(*  com.baomidou.mybatisplus.core.mapper.BaseMapper+.*(..)) || (execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.*(..)) && !execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.exists(..)))")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> eoClass = this.parseEoClass(joinPoint);
        if (null == eoClass || !eoClass.isAnnotationPresent(Table.class)) {
            return joinPoint.proceed(joinPoint.getArgs());
        }
        String tableName = eoClass.getAnnotation(Table.class).name();
        if (!CollectionUtils.isEmpty((Collection)DataLimitContext.getLimitRule((String)tableName))) {
            return joinPoint.proceed(joinPoint.getArgs());
        }
        try {
            this.dataLimitProcess(joinPoint, eoClass, tableName);
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            DataLimitContext.clear();
            this.clearStack(tableName);
            this.handlerCount();
        }
    }

    private void handlerCount() {
        Optional.ofNullable(ServiceContext.getContext().getAttachment(AUTHORITY_SELECTOR_COUNTER)).ifPresent(r -> {
            int c = Integer.parseInt(r) - 1;
            if (c <= 0) {
                ServiceContext.getContext().removeAttachment(AUTHORITY_SELECTOR_COUNTER);
                ServiceContext.getContext().removeAttachment(AUTHORITY_SELECTOR);
            } else {
                ServiceContext.getContext().setAttachment(AUTHORITY_SELECTOR_COUNTER, c + "");
            }
        });
    }

    private Class<?> parseEoClass(ProceedingJoinPoint joinPoint) {
        if (Objects.equals(ServiceContext.getContext().getAttachment(AUTHORITY_SELECTOR_IGNORE), AUTHORITY_SELECTOR_IGNORE)) {
            return null;
        }
        Optional.ofNullable(ServiceContext.getContext().getAttachment(AUTHORITY_SELECTOR_COUNTER));
        return Optional.ofNullable(ServiceContext.getContext().getAttachment(AUTHORITY_SELECTOR)).map(d -> {
            try {
                return Class.forName(d);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).orElseGet(() -> this.getEoClass(joinPoint));
    }

    @Nullable
    private Class getEoClass(ProceedingJoinPoint joinPoint) {
        return Optional.of(joinPoint).flatMap(f -> Optional.ofNullable(EoUtil.getGenericClass(joinPoint.getTarget().getClass()))).orElseGet(() -> Optional.ofNullable(FilerMethod.resolver(joinPoint.getSignature().getName())).map(d -> EoUtil.getGenericClass(DataLimitAspect.getProxyTargetClass(joinPoint.getThis()))).orElse(null));
    }

    private void dataLimitProcess(ProceedingJoinPoint joinPoint, Class<?> eoClass, String tableName) {
        if (this.skipEntityControl(tableName)) {
            log.info("\u8868{}\u5728\u5f53\u524d\u7ebf\u7a0b\u4e2d\u914d\u7f6e\u4e86\u5ffd\u7565\u6570\u636e\u6743\u9650\u3002", (Object)tableName);
        } else if (this.metaDataQueryService.isEntityUnderControl(tableName)) {
            this.setDasControl(joinPoint, tableName);
            log.info("{} \u662f\u53d7\u63a7\u5bf9\u8c61", (Object)tableName);
            if (!this.isAlreadyControl(tableName)) {
                List<String> subQueryList = this.dataLimitRuleHandler.getDataLimitSQL(eoClass, tableName);
                if (!CollectionUtils.isEmpty(subQueryList)) {
                    DataLimitContext.addLimitRule((String)tableName, subQueryList);
                    log.info("\u83b7\u53d6\u5230\u89c4\u5219:{}", JSON.toJSON(subQueryList));
                } else {
                    log.info("\u53d7\u63a7\u5bf9\u8c61{}\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e\u6743\u9650\u89c4\u5219!", (Object)tableName);
                }
            }
        } else {
            log.info("{} \u4e0d\u662f\u53d7\u63a7\u5bf9\u8c61\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u6743\u9650\u5904\u7406\u3002", (Object)tableName);
        }
    }

    private boolean skipEntityControl(String tableName) {
        Set<String> tables = skipPermissionTables.get();
        if (tables == null) {
            return false;
        }
        return tables.contains("*") || tables.contains(tableName.toLowerCase(Locale.ROOT));
    }

    public static void skipAllTable() {
        if (log.isDebugEnabled()) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            log.debug("{} line:{},\u65b9\u6cd5:{}\u8bbe\u7f6e\u4e86\u8df3\u8fc7\u6240\u6709\u8868", new Object[]{trace[0].getClassName(), trace[0].getLineNumber(), trace[0].getMethodName()});
        }
        skipPermissionTables.set(ALL_SKIP_TABLE_SET);
    }

    public static void skipAllTable(Consumer<Set<String>> consumer) {
        DataLimitAspect.skipAllTable();
        consumer.accept(ALL_SKIP_TABLE_SET);
    }

    public static void cleanSkipTable() {
        skipPermissionTables.remove();
        log.debug("\u6570\u636e\u6743\u9650\u5ffd\u7565\u8868\u914d\u7f6e\u5df2\u6e05\u7406");
    }

    public static Set<String> readSkipTable() {
        return skipPermissionTables.get();
    }

    public static Set<String> readSkipTable(Supplier<Set<String>> supplier) {
        Set<String> hystrixSkipTable = supplier.get();
        return !CollectionUtils.isEmpty(hystrixSkipTable) ? hystrixSkipTable : DataLimitAspect.readSkipTable();
    }

    public static void skipTables(String ... tables) {
        if (tables != null && tables.length != 0) {
            skipPermissionTables.set(new HashSet(tables.length));
            for (String table : tables) {
                skipPermissionTables.get().add(table);
            }
            if (log.isDebugEnabled()) {
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                log.debug("{} line:{},\u65b9\u6cd5:{}\u8bbe\u7f6e\u4e86\u5ffd\u7565\u8868:{}", new Object[]{trace[0].getClassName(), trace[0].getLineNumber(), trace[0].getMethodName(), tables});
            }
        } else {
            skipPermissionTables.remove();
            if (log.isDebugEnabled()) {
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                log.debug("{} line:{},\u65b9\u6cd5:{}\u6e05\u7a7a\u4e86\u5ffd\u7565\u8868\u914d\u7f6e", new Object[]{trace[0].getClassName(), trace[0].getLineNumber(), trace[0].getMethodName()});
            }
        }
    }

    public static void skipTables(Consumer<Set<String>> consumer, String ... tables) {
        DataLimitAspect.skipTables(tables);
        consumer.accept(skipPermissionTables.get());
    }

    private void setDasControl(ProceedingJoinPoint joinPoint, String tableName) {
        if (!ControlledEntityHolder.hasTable((String)tableName)) {
            try {
                ReflectUtil.invoke((Object)joinPoint.getTarget(), (String)"setEntityUnderControl", (Object[])new Object[]{true});
            }
            catch (Exception var4) {
                log.warn("\u8bbe\u7f6eDas\u5bf9\u8c61entityUnderControl\u5c5e\u6027\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bcube-framework-core\u7248\u672c\uff01{}", (Object)var4.getMessage());
            }
            ControlledEntityHolder.addTable((String)tableName);
        }
    }

    private boolean isAlreadyControl(String tableName) {
        Map<String, Integer> stringIntegerMap = LOCAL_STACK_MAP.get();
        if (stringIntegerMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            map.put(tableName, 1);
            LOCAL_STACK_MAP.set(map);
            return false;
        }
        Integer integer = stringIntegerMap.get(tableName);
        if (integer != null && integer != 0) {
            integer = integer + 1;
            stringIntegerMap.put(tableName, integer);
            if (log.isDebugEnabled()) {
                log.debug("{}\u8868\u5728\u5f53\u524d\u7ebf\u7a0b {} \u5df2\u7ecf\u62e6\u622a\u8fc7\u4e86", (Object)tableName, (Object)Thread.currentThread().getId());
            }
            return true;
        }
        stringIntegerMap.put(tableName, 1);
        return false;
    }

    private void clearStack(String key) {
        Map<String, Integer> stringIntegerMap = LOCAL_STACK_MAP.get();
        if (stringIntegerMap != null) {
            Integer integer = stringIntegerMap.get(key);
            if (integer != null) {
                if (integer > 1) {
                    integer = integer - 1;
                    stringIntegerMap.put(key, integer);
                } else {
                    stringIntegerMap.remove(key);
                }
            }
            if (stringIntegerMap.isEmpty()) {
                LOCAL_STACK_MAP.remove();
            }
        }
    }

    public static Class<?> getProxyTargetClass(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy.getClass();
        }
        try {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return DataLimitAspect.getJdkTargetClass(proxy);
            }
            return DataLimitAspect.getCglibTargetClass(proxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            return proxy.getClass();
        }
    }

    private static Class<?> getCglibTargetClass(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        Field t = Objects.requireNonNull(target).getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        return DataLimitAspect.getClass(target, t);
    }

    private static Class<?> getClass(Object target, Field t) throws IllegalAccessException, NoSuchFieldException {
        Object mapperProxy = t.get(target);
        Field mapperInterface = MybatisMapperProxy.class.getDeclaredField("mapperInterface");
        mapperInterface.setAccessible(true);
        return (Class)mapperInterface.get(mapperProxy);
    }

    private static Class<?> getJdkTargetClass(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        Field t = Objects.requireNonNull(target).getClass().getSuperclass().getDeclaredField("h");
        t.setAccessible(true);
        return DataLimitAspect.getClass(target, t);
    }

    static {
        ALL_SKIP_TABLE_SET.add("*");
        LOCAL_STACK_MAP = new ThreadLocal();
        skipPermissionTables = new ThreadLocal();
    }
}

