/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.apiimpl.ErpPriceApiImpl;
import com.dtyunxi.tcbj.app.open.biz.service.ZsjQueryPriceService;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.MdmRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmBasePriceReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.BasePriceApplyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.PullSuggestedPriceDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ZsjQueryPriceServiceImpl
implements ZsjQueryPriceService {
    private static final Logger logger = LoggerFactory.getLogger(ZsjQueryPriceServiceImpl.class);
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ErpPriceApiImpl erpPriceApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Resource
    private ZsjQueryPriceService zsjQueryPriceService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${querySuggestedPriceUrl:https://zsjjk.by-health.com/api/mdm/getModelDatas}")
    private String querySuggestedPriceUrl;

    private BigDecimal querySuggestedPrice(String skuCode, String thirdPartyId) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("modelCode", "PROD_ORG_REL");
        jsonMap.put("queryCondition", "EASNO=" + skuCode + ";ORGID=" + thirdPartyId);
        jsonMap.put("queryField", "PRICE");
        jsonMap.put("dataType", "json");
        jsonMap.put("isVague", "no");
        jsonMap.put("userName", "xbsc");
        jsonMap.put("password", "80ddaa767f36cac0e946c11b6ea12e85");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSON.toJSONString(jsonMap), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.querySuggestedPriceUrl, (Object)formEntity, String.class, new Object[0]);
        MdmReqDto returnValueDto = (MdmReqDto)JSONObject.parseObject((String)((String)response.getBody()), MdmReqDto.class);
        logger.info("\u4e3b\u6570\u636e\u67e5\u8be2\u4ef7\u683c\u7ed3\u679c param={}; result:{}", jsonMap, (Object)returnValueDto);
        if (returnValueDto.getLIST() == null || returnValueDto.getLIST().isEmpty()) {
            logger.info("\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c \u8df3\u8fc7");
            return null;
        }
        if (returnValueDto.getLIST().size() != 1) {
            logger.info("\u4e3b\u6570\u636e\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c\u4e0d\u552f\u4e00 \u8df3\u8fc7");
            return null;
        }
        JSONObject returnObj = (JSONObject)returnValueDto.getLIST().get(0);
        JSONObject PROD_ORG_REL = (JSONObject)returnObj.get((Object)"PROD_ORG_REL");
        if (PROD_ORG_REL == null) {
            logger.info("\u4e3b\u6570\u636e\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38 \u8df3\u8fc7");
            return null;
        }
        return new BigDecimal(PROD_ORG_REL.get((Object)"PRICE").toString());
    }

    private MdmReqDto<MdmBasePriceReqDto> getAddPriceParam(List<BasePriceApplyReqDto> pullDate) {
        MdmReqDto param = new MdmReqDto();
        ArrayList list = new ArrayList();
        pullDate.forEach(e -> list.add(MdmBasePriceReqDto.builder().PROD_ORG_REL(BasePriceApplyReqDto.builder().channel(Integer.valueOf(2)).PRICE(e.getPRICE()).PRICETYPE(Long.valueOf(1L)).SKUCODE(e.getSKUCODE()).THIRDORGID(e.getTHIRDORGID()).build()).CIDP_TASK_UUID(UUID.randomUUID().toString().replace("-", "")).build()));
        param.setLIST(list);
        return param;
    }

    @Override
    public MdmRespDto pullSuggestedPrice(List<PullSuggestedPriceDto> dtoList) {
        logger.info("pullSuggestedPrice start. dtoList={}", (Object)JSONObject.toJSONString(dtoList));
        ArrayList<BasePriceApplyReqDto> pullData = new ArrayList<BasePriceApplyReqDto>();
        dtoList.forEach(e -> {
            BasePriceItemRespDto basePriceApplyItem = this.queryBasePriceItem(e.getLongCode(), e.getOrganizationId());
            if (basePriceApplyItem != null) {
                logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7 \u4ef7\u683c\u5df2\u5b58\u5728 \u8df3\u8fc7 basePriceApplyItem={}", (Object)JSONObject.toJSONString((Object)basePriceApplyItem));
                return;
            }
            logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7 \u4ef7\u683c\u4e0d\u5b58\u5728 \u4ece\u4e3b\u6570\u636e\u540c\u6b65");
            BigDecimal price = this.querySuggestedPrice(e.getLongCode(), e.getThirdPartyId());
            if (price == null) {
                logger.info("\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c \u8df3\u8fc7");
                return;
            }
            BasePriceApplyReqDto basePriceApplyReqDto = BasePriceApplyReqDto.builder().PRICE(price).SKUCODE(e.getLongCode()).THIRDORGID(e.getThirdPartyId()).build();
            logger.info("\u4e3b\u6570\u636e\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c add to list. basePriceApplyReqDto={}", (Object)JSONObject.toJSONString((Object)basePriceApplyReqDto));
            pullData.add(basePriceApplyReqDto);
        });
        if (!pullData.isEmpty()) {
            MdmReqDto<MdmBasePriceReqDto> paramData = this.getAddPriceParam(pullData);
            logger.info("\u5199\u5165\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7 paramData={}", (Object)JSONObject.toJSONString(paramData));
            MdmRespDto mdmRespDto = this.erpPriceApi.addBasePriceApplyAndAudit(paramData);
            logger.info("pullSuggestedPrice end.");
            return mdmRespDto;
        }
        logger.info("\u9700\u8981\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a \u4e0d\u5904\u7406");
        logger.info("pullSuggestedPrice end.");
        return null;
    }

    private BasePriceItemRespDto queryBasePriceItem(String longCode, String organizationId) {
        BasePriceItemQueryReqDto reqDto = new BasePriceItemQueryReqDto();
        reqDto.setSkuCode(longCode);
        reqDto.setItemOrgId(Long.valueOf(organizationId));
        reqDto.setTypeId(Long.valueOf(1L));
        List basePriceApplyItemList = (List)RestUtil.checkResponse(this.basePriceItemQueryApi.queryByList(reqDto));
        logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c \u67e5\u8be2\u53c2\u6570param={}; \u67e5\u8be2\u7ed3\u679cresult={}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)JSONObject.toJSONString((Object)basePriceApplyItemList));
        if (basePriceApplyItemList == null || basePriceApplyItemList.isEmpty()) {
            return null;
        }
        if (basePriceApplyItemList.size() != 1) {
            throw new BizException("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38 \u4ef7\u683c\u6570\u636e\u6761\u6570\u4e3a:" + basePriceApplyItemList.size());
        }
        return (BasePriceItemRespDto)basePriceApplyItemList.get(0);
    }
}

