/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.tcbj.api.IItemInfoApi;
import com.dtyunxi.tcbj.api.dto.request.QueryItemOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemWithoutSuggestedPriceRespDto;
import com.dtyunxi.tcbj.app.open.biz.service.ZsjQueryPriceService;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.MdmRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.PullSuggestedPriceDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="syncPullSuggestedPriceScheduler")
@Scope(value="prototype")
public class SyncPullSuggestedPriceScheduler
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(SyncPullSuggestedPriceScheduler.class);
    @Resource
    private ZsjQueryPriceService zsjQueryPriceService;
    @Resource
    private IItemInfoApi itemInfoApi;

    public boolean execute(TaskMsg taskMsg) {
        try {
            Date date = new Date();
            log.info("\u89e6\u53d1\u4efb\u52a1: \u540c\u6b65\u5efa\u8bae\u96f6\u552e\u4ef7: {} ", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)date));
            List queryList = (List)RestUtil.checkResponse(this.itemInfoApi.queryItemWithoutSuggestedPrice(new QueryItemOrgInfoReqDto()));
            log.info("\u67e5\u8be2\u6ca1\u6709\u5efa\u8bae\u96f6\u552e\u4ef7\u7684item queryList={}", (Object)JSONObject.toJSONString((Object)queryList));
            if (queryList.isEmpty()) {
                return true;
            }
            ArrayList<PullSuggestedPriceDto> dtoList = new ArrayList<PullSuggestedPriceDto>();
            for (QueryItemWithoutSuggestedPriceRespDto queryDto : queryList) {
                PullSuggestedPriceDto pullSuggestedPriceDto = new PullSuggestedPriceDto();
                BeanUtils.copyProperties((Object)queryDto, (Object)pullSuggestedPriceDto);
                dtoList.add(pullSuggestedPriceDto);
            }
            log.info("\u8c03\u7528\u540c\u6b65\u5efa\u8bae\u96f6\u552e\u4ef7rest\u63a5\u53e3\u7684service param={}", (Object)JSONObject.toJSONString(dtoList));
            MdmRespDto mdmRespDto = this.zsjQueryPriceService.pullSuggestedPrice(dtoList);
            log.info("\u540c\u6b65\u7ed3\u679c mdmRespDto={}", (Object)JSONObject.toJSONString((Object)mdmRespDto));
            log.info("\u4efb\u52a1\u7ed3\u675f: \u540c\u6b65\u5efa\u8bae\u96f6\u552e\u4ef7: {} ", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void before(TaskMsg taskMsg) {
    }

    public void after(TaskMsg taskMsg) {
    }
}

